/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.ws.RealWebSocket;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0002PQB'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ9\u0010\u0014\u001a\u00028\u0000\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0018J\r\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\b \u0010\u0018J\r\u0010!\u001a\u00020\u0016\u00a2\u0006\u0004\b!\u0010\u0018J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0016\u00a2\u0006\u0004\b%\u0010\u0018J\r\u0010&\u001a\u00020\u0016\u00a2\u0006\u0004\b&\u0010\u0018J\u0015\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010,\u001a\u00020\u0010\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\u0016\u00a2\u0006\u0004\b2\u0010\u0018J\u0017\u00103\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020\u0016\u00a2\u0006\u0004\b5\u0010\u0018J\u0015\u00106\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b6\u00107R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010:R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010;R\u001a\u0010=\u001a\u00020<8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010A\u001a\u0004\bB\u0010CR\u001a\u0010\u0007\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010D\u001a\u0004\bE\u0010FR$\u0010H\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00108\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR\u0014\u0010M\u001a\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010KR$\u0010N\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00108\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bN\u0010I\u001a\u0004\bO\u0010K"}, d2={"Lokhttp3/internal/connection/Exchange;", "", "Lokhttp3/internal/connection/RealCall;", "call", "Lokhttp3/EventListener;", "eventListener", "Lokhttp3/internal/connection/ExchangeFinder;", "finder", "Lokhttp3/internal/http/ExchangeCodec;", "codec", "<init>", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;Lokhttp3/internal/connection/ExchangeFinder;Lokhttp3/internal/http/ExchangeCodec;)V", "Ljava/io/IOException;", "E", "", "bytesRead", "", "responseDone", "requestDone", "e", "bodyComplete", "(JZZLjava/io/IOException;)Ljava/io/IOException;", "", "cancel", "()V", "Lokhttp3/Request;", "request", "duplex", "Lokio/Sink;", "createRequestBody", "(Lokhttp3/Request;Z)Lokio/Sink;", "detachWithViolence", "finishRequest", "flushRequest", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "newWebSocketStreams", "()Lokhttp3/internal/ws/RealWebSocket$Streams;", "noNewExchangesOnConnection", "noRequestBody", "Lokhttp3/Response;", "response", "Lokhttp3/ResponseBody;", "openResponseBody", "(Lokhttp3/Response;)Lokhttp3/ResponseBody;", "expectContinue", "Lokhttp3/Response$Builder;", "readResponseHeaders", "(Z)Lokhttp3/Response$Builder;", "responseHeadersEnd", "(Lokhttp3/Response;)V", "responseHeadersStart", "trackFailure", "(Ljava/io/IOException;)V", "webSocketUpgradeFailed", "writeRequestHeaders", "(Lokhttp3/Request;)V", "Lokhttp3/internal/connection/RealCall;", "getCall$okhttp", "()Lokhttp3/internal/connection/RealCall;", "Lokhttp3/internal/http/ExchangeCodec;", "Lokhttp3/internal/connection/RealConnection;", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnection$okhttp", "()Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "Lokhttp3/internal/connection/ExchangeFinder;", "getFinder$okhttp", "()Lokhttp3/internal/connection/ExchangeFinder;", "<set-?>", "hasFailure", "Z", "getHasFailure$okhttp", "()Z", "isCoalescedConnection$okhttp", "isCoalescedConnection", "isDuplex", "isDuplex$okhttp", "RequestBodySink", "ResponseBodySource"})
public final class Exchange {
    private final RealCall call;
    private final EventListener eventListener;
    private final ExchangeFinder finder;
    private final ExchangeCodec codec;
    private boolean isDuplex;
    private boolean hasFailure;
    private final RealConnection connection;

    /*
     * WARNING - void declaration
     */
    public Exchange(RealCall call, EventListener eventListener, ExchangeFinder finder, ExchangeCodec codec) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.call = var1_1;
        this.eventListener = var2_2;
        this.finder = var3_3;
        this.codec = codec;
        this.connection = this.codec.getConnection();
    }

    public final RealCall getCall$okhttp() {
        return this.call;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final ExchangeFinder getFinder$okhttp() {
        return this.finder;
    }

    public final boolean isDuplex$okhttp() {
        return this.isDuplex;
    }

    public final boolean getHasFailure$okhttp() {
        return this.hasFailure;
    }

    public final RealConnection getConnection$okhttp() {
        return this.connection;
    }

    public final boolean isCoalescedConnection$okhttp() {
        return !Intrinsics.areEqual((Object)this.finder.getAddress$okhttp().url().host(), (Object)this.connection.route().address().url().host());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRequestHeaders(Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            this.eventListener.requestHeadersStart(this.call);
            this.codec.writeRequestHeaders(request);
            this.eventListener.requestHeadersEnd(this.call, request);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Sink createRequestBody(Request request, boolean duplex) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.isDuplex = var2_2;
        RequestBody requestBody = request.body();
        Intrinsics.checkNotNull((Object)requestBody);
        long contentLength = requestBody.contentLength();
        this.eventListener.requestBodyStart(this.call);
        Sink rawRequestBody = this.codec.createRequestBody(request, contentLength);
        return (Sink)new RequestBodySink(this, (Sink)var1_1, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void flushRequest() throws IOException {
        try {
            this.codec.flushRequest();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void finishRequest() throws IOException {
        try {
            this.codec.finishRequest();
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.eventListener.requestFailed(this.call, e);
            this.trackFailure(e);
            throw var1_1;
        }
    }

    public final void responseHeadersStart() {
        this.eventListener.responseHeadersStart(this.call);
    }

    /*
     * WARNING - void declaration
     */
    public final Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        try {
            Response.Builder result = this.codec.readResponseHeaders(expectContinue);
            if (result != null) {
                result.initExchange$okhttp(this);
            }
            return result;
        }
        catch (IOException e) {
            void var1_3;
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw var1_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void responseHeadersEnd(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.eventListener.responseHeadersEnd(this.call, (Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ResponseBody openResponseBody(Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            void var1_1;
            void var3_4;
            String contentType = Response.header$default(response, "Content-Type", null, 2, null);
            long contentLength = this.codec.reportedContentLength(response);
            Source rawSource = this.codec.openResponseBodySource(response);
            ResponseBodySource source = new ResponseBodySource(this, rawSource, contentLength);
            return new RealResponseBody(contentType, (long)var3_4, Okio.buffer((Source)((Source)var1_1)));
        }
        catch (IOException e) {
            void var2_3;
            this.eventListener.responseFailed(this.call, e);
            this.trackFailure(e);
            throw var2_3;
        }
    }

    public final RealWebSocket.Streams newWebSocketStreams() throws SocketException {
        this.call.timeoutEarlyExit();
        return this.codec.getConnection().newWebSocketStreams$okhttp(this);
    }

    public final void webSocketUpgradeFailed() {
        this.bodyComplete(-1L, true, true, null);
    }

    public final void noNewExchangesOnConnection() {
        this.codec.getConnection().noNewExchanges$okhttp();
    }

    public final void cancel() {
        this.codec.cancel();
    }

    public final void detachWithViolence() {
        this.codec.cancel();
        this.call.messageDone$okhttp(this, true, true, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void trackFailure(IOException e) {
        void var1_1;
        this.hasFailure = true;
        this.finder.trackFailure(e);
        this.codec.getConnection().trackFailure$okhttp(this.call, (IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <E extends IOException> E bodyComplete(long bytesRead, boolean responseDone, boolean requestDone, E e) {
        void var3_2;
        if (e != null) {
            this.trackFailure(e);
        }
        if (requestDone) {
            if (e != null) {
                this.eventListener.requestFailed(this.call, e);
            } else {
                this.eventListener.requestBodyEnd(this.call, bytesRead);
            }
        }
        if (responseDone) {
            if (e != null) {
                this.eventListener.responseFailed(this.call, e);
            } else {
                void var1_1;
                this.eventListener.responseBodyEnd(this.call, (long)var1_1);
            }
        }
        return this.call.messageDone$okhttp(this, requestDone, (boolean)var3_2, e);
    }

    public final void noRequestBody() {
        this.call.messageDone$okhttp(this, true, false, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000e\u001a\u00028\u0000\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\nJ\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017"}, d2={"Lokhttp3/internal/connection/Exchange$RequestBodySink;", "Lokio/ForwardingSink;", "Lokio/Sink;", "delegate", "", "contentLength", "<init>", "(Lokhttp3/internal/connection/Exchange;Lokio/Sink;J)V", "", "close", "()V", "Ljava/io/IOException;", "E", "e", "complete", "(Ljava/io/IOException;)Ljava/io/IOException;", "flush", "Lokio/Buffer;", "source", "byteCount", "write", "(Lokio/Buffer;J)V", "bytesReceived", "J", "", "closed", "Z", "completed"})
    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$RequestBodySink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    private final class RequestBodySink
    extends ForwardingSink {
        private final long contentLength;
        private boolean completed;
        private long bytesReceived;
        private boolean closed;
        final /* synthetic */ Exchange this$0;

        /*
         * WARNING - void declaration
         */
        public RequestBodySink(Exchange this$0, Sink delegate, long contentLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.this$0 = var1_1;
            super((Sink)var2_2);
            this.contentLength = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            if (this.contentLength != -1L && this.bytesReceived + byteCount > this.contentLength) {
                throw new ProtocolException("expected " + this.contentLength + " bytes but received " + (this.bytesReceived + byteCount));
            }
            try {
                void var2_3;
                super.write((Buffer)source, byteCount);
                this.bytesReceived += var2_3;
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw this.complete(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void flush() throws IOException {
            try {
                super.flush();
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.contentLength != -1L && this.bytesReceived != this.contentLength) {
                throw new ProtocolException("unexpected end of stream");
            }
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final <E extends IOException> E complete(E e) {
            void var1_1;
            if (this.completed) {
                return e;
            }
            this.completed = true;
            return this.this$0.bodyComplete(this.bytesReceived, false, true, var1_1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00028\u0000\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0016\u0010\u001b\u001a\u00020\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019"}, d2={"Lokhttp3/internal/connection/Exchange$ResponseBodySource;", "Lokio/ForwardingSource;", "Lokio/Source;", "delegate", "", "contentLength", "<init>", "(Lokhttp3/internal/connection/Exchange;Lokio/Source;J)V", "", "close", "()V", "Ljava/io/IOException;", "E", "e", "complete", "(Ljava/io/IOException;)Ljava/io/IOException;", "Lokio/Buffer;", "sink", "byteCount", "read", "(Lokio/Buffer;J)J", "bytesReceived", "J", "", "closed", "Z", "completed", "invokeStartEvent"})
    @SourceDebugExtension(value={"SMAP\nExchange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Exchange.kt\nokhttp3/internal/connection/Exchange$ResponseBodySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    public final class ResponseBodySource
    extends ForwardingSource {
        private final long contentLength;
        private long bytesReceived;
        private boolean invokeStartEvent;
        private boolean completed;
        private boolean closed;
        final /* synthetic */ Exchange this$0;

        /*
         * WARNING - void declaration
         */
        public ResponseBodySource(Exchange this$0, Source delegate, long contentLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.this$0 = var1_1;
            super((Source)var2_2);
            this.contentLength = var3_3;
            this.invokeStartEvent = true;
            if (this.contentLength == 0L) {
                this.complete(null);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(!this.closed)) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            try {
                void var2_2;
                void var1_1;
                long read = this.delegate().read((Buffer)var1_1, (long)var2_2);
                if (this.invokeStartEvent) {
                    this.invokeStartEvent = false;
                    this.this$0.getEventListener$okhttp().responseBodyStart(this.this$0.getCall$okhttp());
                }
                if (read == -1L) {
                    this.complete(null);
                    return -1L;
                }
                long newBytesReceived = this.bytesReceived + read;
                if (this.contentLength != -1L && newBytesReceived > this.contentLength) {
                    throw new ProtocolException("expected " + this.contentLength + " bytes but received " + newBytesReceived);
                }
                this.bytesReceived = newBytesReceived;
                if (newBytesReceived == this.contentLength) {
                    this.complete(null);
                }
                return read;
            }
            catch (IOException e) {
                throw this.complete(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
                this.complete(null);
                return;
            }
            catch (IOException e) {
                void var1_1;
                throw this.complete(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final <E extends IOException> E complete(E e) {
            void var1_1;
            if (this.completed) {
                return e;
            }
            this.completed = true;
            if (e == null && this.invokeStartEvent) {
                this.invokeStartEvent = false;
                this.this$0.getEventListener$okhttp().responseBodyStart(this.this$0.getCall$okhttp());
            }
            return this.this$0.bodyComplete(this.bytesReceived, true, false, var1_1);
        }
    }
}

