/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskQueue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0003.-/B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010 R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,"}, d2={"Lokhttp3/internal/concurrent/TaskRunner;", "", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "backend", "<init>", "(Lokhttp3/internal/concurrent/TaskRunner$Backend;)V", "Lokhttp3/internal/concurrent/Task;", "task", "", "delayNanos", "", "afterRun", "(Lokhttp3/internal/concurrent/Task;J)V", "awaitTaskToRun", "()Lokhttp3/internal/concurrent/Task;", "beforeRun", "(Lokhttp3/internal/concurrent/Task;)V", "cancelAll", "()V", "Lokhttp3/internal/concurrent/TaskQueue;", "taskQueue", "kickCoordinator$okhttp", "(Lokhttp3/internal/concurrent/TaskQueue;)V", "kickCoordinator", "newQueue", "()Lokhttp3/internal/concurrent/TaskQueue;", "runTask", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "getBackend", "()Lokhttp3/internal/concurrent/TaskRunner$Backend;", "", "busyQueues", "Ljava/util/List;", "", "coordinatorWaiting", "Z", "coordinatorWakeUpAt", "J", "", "nextQueueName", "I", "readyQueues", "Ljava/lang/Runnable;", "runnable", "Ljava/lang/Runnable;", "Companion", "Backend", "RealBackend"})
@SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n+ 2 Util.kt\nokhttp3/internal/Util\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n608#2,4:315\n608#2,4:319\n615#2,4:323\n608#2,4:327\n608#2,4:331\n1#3:335\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n*L\n79#1:315,4\n97#1:319,4\n108#1:323,4\n126#1:327,4\n152#1:331,4\n*E\n"})
public final class TaskRunner {
    public static final Companion Companion = new Companion(null);
    private final Backend backend;
    private int nextQueueName;
    private boolean coordinatorWaiting;
    private long coordinatorWakeUpAt;
    private final List<TaskQueue> busyQueues;
    private final List<TaskQueue> readyQueues;
    private final Runnable runnable;
    @JvmField
    public static final TaskRunner INSTANCE = new TaskRunner(new RealBackend(Util.threadFactory(Util.okHttpName + " TaskRunner", true)));
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public TaskRunner(Backend backend) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        this.backend = var1_1;
        this.nextQueueName = 10000;
        this.busyQueues = new ArrayList();
        this.readyQueues = new ArrayList();
        this.runnable = new Runnable(this){
            final /* synthetic */ TaskRunner this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * Unable to fully structure code
             */
            public final void run() {
                while (true) lbl-1000:
                // 3 sources

                {
                    var3_3 = this.this$0;
                    var1_1 = this.this$0;
                    var5_7 = var3_3;
                    synchronized (var5_7) {
                        var6_8 = var1_1.awaitTaskToRun();
                    }
                    if (var6_8 == null) {
                        return;
                    }
                    Intrinsics.checkNotNull((Object)task.getQueue$okhttp());
                    var3_3 = this.this$0;
                    startNs$iv = -1L;
                    loggingEnabled$iv = TaskRunner.Companion.getLogger().isLoggable(Level.FINE);
                    if (loggingEnabled$iv) {
                        startNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime();
                        TaskLoggerKt.access$log(task, (TaskQueue)queue$iv, "starting");
                    }
                    completedNormally$iv = false;
                    try {
                        TaskRunner.access$runTask(var3_3, task);
                    }
                    catch (Throwable var8_12) {
                        var3_3.getBackend().execute(this);
                        throw var8_12;
                    }
                    completedNormally$iv = true;
                    if (!loggingEnabled$iv) continue;
                    elapsedNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                    break;
                }
                catch (Throwable var3_4) {
                    if (loggingEnabled$iv) {
                        elapsedNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                        if (completedNormally$iv) {
                            TaskLoggerKt.access$log(task, (TaskQueue)queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                        } else {
                            TaskLoggerKt.access$log((Task)var1_1, var2_2, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                        }
                    }
                    throw var3_4;
                }
                {
                    TaskLoggerKt.access$log(task, (TaskQueue)queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                    ** while (true)
                }
            }
        };
    }

    public final Backend getBackend() {
        return this.backend;
    }

    /*
     * WARNING - void declaration
     */
    public final void kickCoordinator$okhttp(TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter((Object)taskQueue, (String)"taskQueue");
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (taskQueue.getActiveTask$okhttp() == null) {
            if (!((Collection)taskQueue.getFutureTasks$okhttp()).isEmpty()) {
                Util.addIfAbsent(this.readyQueues, taskQueue);
            } else {
                void var1_1;
                this.readyQueues.remove(var1_1);
            }
        }
        if (this.coordinatorWaiting) {
            this.backend.coordinatorNotify(this);
            return;
        }
        this.backend.execute(this.runnable);
    }

    /*
     * WARNING - void declaration
     */
    private final void beforeRun(Task task) {
        void var2_2;
        void var1_1;
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        task.setNextExecuteNanoTime$okhttp(-1L);
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull((Object)taskQueue);
        TaskQueue queue = taskQueue;
        taskQueue.getFutureTasks$okhttp().remove(task);
        this.readyQueues.remove(queue);
        queue.setActiveTask$okhttp((Task)var1_1);
        this.busyQueues.add((TaskQueue)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void runTask(Task task) {
        TaskRunner taskRunner;
        long delayNanos;
        TaskRunner $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(task.getName());
        try {
            delayNanos = task.runOnce();
            taskRunner = this;
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            TaskRunner taskRunner2 = this;
            synchronized (taskRunner2) {
                void var1_1;
                this.afterRun((Task)var1_1, -1L);
            }
            var2_3.setName((String)var3_4);
            throw throwable;
        }
        synchronized (taskRunner) {
            this.afterRun(task, delayNanos);
        }
        currentThread.setName(oldName);
    }

    /*
     * WARNING - void declaration
     */
    private final void afterRun(Task task, long delayNanos) {
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        TaskQueue taskQueue = ((Task)task).getQueue$okhttp();
        Intrinsics.checkNotNull((Object)taskQueue);
        TaskQueue queue = taskQueue;
        if (!(taskQueue.getActiveTask$okhttp() == task)) {
            task = "Check failed.";
            throw new IllegalStateException(task.toString());
        }
        boolean cancelActiveTask = queue.getCancelActiveTask$okhttp();
        queue.setCancelActiveTask$okhttp(false);
        queue.setActiveTask$okhttp(null);
        this.busyQueues.remove(queue);
        if (delayNanos != -1L && !cancelActiveTask && !queue.getShutdown$okhttp()) {
            void var2_2;
            void var1_1;
            queue.scheduleAndDecide$okhttp((Task)var1_1, (long)var2_2, true);
        }
        if (!((Collection)queue.getFutureTasks$okhttp()).isEmpty()) {
            this.readyQueues.add(queue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Task awaitTaskToRun() {
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        while (!this.readyQueues.isEmpty()) {
            void var1_2;
            long now = this.backend.nanoTime();
            long minDelayNanos = Long.MAX_VALUE;
            Task readyTask = null;
            boolean multipleReadyTasks = false;
            for (TaskQueue taskQueue : this.readyQueues) {
                Task candidate = taskQueue.getFutureTasks$okhttp().get(0);
                long candidateDelay = Math.max(0L, candidate.getNextExecuteNanoTime$okhttp() - now);
                if (candidateDelay > 0L) {
                    minDelayNanos = Math.min(candidateDelay, minDelayNanos);
                    continue;
                }
                if (readyTask != null) {
                    multipleReadyTasks = true;
                    break;
                }
                readyTask = candidate;
            }
            if (readyTask != null) {
                this.beforeRun(readyTask);
                if (multipleReadyTasks || !this.coordinatorWaiting && !((Collection)this.readyQueues).isEmpty()) {
                    this.backend.execute(this.runnable);
                }
                return readyTask;
            }
            if (this.coordinatorWaiting) {
                if (minDelayNanos < this.coordinatorWakeUpAt - now) {
                    this.backend.coordinatorNotify(this);
                }
                return null;
            }
            this.coordinatorWaiting = true;
            this.coordinatorWakeUpAt = var1_2 + minDelayNanos;
            try {
                void var3_3;
                this.backend.coordinatorWait(this, (long)var3_3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.cancelAll();
                continue;
            }
            finally {
                this.coordinatorWaiting = false;
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final TaskQueue newQueue() {
        void var1_2;
        int n;
        TaskRunner taskRunner = this;
        synchronized (taskRunner) {
            n = this.nextQueueName;
            this.nextQueueName = n + 1;
        }
        int name = n;
        return new TaskQueue(this, "Q" + (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelAll() {
        int i;
        for (i = this.busyQueues.size() - 1; i >= 0; --i) {
            this.busyQueues.get(i).cancelAllAndDecide$okhttp();
        }
        for (i = this.readyQueues.size() - 1; i >= 0; --i) {
            void var2_2;
            TaskQueue queue = this.readyQueues.get(i);
            queue.cancelAllAndDecide$okhttp();
            if (!var2_2.getFutureTasks$okhttp().isEmpty()) continue;
            this.readyQueues.remove(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$runTask(TaskRunner $this, Task task) {
        void var1_1;
        $this.runTask((Task)var1_1);
    }

    static {
        Logger logger = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TaskRunner::class.java.name)");
        TaskRunner.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Backend;", "", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "coordinatorNotify", "(Lokhttp3/internal/concurrent/TaskRunner;)V", "", "nanos", "coordinatorWait", "(Lokhttp3/internal/concurrent/TaskRunner;J)V", "Ljava/lang/Runnable;", "runnable", "execute", "(Ljava/lang/Runnable;)V", "nanoTime", "()J"})
    public static interface Backend {
        public long nanoTime();

        public void coordinatorNotify(TaskRunner var1);

        public void coordinatorWait(TaskRunner var1, long var2);

        public void execute(Runnable var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Companion;", "", "<init>", "()V", "Lokhttp3/internal/concurrent/TaskRunner;", "INSTANCE", "Lokhttp3/internal/concurrent/TaskRunner;", "Ljava/util/logging/Logger;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "Ljava/util/concurrent/ThreadFactory;", "threadFactory", "<init>", "(Ljava/util/concurrent/ThreadFactory;)V", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunner", "", "coordinatorNotify", "(Lokhttp3/internal/concurrent/TaskRunner;)V", "", "nanos", "coordinatorWait", "(Lokhttp3/internal/concurrent/TaskRunner;J)V", "Ljava/lang/Runnable;", "runnable", "execute", "(Ljava/lang/Runnable;)V", "nanoTime", "()J", "Ljava/util/concurrent/ThreadPoolExecutor;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;"})
    @SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,314:1\n560#2:315\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n*L\n281#1:315\n*E\n"})
    public static final class RealBackend
    implements Backend {
        private final ThreadPoolExecutor executor;

        /*
         * WARNING - void declaration
         */
        public RealBackend(ThreadFactory threadFactory) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), (ThreadFactory)var1_1);
        }

        @Override
        public final long nanoTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorNotify(TaskRunner taskRunner) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            ((Object)var1_1).notify();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorWait(TaskRunner taskRunner, long nanos) throws InterruptedException {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            long ms = nanos / 1000000L;
            long ns = nanos - ms * 1000000L;
            if (ms > 0L || var2_2 > 0L) {
                void var1_1;
                ((Object)var1_1).wait(ms, (int)ns);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable runnable2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            this.executor.execute((Runnable)var1_1);
        }
    }
}

