/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\n\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "Lokhttp3/Cache;", "cache", "<init>", "(Lokhttp3/Cache;)V", "Lokhttp3/internal/cache/CacheRequest;", "cacheRequest", "Lokhttp3/Response;", "response", "cacheWritingResponse", "(Lokhttp3/internal/cache/CacheRequest;Lokhttp3/Response;)Lokhttp3/Response;", "Lokhttp3/Interceptor$Chain;", "chain", "intercept", "(Lokhttp3/Interceptor$Chain;)Lokhttp3/Response;", "Lokhttp3/Cache;", "Companion"})
public final class CacheInterceptor
implements Interceptor {
    public static final Companion Companion = new Companion(null);
    public final Cache cache;

    /*
     * WARNING - void declaration
     */
    public CacheInterceptor(Cache cache) {
        void var1_1;
        this.cache = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Response networkResponse;
        Object listener;
        Response cacheResponse;
        Request networkRequest;
        Call call;
        block23: {
            ResponseBody responseBody;
            Object object;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            call = chain.call();
            Cache cache = this.cache;
            Response cacheCandidate = cache != null ? cache.get$okhttp(chain.request()) : null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(strategy);
            }
            if ((object = call instanceof RealCall ? (RealCall)call : null) == null || (object = ((RealCall)object).getEventListener$okhttp()) == null) {
                object = listener = EventListener.NONE;
            }
            if (cacheCandidate != null && cacheResponse == null) {
                ResponseBody responseBody2 = cacheCandidate.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (networkRequest == null && cacheResponse == null) {
                chain = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                Response it = chain;
                ((EventListener)listener).satisfactionFailure(call, it);
                return chain;
            }
            if (networkRequest == null) {
                Response response2 = cacheResponse;
                Intrinsics.checkNotNull((Object)response2);
                chain = response2.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).build();
                Response it = chain;
                ((EventListener)listener).cacheHit(call, it);
                return chain;
            }
            if (cacheResponse != null) {
                ((EventListener)listener).cacheConditionalHit(call, cacheResponse);
            } else if (this.cache != null) {
                ((EventListener)listener).cacheMiss(call);
            }
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block23;
                responseBody = cacheCandidate.body();
            }
            catch (Throwable it) {
                if (cacheCandidate != null) {
                    ResponseBody responseBody3 = cacheCandidate.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw it;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (cacheResponse != null) {
            Response response3 = networkResponse;
            boolean bl = response3 != null ? response3.code() == 304 : false;
            if (bl) {
                Response response4 = cacheResponse.newBuilder().headers(okhttp3.internal.cache.CacheInterceptor$Companion.access$combine(Companion, cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, networkResponse)).build();
                ResponseBody responseBody = networkResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
                Cache cache = this.cache;
                Intrinsics.checkNotNull((Object)cache);
                cache.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(cacheResponse, response4);
                Response it = networkResponse = response4;
                ((EventListener)listener).cacheHit(call, response);
                return networkResponse;
            }
            ResponseBody responseBody = cacheResponse.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response5 = networkResponse;
        Intrinsics.checkNotNull((Object)response5);
        Response response6 = response5.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, networkResponse)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody(response6) && CacheStrategy.Companion.isCacheable(response6, networkRequest)) {
                void var1_1;
                CacheRequest cacheRequest = this.cache.put$okhttp(response6);
                response = this.cacheWritingResponse((CacheRequest)var1_1, response6);
                if (cacheResponse != null) {
                    void var2_2;
                    ((EventListener)listener).cacheMiss((Call)var2_2);
                }
                return response;
            }
            if (HttpMethod.INSTANCE.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove$okhttp(networkRequest);
                }
                catch (IOException iOException) {}
            }
        }
        return response6;
    }

    /*
     * WARNING - void declaration
     */
    private final Response cacheWritingResponse(CacheRequest cacheRequest, Response response) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        if (cacheRequest == null) {
            return response;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource source = responseBody.source();
        BufferedSink cacheBody = Okio.buffer((Sink)cacheBodyUnbuffered);
        Source cacheWritingSource2 = new Source(source, cacheRequest, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$source = var1_1;
                this.$cacheRequest = var2_2;
                this.$cacheBody = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public final long read(Buffer sink, long byteCount) throws IOException {
                void var1_1;
                long bytesRead;
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                try {
                    void var2_3;
                    bytesRead = this.$source.read(sink, (long)var2_3);
                }
                catch (IOException e) {
                    void var1_2;
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw var1_2;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                var1_1.copyTo(this.$cacheBody.getBuffer(), var1_1.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            public final Timeout timeout() {
                return this.$source.timeout();
            }

            public final void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
        };
        String contentType = Response.header$default(response, "Content-Type", null, 2, null);
        long contentLength = response.body().contentLength();
        return var2_2.newBuilder().body(new RealResponseBody((String)var3_3, contentLength, Okio.buffer((Source)((Source)var1_1)))).build();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "<init>", "()V", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "combine", "(Lokhttp3/Headers;Lokhttp3/Headers;)Lokhttp3/Headers;", "", "fieldName", "", "isContentSpecificHeader", "(Ljava/lang/String;)Z", "isEndToEnd", "Lokhttp3/Response;", "response", "stripBody", "(Lokhttp3/Response;)Lokhttp3/Response;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Response stripBody(Response response) {
            void var1_1;
            Response response2 = response;
            if ((response2 != null ? response2.body() : null) != null) {
                return response.newBuilder().body(null).build();
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final Headers combine(Headers cachedHeaders, Headers networkHeaders) {
            void var3_3;
            String fieldName;
            int index;
            Headers.Builder result = new Headers.Builder();
            int n = cachedHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = cachedHeaders.name(index);
                String value = cachedHeaders.value(index);
                if (StringsKt.equals((String)"Warning", (String)fieldName, (boolean)true) && StringsKt.startsWith$default((String)value, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(fieldName) && this.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
                result.addLenient$okhttp(fieldName, value);
            }
            n = networkHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = networkHeaders.name(index);
                if (this.isContentSpecificHeader(fieldName) || !this.isEndToEnd(fieldName)) continue;
                result.addLenient$okhttp(fieldName, networkHeaders.value(index));
            }
            return var3_3.build();
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isEndToEnd(String fieldName) {
            void var1_1;
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)var1_1, (boolean)true);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isContentSpecificHeader(String fieldName) {
            void var1_1;
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)var1_1, (boolean)true);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Response access$stripBody(Companion $this, Response response) {
            void var1_1;
            return $this.stripBody((Response)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Headers access$combine(Companion $this, Headers cachedHeaders, Headers networkHeaders) {
            void var2_2;
            void var1_1;
            return $this.combine((Headers)var1_1, (Headers)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

