/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.Buffer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a7\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a)\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0010\u001a\u00020\b*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"", "input", "", "pos", "limit", "", "address", "addressOffset", "", "decodeIpv4Suffix", "(Ljava/lang/String;II[BI)Z", "Ljava/net/InetAddress;", "decodeIpv6", "(Ljava/lang/String;II)Ljava/net/InetAddress;", "inet6AddressToAscii", "([B)Ljava/lang/String;", "containsInvalidHostnameAsciiCodes", "(Ljava/lang/String;)Z", "toCanonicalHost", "(Ljava/lang/String;)Ljava/lang/String;"})
public final class HostnamesKt {
    /*
     * WARNING - void declaration
     */
    public static final String toCanonicalHost(String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            void var2_3;
            InetAddress inetAddress = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? HostnamesKt.decodeIpv6(host, 1, host.length() - 1) : HostnamesKt.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            InetAddress inetAddress2 = inetAddress;
            byte[] address = inetAddress.getAddress();
            if (address.length == 16) {
                Intrinsics.checkNotNullExpressionValue((Object)address, (String)"address");
                return HostnamesKt.inet6AddressToAscii(address);
            }
            if (((void)var2_3).length == 4) {
                return inetAddress2.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        try {
            void var1_2;
            String string;
            String string2 = IDN.toASCII(string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toASCII(host)");
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            String result = string4;
            if (((CharSequence)string4).length() == 0) {
                return null;
            }
            if (HostnamesKt.containsInvalidHostnameAsciiCodes(result)) {
                return null;
            }
            return var1_2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean containsInvalidHostnameAsciiCodes(String $this$containsInvalidHostnameAsciiCodes) {
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i = 0; i < n; ++i) {
            void var3_3;
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i);
            if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)var3_3, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final InetAddress decodeIpv6(String input, int pos, int limit) {
        void var3_3;
        void i;
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        while (i < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i, (boolean)false, (int)4, null)) {
                    if (!HostnamesKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i;
            while (i < limit && (hexDigit = Util.parseHexDigit(input.charAt((int)i))) != -1) {
                value = (value << 4) + hexDigit;
                ++i;
            }
            void groupLength = i - groupOffset;
            if (groupLength == false || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8);
            address[b++] = (byte)value;
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
            int n = compress;
            Arrays.fill(address, n, n + (address.length - b), (byte)0);
        }
        return InetAddress.getByAddress((byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        void i;
        int b = addressOffset;
        while (i < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt((int)i) != '.') {
                return false;
            }
            int value = 0;
            void groupOffset = ++i;
            while (i < limit && Intrinsics.compare((int)(c = input.charAt((int)i)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i;
            }
            void var8_8 = i - groupOffset;
            if (var8_8 == false) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    /*
     * WARNING - void declaration
     */
    private static final String inet6AddressToAscii(byte[] address) {
        void var3_5;
        int i;
        int longestRunOffset = -1;
        int longestRunLength = 0;
        for (i = 0; i < address.length; i += 2) {
            int currentRunOffset = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            int currentRunLength = i - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        i = 0;
        while (i < address.length) {
            if (i == longestRunOffset) {
                result.writeByte(58);
                if ((i += longestRunLength) != 16) continue;
                result.writeByte(58);
                continue;
            }
            if (i > 0) {
                result.writeByte(58);
            }
            int group = Util.and(address[i], 255) << 8 | Util.and(address[i + 1], 255);
            result.writeHexadecimalUnsignedLong((long)group);
            i += 2;
        }
        return var3_5.readUtf8();
    }
}

