/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B;\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0007\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0005\u0010\u0018R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\b\u0010\u001aR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001aR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u0003\u0010\u001fR\u0018\u0010\"\u001a\u00020\u0014*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!"}, d2={"Lokhttp3/Handshake;", "", "Lokhttp3/TlsVersion;", "tlsVersion", "Lokhttp3/CipherSuite;", "cipherSuite", "", "Ljava/security/cert/Certificate;", "localCertificates", "Lkotlin/Function0;", "peerCertificatesFn", "<init>", "(Lokhttp3/TlsVersion;Lokhttp3/CipherSuite;Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lokhttp3/CipherSuite;", "()Lokhttp3/CipherSuite;", "Ljava/util/List;", "()Ljava/util/List;", "peerCertificates$delegate", "Lkotlin/Lazy;", "peerCertificates", "Lokhttp3/TlsVersion;", "()Lokhttp3/TlsVersion;", "getName", "(Ljava/security/cert/Certificate;)Ljava/lang/String;", "name", "Companion"})
@SourceDebugExtension(value={"SMAP\nHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Handshake.kt\nokhttp3/Handshake\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,3:206\n*S KotlinDebug\n*F\n+ 1 Handshake.kt\nokhttp3/Handshake\n*L\n129#1:201\n129#1:202,3\n134#1:205\n134#1:206,3\n*E\n"})
public final class Handshake {
    public static final Companion Companion = new Companion(null);
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List<Certificate> localCertificates;
    private final Lazy peerCertificates$delegate;

    /*
     * WARNING - void declaration
     */
    public Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<? extends Certificate> localCertificates, Function0<? extends List<? extends Certificate>> peerCertificatesFn) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)tlsVersion), (String)"tlsVersion");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"cipherSuite");
        Intrinsics.checkNotNullParameter(localCertificates, (String)"localCertificates");
        Intrinsics.checkNotNullParameter(peerCertificatesFn, (String)"peerCertificatesFn");
        this.tlsVersion = var1_1;
        this.cipherSuite = var2_2;
        this.localCertificates = var3_3;
        this.peerCertificates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Certificate>>(peerCertificatesFn){
            final /* synthetic */ Function0<List<Certificate>> $peerCertificatesFn;
            {
                void var1_1;
                this.$peerCertificatesFn = var1_1;
                super(0);
            }

            public final List<Certificate> invoke() {
                List list;
                try {
                    list = (List)this.$peerCertificatesFn.invoke();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }));
    }

    @JvmName(name="tlsVersion")
    public final TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    @JvmName(name="cipherSuite")
    public final CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    @JvmName(name="localCertificates")
    public final List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @JvmName(name="peerCertificates")
    public final List<Certificate> peerCertificates() {
        Lazy lazy = this.peerCertificates$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Handshake && ((Handshake)other).tlsVersion == this.tlsVersion && Intrinsics.areEqual((Object)((Handshake)other).cipherSuite, (Object)this.cipherSuite) && Intrinsics.areEqual(((Handshake)other).peerCertificates(), this.peerCertificates()) && Intrinsics.areEqual(((Handshake)var1_1).localCertificates, this.localCertificates);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 527 + this.tlsVersion.hashCode();
        result = result * 31 + this.cipherSuite.hashCode();
        result = result * 31 + ((Object)this.peerCertificates()).hashCode();
        var1_1 = var1_1 * 31 + ((Object)this.localCertificates).hashCode();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        Object object;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.peerCertificates();
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $this$mapTo$iv$iv = $this$mapTo$iv$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            void it;
            item$iv$iv = $this$mapTo$iv$iv.next();
            item$iv$iv = (Certificate)item$iv$iv;
            object = destination$iv$iv;
            object.add(this.getName((Certificate)it));
        }
        Object peerCertificatesString = ((List)destination$iv$iv).toString();
        StringBuilder stringBuilder = new StringBuilder("Handshake{tlsVersion=").append((Object)this.tlsVersion).append(" cipherSuite=").append(this.cipherSuite).append(" peerCertificates=").append((String)peerCertificatesString).append(" localCertificates=");
        peerCertificatesString = this.localCertificates;
        object = stringBuilder;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            void var3_3;
            item$iv$iv = object2.next();
            item$iv$iv = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(this.getName((Certificate)var3_3));
        }
        return ((StringBuilder)object).append((List)var1_1).append('}').toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getName(Certificate $this$name) {
        void var1_1;
        if ($this$name instanceof X509Certificate) {
            return ((Object)((X509Certificate)$this$name).getSubjectDN()).toString();
        }
        String string = var1_1.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0011\u001a\u00020\f*\u00020\u000fH\u0007\u00a2\u0006\u0004\b\r\u0010\u0010J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b*\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lokhttp3/Handshake$Companion;", "", "<init>", "()V", "Lokhttp3/TlsVersion;", "tlsVersion", "Lokhttp3/CipherSuite;", "cipherSuite", "", "Ljava/security/cert/Certificate;", "peerCertificates", "localCertificates", "Lokhttp3/Handshake;", "get", "(Lokhttp3/TlsVersion;Lokhttp3/CipherSuite;Ljava/util/List;Ljava/util/List;)Lokhttp3/Handshake;", "Ljavax/net/ssl/SSLSession;", "(Ljavax/net/ssl/SSLSession;)Lokhttp3/Handshake;", "handshake", "", "toImmutableList", "([Ljava/security/cert/Certificate;)Ljava/util/List;"})
    @SourceDebugExtension(value={"SMAP\nHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Handshake.kt\nokhttp3/Handshake$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="get")
        public final Handshake get(SSLSession $this$handshake) throws IOException {
            void var1_1;
            void var2_4;
            List<Certificate> list;
            Intrinsics.checkNotNullParameter((Object)$this$handshake, (String)"<this>");
            String string = $this$handshake.getCipherSuite();
            if (string == null) {
                String string2 = "cipherSuite == null";
                throw new IllegalStateException(string2.toString());
            }
            String cipherSuiteString = string;
            String string3 = string;
            if (Intrinsics.areEqual((Object)string, (Object)"TLS_NULL_WITH_NULL_NULL") ? true : Intrinsics.areEqual((Object)string3, (Object)"SSL_NULL_WITH_NULL_NULL")) {
                throw new IOException("cipherSuite == " + cipherSuiteString);
            }
            CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
            String string4 = $this$handshake.getProtocol();
            if (string4 == null) {
                String string5 = "tlsVersion == null";
                throw new IllegalStateException(string5.toString());
            }
            String tlsVersionString = string4;
            if (Intrinsics.areEqual((Object)"NONE", (Object)tlsVersionString)) {
                throw new IOException("tlsVersion == NONE");
            }
            TlsVersion tlsVersion = TlsVersion.Companion.forJavaName(tlsVersionString);
            try {
                list = this.toImmutableList($this$handshake.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                list = CollectionsKt.emptyList();
            }
            List<Certificate> peerCertificatesCopy = list;
            return new Handshake((TlsVersion)((Object)string3), (CipherSuite)var2_4, this.toImmutableList(var1_1.getLocalCertificates()), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>(peerCertificatesCopy){
                final /* synthetic */ List<Certificate> $peerCertificatesCopy;
                {
                    void var1_1;
                    this.$peerCertificatesCopy = var1_1;
                    super(0);
                }

                public final List<Certificate> invoke() {
                    return this.$peerCertificatesCopy;
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Certificate> toImmutableList(Certificate[] $this$toImmutableList) {
            if ($this$toImmutableList != null) {
                void var1_1;
                void v0 = var1_1;
                return Util.immutableListOf(Arrays.copyOf(v0, ((void)v0).length));
            }
            return CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<? extends Certificate> peerCertificates2, List<? extends Certificate> localCertificates) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)tlsVersion), (String)"tlsVersion");
            Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"cipherSuite");
            Intrinsics.checkNotNullParameter(peerCertificates2, (String)"peerCertificates");
            Intrinsics.checkNotNullParameter(localCertificates, (String)"localCertificates");
            List<? extends Certificate> peerCertificatesCopy = Util.toImmutableList(peerCertificates2);
            return new Handshake((TlsVersion)var1_1, (CipherSuite)var2_2, Util.toImmutableList(localCertificates), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>((List<? extends Certificate>)var3_3){
                final /* synthetic */ List<Certificate> $peerCertificatesCopy;
                {
                    void var1_1;
                    this.$peerCertificatesCopy = var1_1;
                    super(0);
                }

                public final List<Certificate> invoke() {
                    return this.$peerCertificatesCopy;
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

