/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\n\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0004R\u00020\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ+\u0010\u0012\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0006\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0012\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0004R\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u0014\u0010\tJ\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0018\u0010&\u001a\u0004\u0018\u00010%8F@FX\u0087\f\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u001d8F@FX\u0087\f\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u001d8F@FX\u0087\f\u00a2\u0006\u0006\n\u0004\b*\u0010)R\u001e\u0010,\u001a\f\u0012\b\u0012\u00060\u0004R\u00020\u00050+8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001e\u0010.\u001a\f\u0012\b\u0012\u00060\u0004R\u00020\u00050+8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050+8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010-"}, d2={"Lokhttp3/Dispatcher;", "", "<init>", "()V", "Lokhttp3/internal/connection/RealCall$AsyncCall;", "Lokhttp3/internal/connection/RealCall;", "call", "", "enqueue$okhttp", "(Lokhttp3/internal/connection/RealCall$AsyncCall;)V", "enqueue", "", "host", "findExistingCallWithHost", "(Ljava/lang/String;)Lokhttp3/internal/connection/RealCall$AsyncCall;", "T", "Ljava/util/Deque;", "calls", "finished", "(Ljava/util/Deque;Ljava/lang/Object;)V", "finished$okhttp", "", "promoteAndExecute", "()Z", "", "Lokhttp3/Call;", "queuedCalls", "()Ljava/util/List;", "runningCalls", "", "runningCallsCount", "()I", "Ljava/util/concurrent/ExecutorService;", "executorService", "()Ljava/util/concurrent/ExecutorService;", "executorServiceOrNull", "Ljava/util/concurrent/ExecutorService;", "Ljava/lang/Runnable;", "idleCallback", "Ljava/lang/Runnable;", "maxRequests", "I", "maxRequestsPerHost", "Ljava/util/ArrayDeque;", "readyAsyncCalls", "Ljava/util/ArrayDeque;", "runningAsyncCalls", "runningSyncCalls"})
@SourceDebugExtension(value={"SMAP\nDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dispatcher.kt\nokhttp3/Dispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n615#3,4:243\n1549#4:247\n1620#4,3:248\n1549#4:251\n1620#4,3:252\n*S KotlinDebug\n*F\n+ 1 Dispatcher.kt\nokhttp3/Dispatcher\n*L\n162#1:243,4\n222#1:247\n222#1:248,3\n227#1:251\n227#1:252,3\n*E\n"})
public final class Dispatcher {
    public int maxRequests = 64;
    public int maxRequestsPerHost = 5;
    public Runnable idleCallback;
    private ExecutorService executorServiceOrNull;
    private final ArrayDeque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque();
    private final ArrayDeque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque();
    private final ArrayDeque<RealCall> runningSyncCalls = new ArrayDeque();

    @JvmName(name="executorService")
    public final synchronized ExecutorService executorService() {
        if (this.executorServiceOrNull == null) {
            this.executorServiceOrNull = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), Util.threadFactory(Util.okHttpName + " Dispatcher", false));
        }
        ExecutorService executorService = this.executorServiceOrNull;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueue$okhttp(RealCall.AsyncCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            RealCall.AsyncCall existingCall;
            this.readyAsyncCalls.add(call);
            if (!call.getCall().getForWebSocket() && (existingCall = this.findExistingCallWithHost(call.getHost())) != null) {
                void var3_4;
                void var1_1;
                var1_1.reuseCallsPerHostFrom((RealCall.AsyncCall)var3_4);
            }
        }
        this.promoteAndExecute();
    }

    /*
     * WARNING - void declaration
     */
    private final RealCall.AsyncCall findExistingCallWithHost(String host) {
        for (RealCall.AsyncCall existingCall : this.runningAsyncCalls) {
            if (!Intrinsics.areEqual((Object)existingCall.getHost(), (Object)host)) continue;
            return existingCall;
        }
        for (RealCall.AsyncCall existingCall : this.readyAsyncCalls) {
            void var3_3;
            if (!Intrinsics.areEqual((Object)existingCall.getHost(), (Object)host)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean promoteAndExecute() {
        void var2_6;
        Dispatcher $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        List executableCalls = new ArrayList();
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"readyAsyncCalls.iterator()");
            Iterator<RealCall.AsyncCall> i = iterator;
            while (i.hasNext()) {
                RealCall.AsyncCall asyncCall = i.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (asyncCall.getCallsPerHost().get() >= this.maxRequestsPerHost) continue;
                i.remove();
                asyncCall.getCallsPerHost().incrementAndGet();
                Intrinsics.checkNotNullExpressionValue((Object)asyncCall, (String)"asyncCall");
                executableCalls.add(asyncCall);
                this.runningAsyncCalls.add(asyncCall);
            }
            boolean isRunning = this.runningCallsCount() > 0;
        }
        int n = executableCalls.size();
        for (int i = 0; i < n; ++i) {
            RealCall.AsyncCall asyncCall = (RealCall.AsyncCall)executableCalls.get(i);
            asyncCall.executeOn(this.executorService());
        }
        return (boolean)var2_6;
    }

    /*
     * WARNING - void declaration
     */
    public final void finished$okhttp(RealCall.AsyncCall call) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        call.getCallsPerHost().decrementAndGet();
        Dispatcher dispatcher = this;
        dispatcher.finished((Deque)dispatcher.runningAsyncCalls, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void finished(Deque<T> calls, T call) {
        Runnable idleCallback;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            void var2_3;
            if (!calls.remove(var2_3)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            idleCallback = this.idleCallback;
        }
        boolean bl = this.promoteAndExecute();
        if (!bl && idleCallback != null) {
            void var1_1;
            var1_1.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized List<Call> queuedCalls() {
        void var1_1;
        Iterable $this$map$iv = this.readyAsyncCalls;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object item$iv$iv = object.next();
            item$iv$iv = (RealCall.AsyncCall)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(var3_3.getCall());
        }
        List<Call> list = Collections.unmodifiableList((List)var1_1);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(readyAsyncCalls.map { it.call })");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized List<Call> runningCalls() {
        void $this$map$iv;
        Iterable iterable = this.runningAsyncCalls;
        Collection collection = this.runningSyncCalls;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Object item$iv$iv = iterator.next();
            item$iv$iv = (RealCall.AsyncCall)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            collection2.add(var3_4.getCall());
        }
        List<Call> list = Collections.unmodifiableList(CollectionsKt.plus((Collection)collection, (Iterable)((List)iterable)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(running\u2026yncCalls.map { it.call })");
        return list;
    }

    public final synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

