/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBQ\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0011\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\u00028\u0007\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u00058\u0007\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR\u0011\u0010\r\u001a\u00020\t8\u0007\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\t8\u0007\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0007\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u0003\u0010\u0017R\u0014\u0010\b\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001bR\u0014\u0010\f\u001a\u00020\t8\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001dR\u0014\u0010\n\u001a\u00020\t8\u0007X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001dR\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u0004\u0010\u0017"}, d2={"Lokhttp3/Cookie;", "", "", "name", "value", "", "expiresAt", "domain", "path", "", "secure", "httpOnly", "persistent", "hostOnly", "<init>", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ZZZZ)V", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "forObsoleteRfc2965", "toString$okhttp", "(Z)Ljava/lang/String;", "Ljava/lang/String;", "J", "Z", "Companion"})
public final class Cookie {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final String value;
    public final long expiresAt;
    public final String domain;
    public final String path;
    public final boolean secure;
    public final boolean httpOnly;
    public final boolean persistent;
    public final boolean hostOnly;
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");

    /*
     * WARNING - void declaration
     */
    private Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.value = var2_2;
        this.expiresAt = var3_3;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.persistent = persistent;
        this.hostOnly = hostOnly;
    }

    @JvmName(name="name")
    public final String name() {
        return this.name;
    }

    @JvmName(name="value")
    public final String value() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Cookie && Intrinsics.areEqual((Object)((Cookie)other).name, (Object)this.name) && Intrinsics.areEqual((Object)((Cookie)other).value, (Object)this.value) && ((Cookie)other).expiresAt == this.expiresAt && Intrinsics.areEqual((Object)((Cookie)other).domain, (Object)this.domain) && Intrinsics.areEqual((Object)((Cookie)other).path, (Object)this.path) && ((Cookie)other).secure == this.secure && ((Cookie)other).httpOnly == this.httpOnly && ((Cookie)other).persistent == this.persistent && ((Cookie)var1_1).hostOnly == this.hostOnly;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 527 + this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.expiresAt);
        result = result * 31 + this.domain.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + Boolean.hashCode(this.secure);
        result = result * 31 + Boolean.hashCode(this.httpOnly);
        result = result * 31 + Boolean.hashCode(this.persistent);
        var1_1 = var1_1 * 31 + Boolean.hashCode(this.hostOnly);
        return (int)var1_1;
    }

    public final String toString() {
        return this.toString$okhttp(false);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString$okhttp(boolean forObsoleteRfc2965) {
        void var2_2;
        StringBuilder $this$toString_u24lambda_u240 = new StringBuilder();
        $this$toString_u24lambda_u240.append(this.name);
        $this$toString_u24lambda_u240.append('=');
        $this$toString_u24lambda_u240.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                $this$toString_u24lambda_u240.append("; max-age=0");
            } else {
                $this$toString_u24lambda_u240.append("; expires=").append(DatesKt.toHttpDateString(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            void var1_1;
            $this$toString_u24lambda_u240.append("; domain=");
            if (var1_1 != false) {
                $this$toString_u24lambda_u240.append(".");
            }
            $this$toString_u24lambda_u240.append(this.domain);
        }
        $this$toString_u24lambda_u240.append("; path=").append(this.path);
        if (this.secure) {
            $this$toString_u24lambda_u240.append("; secure");
        }
        if (this.httpOnly) {
            $this$toString_u24lambda_u240.append("; httponly");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1, (String)var2_2, (long)var3_3, domain, path, secure, httpOnly, persistent, hostOnly);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010&R\u0018\u0010(\u001a\u0006*\u00020'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010*\u001a\u0006*\u00020'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)R\u0018\u0010+\u001a\u0006*\u00020'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010)R\u0018\u0010,\u001a\u0006*\u00020'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010)"}, d2={"Lokhttp3/Cookie$Companion;", "", "<init>", "()V", "", "input", "", "pos", "limit", "", "invert", "dateCharacterOffset", "(Ljava/lang/String;IIZ)I", "urlHost", "domain", "domainMatch", "(Ljava/lang/String;Ljava/lang/String;)Z", "", "currentTimeMillis", "Lokhttp3/HttpUrl;", "url", "setCookie", "Lokhttp3/Cookie;", "parse$okhttp", "(JLokhttp3/HttpUrl;Ljava/lang/String;)Lokhttp3/Cookie;", "parse", "(Lokhttp3/HttpUrl;Ljava/lang/String;)Lokhttp3/Cookie;", "Lokhttp3/Headers;", "headers", "", "parseAll", "(Lokhttp3/HttpUrl;Lokhttp3/Headers;)Ljava/util/List;", "s", "parseDomain", "(Ljava/lang/String;)Ljava/lang/String;", "parseExpires", "(Ljava/lang/String;II)J", "parseMaxAge", "(Ljava/lang/String;)J", "Ljava/util/regex/Pattern;", "DAY_OF_MONTH_PATTERN", "Ljava/util/regex/Pattern;", "MONTH_PATTERN", "TIME_PATTERN", "YEAR_PATTERN"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean domainMatch(String urlHost, String domain) {
            if (Intrinsics.areEqual((Object)urlHost, (Object)domain)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)urlHost, (String)domain, (boolean)false, (int)2, null)) {
                void var1_1;
                void var2_2;
                String string = urlHost;
                if (string.charAt(string.length() - var2_2.length() - 1) == '.' && !Util.canParseAsIpAddress((String)var1_1)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Cookie parse(HttpUrl url, String setCookie) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)setCookie, (String)"setCookie");
            return this.parse$okhttp(System.currentTimeMillis(), (HttpUrl)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Cookie parse$okhttp(long currentTimeMillis, HttpUrl url, String setCookie) {
            void var1_1;
            long deltaMilliseconds;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)setCookie, (String)"setCookie");
            int cookiePairEnd = Util.delimiterOffset$default(setCookie, ';', 0, 0, 6, null);
            int pairEqualsSign = Util.delimiterOffset$default(setCookie, '=', 0, cookiePairEnd, 2, null);
            if (pairEqualsSign == cookiePairEnd) {
                return null;
            }
            String cookieName = Util.trimSubstring$default(setCookie, 0, pairEqualsSign, 1, null);
            if (((CharSequence)cookieName).length() == 0 || Util.indexOfControlOrNonAscii(cookieName) != -1) {
                return null;
            }
            String cookieValue = Util.trimSubstring(setCookie, pairEqualsSign + 1, cookiePairEnd);
            if (Util.indexOfControlOrNonAscii(cookieValue) != -1) {
                return null;
            }
            long expiresAt = 253402300799999L;
            long deltaSeconds = -1L;
            String domain = null;
            String path = null;
            boolean secureOnly = false;
            boolean httpOnly = false;
            boolean hostOnly = true;
            boolean persistent = false;
            int pos = cookiePairEnd + 1;
            int limit = setCookie.length();
            while (pos < limit) {
                String attributeValue;
                int attributePairEnd = Util.delimiterOffset(setCookie, ';', pos, limit);
                int attributeEqualsSign = Util.delimiterOffset(setCookie, '=', pos, attributePairEnd);
                String attributeName22 = Util.trimSubstring(setCookie, pos, attributeEqualsSign);
                String string = attributeValue = attributeEqualsSign < attributePairEnd ? Util.trimSubstring(setCookie, attributeEqualsSign + 1, attributePairEnd) : "";
                if (StringsKt.equals((String)attributeName22, (String)"expires", (boolean)true)) {
                    try {
                        expiresAt = this.parseExpires(attributeValue, 0, attributeValue.length());
                        persistent = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"max-age", (boolean)true)) {
                    try {
                        deltaSeconds = this.parseMaxAge(attributeValue);
                        persistent = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"domain", (boolean)true)) {
                    try {
                        domain = this.parseDomain(attributeValue);
                        hostOnly = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"path", (boolean)true)) {
                    path = attributeValue;
                } else if (StringsKt.equals((String)attributeName22, (String)"secure", (boolean)true)) {
                    secureOnly = true;
                } else if (StringsKt.equals((String)attributeName22, (String)"httponly", (boolean)true)) {
                    httpOnly = true;
                }
                int attributeName22 = attributePairEnd + 1;
            }
            if (deltaSeconds == Long.MIN_VALUE) {
                expiresAt = Long.MIN_VALUE;
            } else if (deltaSeconds != -1L && ((expiresAt = currentTimeMillis + (deltaMilliseconds = deltaSeconds <= 9223372036854775L ? deltaSeconds * 1000L : Long.MAX_VALUE)) < var1_1 || expiresAt > 253402300799999L)) {
                expiresAt = 253402300799999L;
            }
            String urlHost = url.host();
            if (domain == null) {
                domain = urlHost;
            } else if (!this.domainMatch(urlHost, domain)) {
                return null;
            }
            if (urlHost.length() != domain.length() && PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(domain) == null) {
                return null;
            }
            if (path == null || !StringsKt.startsWith$default(path, (String)"/", (boolean)false, (int)2, null)) {
                String string;
                void var3_2;
                String encodedPath = var3_2.encodedPath();
                int lastSlash = StringsKt.lastIndexOf$default((CharSequence)encodedPath, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (lastSlash != 0) {
                    String string2 = encodedPath.substring(0, lastSlash);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = "/";
                }
                path = string;
            }
            return new Cookie(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, persistent, hostOnly, null);
        }

        /*
         * WARNING - void declaration
         */
        private final long parseExpires(String s, int pos, int limit) {
            void var2_10;
            pos = this.dateCharacterOffset(s, pos, limit, false);
            int hour = -1;
            int minute = -1;
            int second = -1;
            int dayOfMonth = -1;
            int month = -1;
            int year = -1;
            Matcher matcher = TIME_PATTERN.matcher(s);
            while (pos < limit) {
                int end = this.dateCharacterOffset(s, pos + 1, limit, true);
                matcher.region(pos, end);
                if (hour == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                    hour = Integer.parseInt(string);
                    String string2 = matcher.group(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
                    minute = Integer.parseInt(string2);
                    String string3 = matcher.group(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(3)");
                    second = Integer.parseInt(string3);
                } else if (dayOfMonth == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                    dayOfMonth = Integer.parseInt(string);
                } else if (month == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                    String monthString;
                    Intrinsics.checkNotNullExpressionValue((Object)matcher.group(1), (String)"matcher.group(1)");
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    Intrinsics.checkNotNullExpressionValue((Object)pos.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                    String string = MONTH_PATTERN.pattern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MONTH_PATTERN.pattern()");
                    month = StringsKt.indexOf$default((CharSequence)string, (String)monthString, (int)0, (boolean)false, (int)6, null) / 4;
                } else if (year == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                    year = Integer.parseInt(string);
                }
                int monthString = this.dateCharacterOffset(s, end + 1, limit, false);
            }
            boolean bl = 70 <= year ? year < 100 : false;
            if (bl) {
                year += 1900;
            }
            boolean bl2 = year >= 0 ? year < 70 : false;
            if (bl2) {
                year += 2000;
            }
            if (!(year >= 1601)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(month != -1)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(dayOfMonth > 0 ? dayOfMonth < 32 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(hour >= 0 ? hour < 24 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(minute >= 0 ? minute < 60 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(second >= 0 ? second < 60 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            GregorianCalendar $this$parseExpires_u24lambda_u240 = new GregorianCalendar(Util.UTC);
            $this$parseExpires_u24lambda_u240.setLenient(false);
            $this$parseExpires_u24lambda_u240.set(1, year);
            $this$parseExpires_u24lambda_u240.set(2, month - 1);
            $this$parseExpires_u24lambda_u240.set(5, dayOfMonth);
            $this$parseExpires_u24lambda_u240.set(11, hour);
            $this$parseExpires_u24lambda_u240.set(12, minute);
            $this$parseExpires_u24lambda_u240.set(13, second);
            $this$parseExpires_u24lambda_u240.set(14, 0);
            return var2_10.getTimeInMillis();
        }

        /*
         * Unable to fully structure code
         */
        private final int dateCharacterOffset(String input, int pos, int limit, boolean invert) {
            for (i = pos; i < limit; ++i) {
                c = input.charAt(i);
                if (c < ' ' && c != '\t' || c >= '\u007f') ** GOTO lbl-1000
                if ('0' <= c ? c < ':' : false) ** GOTO lbl-1000
                if ('a' <= c ? c < '{' : false) ** GOTO lbl-1000
                v0 = 'A' <= c ? c < '[' : false;
                if (v0 || c == ':') lbl-1000:
                // 4 sources

                {
                    v1 = true;
                } else {
                    v1 = var5_5 = false;
                }
                if (v1 != (invert == false)) continue;
                return i;
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private final long parseMaxAge(String s) {
            try {
                long parsed = Long.parseLong(s);
                if (parsed <= 0L) {
                    return Long.MIN_VALUE;
                }
                return parsed;
            }
            catch (NumberFormatException e) {
                void var2_3;
                CharSequence charSequence = s;
                if (new Regex("-?\\d+").matches(charSequence)) {
                    void var1_1;
                    if (StringsKt.startsWith$default((String)var1_1, (String)"-", (boolean)false, (int)2, null)) {
                        return Long.MIN_VALUE;
                    }
                    return Long.MAX_VALUE;
                }
                throw var2_3;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String parseDomain(String s) {
            void var1_1;
            if (!(!StringsKt.endsWith$default((String)s, (String)".", (boolean)false, (int)2, null))) {
                s = "Failed requirement.";
                throw new IllegalArgumentException(s.toString());
            }
            String string = HostnamesKt.toCanonicalHost(StringsKt.removePrefix((String)var1_1, (CharSequence)"."));
            if (string == null) {
                throw new IllegalArgumentException();
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final List<Cookie> parseAll(HttpUrl url, Headers headers) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            List<String> cookieStrings = headers.values("Set-Cookie");
            List cookies = null;
            int n = cookieStrings.size();
            for (int i = 0; i < n; ++i) {
                Cookie cookie;
                if (this.parse(url, cookieStrings.get(i)) == null) continue;
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                cookies.add(cookie);
            }
            if (cookies != null) {
                void var3_3;
                List<Cookie> list = Collections.unmodifiableList(var3_3);
                Intrinsics.checkNotNullExpressionValue(list, (String)"{\n        Collections.un\u2026ableList(cookies)\n      }");
                return list;
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

