/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.vector.PathNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0002\u001a\u001f\u0010\u0004\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a_\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a_\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\"\u0014\u0010\u001e\u001a\u00020\u001d8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"", "Landroidx/compose/ui/graphics/vector/PathNode;", "Landroidx/compose/ui/graphics/Path;", "target", "toPath", "(Ljava/util/List;Landroidx/compose/ui/graphics/Path;)Landroidx/compose/ui/graphics/Path;", "p", "", "x0", "y0", "x1", "y1", "a", "b", "theta", "", "isMoreThanHalf", "isPositiveArc", "", "drawArc", "(Landroidx/compose/ui/graphics/Path;DDDDDDDZZ)V", "cx", "cy", "e1x", "e1y", "start", "sweep", "arcToBezier", "(Landroidx/compose/ui/graphics/Path;DDDDDDDDD)V", "", "EmptyArray", "[F"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,546:1\n545#1:552\n35#2,5:547\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n*L\n405#1:552\n207#1:547,5\n*E\n"})
public final class PathParserKt {
    public static final float[] EmptyArray = new float[0];

    /*
     * WARNING - void declaration
     */
    public static final Path toPath(List<? extends PathNode> $this$toPath, Path target) {
        void var1_6;
        Intrinsics.checkNotNullParameter($this$toPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int fillType = target.getFillType-Rg-k1Os();
        target.rewind();
        target.setFillType-oQ8Xj4U(fillType);
        float currentX = 0.0f;
        float currentY = 0.0f;
        float ctrlX = 0.0f;
        float ctrlY = 0.0f;
        float segmentX = 0.0f;
        float segmentY = 0.0f;
        PathNode previousNode = $this$toPath.isEmpty() ? (PathNode)PathNode.Close.INSTANCE : $this$toPath.get(0);
        List<? extends PathNode> $this$fastForEach$iv = $this$toPath;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            List<? extends PathNode> list;
            float f;
            float f2;
            List<? extends PathNode> reflectiveCtrlX2;
            float reflectiveCtrlY;
            PathNode pathNode;
            $this$toPath = $this$fastForEach$iv.get(index$iv);
            PathNode node = $this$toPath;
            $this$toPath = $this$toPath;
            if (pathNode instanceof PathNode.Close) {
                currentX = segmentX;
                currentY = segmentY;
                ctrlX = segmentX;
                ctrlY = segmentY;
                target.close();
            } else if ($this$toPath instanceof PathNode.RelativeMoveTo) {
                target.relativeMoveTo(((PathNode.RelativeMoveTo)node).getDx(), ((PathNode.RelativeMoveTo)node).getDy());
                segmentX = currentX += ((PathNode.RelativeMoveTo)node).getDx();
                segmentY = currentY += ((PathNode.RelativeMoveTo)node).getDy();
            } else if ($this$toPath instanceof PathNode.MoveTo) {
                currentX = ((PathNode.MoveTo)node).getX();
                currentY = ((PathNode.MoveTo)node).getY();
                target.moveTo(((PathNode.MoveTo)node).getX(), ((PathNode.MoveTo)node).getY());
                segmentX = currentX;
                segmentY = currentY;
            } else if ($this$toPath instanceof PathNode.RelativeLineTo) {
                target.relativeLineTo(((PathNode.RelativeLineTo)node).getDx(), ((PathNode.RelativeLineTo)node).getDy());
                currentX += ((PathNode.RelativeLineTo)node).getDx();
                currentY += ((PathNode.RelativeLineTo)node).getDy();
            } else if ($this$toPath instanceof PathNode.LineTo) {
                target.lineTo(((PathNode.LineTo)node).getX(), ((PathNode.LineTo)node).getY());
                currentX = ((PathNode.LineTo)node).getX();
                currentY = ((PathNode.LineTo)node).getY();
            } else if ($this$toPath instanceof PathNode.RelativeHorizontalTo) {
                target.relativeLineTo(((PathNode.RelativeHorizontalTo)node).getDx(), 0.0f);
                currentX += ((PathNode.RelativeHorizontalTo)node).getDx();
            } else if ($this$toPath instanceof PathNode.HorizontalTo) {
                target.lineTo(((PathNode.HorizontalTo)node).getX(), currentY);
                currentX = ((PathNode.HorizontalTo)node).getX();
            } else if ($this$toPath instanceof PathNode.RelativeVerticalTo) {
                target.relativeLineTo(0.0f, ((PathNode.RelativeVerticalTo)node).getDy());
                currentY += ((PathNode.RelativeVerticalTo)node).getDy();
            } else if ($this$toPath instanceof PathNode.VerticalTo) {
                target.lineTo(currentX, ((PathNode.VerticalTo)node).getY());
                currentY = ((PathNode.VerticalTo)node).getY();
            } else if ($this$toPath instanceof PathNode.RelativeCurveTo) {
                target.relativeCubicTo(((PathNode.RelativeCurveTo)node).getDx1(), ((PathNode.RelativeCurveTo)node).getDy1(), ((PathNode.RelativeCurveTo)node).getDx2(), ((PathNode.RelativeCurveTo)node).getDy2(), ((PathNode.RelativeCurveTo)node).getDx3(), ((PathNode.RelativeCurveTo)node).getDy3());
                ctrlX = currentX + ((PathNode.RelativeCurveTo)node).getDx2();
                ctrlY = currentY + ((PathNode.RelativeCurveTo)node).getDy2();
                currentX += ((PathNode.RelativeCurveTo)node).getDx3();
                currentY += ((PathNode.RelativeCurveTo)node).getDy3();
            } else if ($this$toPath instanceof PathNode.CurveTo) {
                target.cubicTo(((PathNode.CurveTo)node).getX1(), ((PathNode.CurveTo)node).getY1(), ((PathNode.CurveTo)node).getX2(), ((PathNode.CurveTo)node).getY2(), ((PathNode.CurveTo)node).getX3(), ((PathNode.CurveTo)node).getY3());
                ctrlX = ((PathNode.CurveTo)node).getX2();
                ctrlY = ((PathNode.CurveTo)node).getY2();
                currentX = ((PathNode.CurveTo)node).getX3();
                currentY = ((PathNode.CurveTo)node).getY3();
            } else if ($this$toPath instanceof PathNode.RelativeReflectiveCurveTo) {
                float reflectiveCtrlX2;
                if (previousNode.isCurve()) {
                    reflectiveCtrlX2 = currentX - ctrlX;
                    reflectiveCtrlY = currentY - ctrlY;
                } else {
                    reflectiveCtrlX2 = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeCubicTo(reflectiveCtrlX2, reflectiveCtrlY, ((PathNode.RelativeReflectiveCurveTo)node).getDx1(), ((PathNode.RelativeReflectiveCurveTo)node).getDy1(), ((PathNode.RelativeReflectiveCurveTo)node).getDx2(), ((PathNode.RelativeReflectiveCurveTo)node).getDy2());
                ctrlX = currentX + ((PathNode.RelativeReflectiveCurveTo)node).getDx1();
                reflectiveCtrlY = currentY + ((PathNode.RelativeReflectiveCurveTo)node).getDy1();
                currentX += ((PathNode.RelativeReflectiveCurveTo)node).getDx2();
                currentY += ((PathNode.RelativeReflectiveCurveTo)node).getDy2();
            } else if (reflectiveCtrlX2 instanceof PathNode.ReflectiveCurveTo) {
                float reflectiveCtrlX2;
                if (previousNode.isCurve()) {
                    reflectiveCtrlX2 = currentX * 2.0f - ctrlX;
                    reflectiveCtrlY = currentY * 2.0f - reflectiveCtrlY;
                } else {
                    reflectiveCtrlX2 = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.cubicTo(reflectiveCtrlX2, reflectiveCtrlY, ((PathNode.ReflectiveCurveTo)node).getX1(), ((PathNode.ReflectiveCurveTo)node).getY1(), ((PathNode.ReflectiveCurveTo)node).getX2(), ((PathNode.ReflectiveCurveTo)node).getY2());
                ctrlX = ((PathNode.ReflectiveCurveTo)node).getX1();
                reflectiveCtrlY = ((PathNode.ReflectiveCurveTo)node).getY1();
                currentX = ((PathNode.ReflectiveCurveTo)node).getX2();
                currentY = ((PathNode.ReflectiveCurveTo)node).getY2();
            } else if (reflectiveCtrlX2 instanceof PathNode.RelativeQuadTo) {
                target.relativeQuadraticTo(((PathNode.RelativeQuadTo)node).getDx1(), ((PathNode.RelativeQuadTo)node).getDy1(), ((PathNode.RelativeQuadTo)node).getDx2(), ((PathNode.RelativeQuadTo)node).getDy2());
                ctrlX = currentX + ((PathNode.RelativeQuadTo)node).getDx1();
                reflectiveCtrlY = currentY + ((PathNode.RelativeQuadTo)node).getDy1();
                currentX += ((PathNode.RelativeQuadTo)node).getDx2();
                currentY += ((PathNode.RelativeQuadTo)node).getDy2();
            } else if (reflectiveCtrlX2 instanceof PathNode.QuadTo) {
                target.quadraticTo(((PathNode.QuadTo)node).getX1(), ((PathNode.QuadTo)node).getY1(), ((PathNode.QuadTo)node).getX2(), ((PathNode.QuadTo)node).getY2());
                ctrlX = ((PathNode.QuadTo)node).getX1();
                reflectiveCtrlY = ((PathNode.QuadTo)node).getY1();
                currentX = ((PathNode.QuadTo)node).getX2();
                currentY = ((PathNode.QuadTo)node).getY2();
            } else if (reflectiveCtrlX2 instanceof PathNode.RelativeReflectiveQuadTo) {
                float reflectiveCtrlX2;
                if (previousNode.isQuad()) {
                    reflectiveCtrlX2 = currentX - ctrlX;
                    reflectiveCtrlY = currentY - reflectiveCtrlY;
                } else {
                    reflectiveCtrlX2 = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeQuadraticTo(reflectiveCtrlX2, reflectiveCtrlY, ((PathNode.RelativeReflectiveQuadTo)node).getDx(), ((PathNode.RelativeReflectiveQuadTo)node).getDy());
                ctrlX = currentX + reflectiveCtrlX2;
                reflectiveCtrlY = currentY + reflectiveCtrlY;
                currentX += ((PathNode.RelativeReflectiveQuadTo)node).getDx();
                currentY += ((PathNode.RelativeReflectiveQuadTo)node).getDy();
            } else if (reflectiveCtrlX2 instanceof PathNode.ReflectiveQuadTo) {
                float reflectiveCtrlX2;
                if (previousNode.isQuad()) {
                    reflectiveCtrlX2 = currentX * 2.0f - ctrlX;
                    reflectiveCtrlY = currentY * 2.0f - reflectiveCtrlY;
                } else {
                    reflectiveCtrlX2 = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.quadraticTo(reflectiveCtrlX2, reflectiveCtrlY, ((PathNode.ReflectiveQuadTo)node).getX(), ((PathNode.ReflectiveQuadTo)node).getY());
                ctrlX = reflectiveCtrlX2;
                f2 = reflectiveCtrlY;
                currentX = ((PathNode.ReflectiveQuadTo)node).getX();
                currentY = ((PathNode.ReflectiveQuadTo)node).getY();
            } else if (reflectiveCtrlX2 instanceof PathNode.RelativeArcTo) {
                void var0_5;
                float arcStartX = ((PathNode.RelativeArcTo)node).getArcStartDx() + currentX;
                float arcStartY = ((PathNode.RelativeArcTo)node).getArcStartDy() + currentY;
                PathParserKt.drawArc(target, currentX, currentY, arcStartX, arcStartY, ((PathNode.RelativeArcTo)node).getHorizontalEllipseRadius(), ((PathNode.RelativeArcTo)node).getVerticalEllipseRadius(), ((PathNode.RelativeArcTo)node).getTheta(), ((PathNode.RelativeArcTo)node).isMoreThanHalf(), ((PathNode.RelativeArcTo)node).isPositiveArc());
                currentX = var0_5;
                currentY = arcStartY;
                f = currentX;
                f2 = currentY;
            } else if (list instanceof PathNode.ArcTo) {
                PathParserKt.drawArc(target, currentX, currentY, ((PathNode.ArcTo)node).getArcStartX(), ((PathNode.ArcTo)node).getArcStartY(), ((PathNode.ArcTo)node).getHorizontalEllipseRadius(), ((PathNode.ArcTo)node).getVerticalEllipseRadius(), ((PathNode.ArcTo)node).getTheta(), ((PathNode.ArcTo)node).isMoreThanHalf(), ((PathNode.ArcTo)node).isPositiveArc());
                currentX = ((PathNode.ArcTo)node).getArcStartX();
                currentY = ((PathNode.ArcTo)node).getArcStartY();
                f = currentX;
                f2 = currentY;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            previousNode = node;
        }
        return var1_6;
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawArc(Path p, double x0, double y0, double x1, double y1, double a, double b, double theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        void var3_3;
        void var1_2;
        Path path;
        double cy;
        double cx;
        double disc;
        double ym;
        double xm;
        double dy;
        double dx;
        double y1p;
        double x1p;
        double y0p;
        double x0p;
        double sinTheta;
        double cosTheta;
        double thetaD;
        while (true) {
            double d;
            double d2 = theta;
            thetaD = d2 / 180.0 * Math.PI;
            cosTheta = Math.cos(thetaD);
            sinTheta = Math.sin(thetaD);
            x0p = (x0 * cosTheta + y0 * sinTheta) / a;
            y0p = (-x0 * sinTheta + y0 * cosTheta) / b;
            x1p = (x1 * cosTheta + y1 * sinTheta) / a;
            y1p = (-x1 * sinTheta + y1 * cosTheta) / b;
            dx = x0p - x1p;
            dy = y0p - y1p;
            xm = (x0p + x1p) / 2.0;
            ym = (y0p + y1p) / 2.0;
            double d3 = dx;
            double d4 = dy;
            double dsq = d3 * d3 + d4 * d4;
            if (dsq == 0.0) {
                return;
            }
            disc = 1.0 / dsq - 0.25;
            if (!(d < 0.0)) break;
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            b *= (double)adjust;
            a *= (double)adjust;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double d = Math.atan2(y1p - cy, x1p - cx);
        double sweep = d - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= a;
        cx = cx * cosTheta - (cy *= b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        PathParserKt.arcToBezier(path, cx, cy, a, b, (double)var1_2, (double)var3_3, thetaD, eta0, sweep);
    }

    private static final void arcToBezier(Path p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        double eta1x = e1x;
        double eta1y = e1y;
        int numSegments = (int)Math.ceil(Math.abs(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + tanDiff2 * 3.0 * tanDiff2) - 1.0) / 3.0;
            double q1x = eta1x + alpha * ep1x;
            double q1y = eta1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p.cubicTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            eta1x = e2x;
            eta1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }
}

