/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.TransferParametersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u001b\u0010\u0018R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010!\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 "}, d2={"Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "", "", "gamma", "a", "b", "c", "d", "e", "f", "<init>", "(DDDDDDD)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getGamma", "()D", "getA", "getB", "getC", "getD", "getE", "getF", "isHLGish$ui_graphics", "()Z", "isHLGish", "isPQish$ui_graphics", "isPQish"})
public final class TransferParameters {
    private final double gamma;
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    /*
     * WARNING - void declaration
     */
    public TransferParameters(double gamma, double a, double b, double c, double d, double e, double f) {
        void var3_2;
        void var1_1;
        this.gamma = var1_1;
        this.a = var3_2;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
        if (Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f) || Double.isNaN(this.gamma)) {
            throw new IllegalArgumentException("Parameters cannot be NaN");
        }
        if (!TransferParametersKt.access$isSpecialG(this.gamma)) {
            if (!(this.d >= 0.0) || !(this.d <= 1.0)) {
                throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + this.d);
            }
            if (this.d == 0.0 && (this.a == 0.0 || this.gamma == 0.0)) {
                throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
            }
            if (this.d >= 1.0 && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
            }
            if ((this.a == 0.0 || this.gamma == 0.0) && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
            }
            if (this.c < 0.0) {
                throw new IllegalArgumentException("The transfer function must be increasing");
            }
            if (this.a < 0.0 || this.gamma < 0.0) {
                throw new IllegalArgumentException("The transfer function must be positive or increasing");
            }
        }
    }

    public /* synthetic */ TransferParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7);
    }

    public final double getGamma() {
        return this.gamma;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getE() {
        return this.e;
    }

    public final double getF() {
        return this.f;
    }

    public final boolean isHLGish$ui_graphics() {
        return this.gamma == -3.0;
    }

    public final boolean isPQish$ui_graphics() {
        return this.gamma == -2.0;
    }

    public final String toString() {
        return "TransferParameters(gamma=" + this.gamma + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", e=" + this.e + ", f=" + this.f + ")";
    }

    public final int hashCode() {
        int n = Double.hashCode(this.gamma);
        n = n * 31 + Double.hashCode(this.a);
        n = n * 31 + Double.hashCode(this.b);
        n = n * 31 + Double.hashCode(this.c);
        n = n * 31 + Double.hashCode(this.d);
        n = n * 31 + Double.hashCode(this.e);
        n = n * 31 + Double.hashCode(this.f);
        return n;
    }

    public final boolean equals(Object other) {
        TransferParameters transferParameters;
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransferParameters)) {
            return false;
        }
        transferParameters = transferParameters;
        if (Double.compare(this.gamma, transferParameters.gamma) != 0) {
            return false;
        }
        if (Double.compare(this.a, transferParameters.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, transferParameters.b) != 0) {
            return false;
        }
        if (Double.compare(this.c, transferParameters.c) != 0) {
            return false;
        }
        if (Double.compare(this.d, transferParameters.d) != 0) {
            return false;
        }
        if (Double.compare(this.e, transferParameters.e) != 0) {
            return false;
        }
        return Double.compare(this.f, transferParameters.f) == 0;
    }
}

