/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.DoubleFunction;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 W2\u00020\u0001:\u0001WB]\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014B1\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0016BA\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0019B!\b\u0010\u0012\u0006\u0010\u001a\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\"J'\u0010)\u001a\u00020&2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0010\u00a2\u0006\u0004\b'\u0010(J'\u0010,\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0010\u00a2\u0006\u0004\b*\u0010+J7\u00104\u001a\u0002012\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0010\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b5\u0010\"J\u001a\u00109\u001a\u0002082\b\u00107\u001a\u0004\u0018\u000106H\u0096\u0002\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b;\u0010<R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010=\u001a\u0004\b>\u0010?R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010@R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010@R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000f8\u0006\u00a2\u0006\u0006\n\u0004\b\u0010\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u001a\u0010\b\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\b\u0010B\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bE\u0010B\u001a\u0004\bF\u0010DR\u001a\u0010G\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170K8\u0006\u00a2\u0006\u0006\n\u0004\b\n\u0010LR\u001a\u0010M\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bM\u0010H\u001a\u0004\bN\u0010JR\u001a\u0010O\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bO\u0010H\u001a\u0004\bP\u0010JR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170K8\u0006\u00a2\u0006\u0006\n\u0004\b\u000b\u0010LR\u001a\u0010Q\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bQ\u0010H\u001a\u0004\bR\u0010JR\u0014\u0010S\u001a\u0002088\u0016X\u0096\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u001a\u0010U\u001a\u0002088\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bU\u0010T\u001a\u0004\bU\u0010V"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "name", "", "primaries", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "whitePoint", "transform", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "oetf", "eotf", "", "min", "max", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "transferParameters", "", "id", "<init>", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;[FLandroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;FFLandroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "function", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "", "gamma", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;DFFI)V", "colorSpace", "(Landroidx/compose/ui/graphics/colorspace/Rgb;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;)V", "component", "getMinValue", "(I)F", "getMaxValue", "v", "toXyz", "([F)[F", "v0", "v1", "v2", "", "toXy$ui_graphics", "(FFF)J", "toXy", "toZ$ui_graphics", "(FFF)F", "toZ", "x", "y", "z", "a", "Landroidx/compose/ui/graphics/Color;", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "xyzaToColor", "fromXyz", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "getWhitePoint", "()Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "F", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "[F", "getTransform$ui_graphics", "()[F", "inverseTransform", "getInverseTransform$ui_graphics", "oetfOrig", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "getOetfOrig$ui_graphics", "()Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "Lkotlin/Function1;", "Lkotlin/jvm/functions/Function1;", "oetfFunc", "getOetfFunc$ui_graphics", "eotfOrig", "getEotfOrig$ui_graphics", "eotfFunc", "getEotfFunc$ui_graphics", "isWideGamut", "Z", "isSrgb", "()Z", "Companion"})
@SourceDebugExtension(value={"SMAP\nRgb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb\n+ 2 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,1259:1\n638#2:1260\n653#2:1261\n668#2:1265\n638#2:1266\n653#2:1267\n668#2:1268\n53#3,3:1262\n*S KotlinDebug\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb\n*L\n788#1:1260\n789#1:1261\n799#1:1265\n811#1:1266\n812#1:1267\n813#1:1268\n791#1:1262,3\n*E\n"})
public final class Rgb
extends ColorSpace {
    public static final Companion Companion = new Companion(null);
    private final WhitePoint whitePoint;
    private final float min;
    private final float max;
    public final TransferParameters transferParameters;
    public final float[] primaries;
    private final float[] transform;
    private final float[] inverseTransform;
    private final DoubleFunction oetfOrig;
    public final Function1<Double, Double> oetf;
    private final DoubleFunction oetfFunc;
    private final DoubleFunction eotfOrig;
    public final Function1<Double, Double> eotf;
    private final DoubleFunction eotfFunc;
    public final boolean isWideGamut;
    private final boolean isSrgb;
    private static final DoubleFunction DoubleIdentity = Rgb::DoubleIdentity$lambda$10;

    /*
     * WARNING - void declaration
     */
    public Rgb(String name, float[] primaries, WhitePoint whitePoint, float[] transform, DoubleFunction oetf, DoubleFunction eotf, float min, float max, TransferParameters transferParameters, int id) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)oetf, (String)"oetf");
        Intrinsics.checkNotNullParameter((Object)eotf, (String)"eotf");
        super((String)var1_1, ColorModel.Companion.getRgb-xdoWZVw(), id, null);
        this.whitePoint = var3_3;
        this.min = min;
        this.max = max;
        this.transferParameters = transferParameters;
        this.oetfOrig = oetf;
        this.oetf = arg_0 -> Rgb.oetf$lambda$0(this, arg_0);
        this.oetfFunc = arg_0 -> Rgb.oetfFunc$lambda$1(this, arg_0);
        this.eotfOrig = eotf;
        this.eotf = arg_0 -> Rgb.eotf$lambda$2(this, arg_0);
        this.eotfFunc = arg_0 -> Rgb.eotfFunc$lambda$3(this, arg_0);
        if (primaries.length != 6 && primaries.length != 9) {
            throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
        }
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Invalid range: min=" + this.min + ", max=" + this.max + "; min must be strictly < max");
        }
        this.primaries = androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$xyPrimaries(Companion, (float[])var2_2);
        if (transform == null) {
            this.transform = androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$computeXYZMatrix(Companion, this.primaries, this.whitePoint);
        } else {
            if (transform.length != 9) {
                throw new IllegalArgumentException("Transform must have 9 entries! Has " + transform.length);
            }
            this.transform = transform;
        }
        this.inverseTransform = ColorSpaceKt.inverse3x3(this.transform);
        this.isWideGamut = androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$isWideGamut(Companion, this.primaries, this.min, this.max);
        this.isSrgb = androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$isSrgb(Companion, this.primaries, this.whitePoint, oetf, eotf, this.min, this.max, id);
    }

    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    public final float[] getTransform$ui_graphics() {
        return this.transform;
    }

    public final float[] getInverseTransform$ui_graphics() {
        return this.inverseTransform;
    }

    public final DoubleFunction getOetfOrig$ui_graphics() {
        return this.oetfOrig;
    }

    public final DoubleFunction getOetfFunc$ui_graphics() {
        return this.oetfFunc;
    }

    public final DoubleFunction getEotfOrig$ui_graphics() {
        return this.eotfOrig;
    }

    public final DoubleFunction getEotfFunc$ui_graphics() {
        return this.eotfFunc;
    }

    @Override
    public final boolean isSrgb() {
        return this.isSrgb;
    }

    /*
     * WARNING - void declaration
     */
    public Rgb(String name, float[] primaries, WhitePoint whitePoint, TransferParameters function, int id) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this((String)var1_1, (float[])var2_2, (WhitePoint)var3_3, null, androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$generateOetf(Companion, function), androidx.compose.ui.graphics.colorspace.Rgb$Companion.access$generateEotf(Companion, function), 0.0f, 1.0f, function, id);
    }

    /*
     * WARNING - void declaration
     */
    public Rgb(String name, float[] primaries, WhitePoint whitePoint, double gamma, float min, float max, int id) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this((String)var1_1, (float[])var2_2, (WhitePoint)var3_3, null, gamma == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$8(gamma, arg_0), gamma == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$9(gamma, arg_0), min, max, new TransferParameters(gamma, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 96, null), id);
    }

    /*
     * WARNING - void declaration
     */
    public Rgb(Rgb colorSpace, float[] transform, WhitePoint whitePoint) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(colorSpace.getName(), colorSpace.primaries, (WhitePoint)var3_3, (float[])var2_2, colorSpace.oetfOrig, colorSpace.eotfOrig, colorSpace.min, colorSpace.max, var1_1.transferParameters, -1);
    }

    @Override
    public final float getMinValue(int component) {
        return this.min;
    }

    @Override
    public final float getMaxValue(int component) {
        return this.max;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float[] toXyz(float[] v) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.eotfFunc.invoke(v[0]);
        v[1] = (float)this.eotfFunc.invoke(v[1]);
        v[2] = (float)this.eotfFunc.invoke(v[2]);
        return ColorSpaceKt.mul3x3Float3(this.transform, (float[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long toXy$ui_graphics(float v0, float v1, float v2) {
        void val1$iv;
        void r1$iv;
        void r0$iv;
        void lhs$iv;
        void var3_3;
        void var2_2;
        void var1_1;
        void r1$iv2;
        void r0$iv22;
        void lhs$iv2;
        float v00 = (float)this.eotfFunc.invoke(v0);
        float v10 = (float)this.eotfFunc.invoke(v1);
        float v20 = (float)this.eotfFunc.invoke(v2);
        if (this.transform.length < 9) {
            return 0L;
        }
        float[] fArray = this.transform;
        float f = v00;
        float f2 = v10;
        float r2$iv = v20;
        void x = lhs$iv2[0] * r0$iv22 + lhs$iv2[3] * r1$iv2 + lhs$iv2[6] * r2$iv;
        float[] r0$iv22 = this.transform;
        r1$iv2 = var1_1;
        r2$iv = var2_2;
        void r2$iv2 = var3_3;
        void y = lhs$iv[1] * r0$iv + lhs$iv[4] * r1$iv + lhs$iv[7] * r2$iv2;
        lhs$iv = x;
        void val2$iv = y;
        long v1$iv = Float.floatToRawIntBits((float)val1$iv);
        long v2$iv = Float.floatToRawIntBits((float)val2$iv);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float toZ$ui_graphics(float v0, float v1, float v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        void lhs$iv;
        float v00 = (float)this.eotfFunc.invoke(v0);
        float v10 = (float)this.eotfFunc.invoke(v1);
        float v20 = (float)this.eotfFunc.invoke(v2);
        float[] fArray = this.transform;
        var1_1 = lhs$iv[2] * var1_1 + lhs$iv[5] * var2_2 + lhs$iv[8] * var3_3;
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long xyzaToColor-JlNiLsg$ui_graphics(float x, float y, float z, float a, ColorSpace colorSpace) {
        void var1_1;
        void r1$iv;
        void r0$iv;
        void lhs$iv;
        void var3_3;
        void var2_2;
        float r1$iv2;
        void r0$iv32;
        void lhs$iv2;
        float r1$iv3;
        void r0$iv22;
        void lhs$iv3;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        float[] fArray = this.inverseTransform;
        float f = x;
        float f2 = y;
        float r2$iv = z;
        float v0 = lhs$iv3[0] * r0$iv22 + lhs$iv3[3] * r1$iv3 + lhs$iv3[6] * r2$iv;
        float[] r0$iv22 = this.inverseTransform;
        r1$iv3 = x;
        r2$iv = y;
        float r2$iv2 = z;
        float v1 = lhs$iv2[1] * r0$iv32 + lhs$iv2[4] * r1$iv2 + lhs$iv2[7] * r2$iv2;
        float[] r0$iv32 = this.inverseTransform;
        r1$iv2 = x;
        r2$iv2 = var2_2;
        void r2$iv3 = var3_3;
        float v2 = lhs$iv[2] * r0$iv + lhs$iv[5] * r1$iv + lhs$iv[8] * var1_1;
        v0 = (float)this.oetfFunc.invoke(v0);
        v1 = (float)this.oetfFunc.invoke(v1);
        v2 = (float)this.oetfFunc.invoke(v2);
        return ColorKt.Color(v0, v1, v2, a, colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float[] fromXyz(float[] v) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ColorSpaceKt.mul3x3Float3(this.inverseTransform, v);
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.oetfFunc.invoke(v[0]);
        v[1] = (float)this.oetfFunc.invoke(v[1]);
        v[2] = (float)this.oetfFunc.invoke(v[2]);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Rgb rgb = (Rgb)other;
        if (Float.compare(rgb.min, this.min) != 0) {
            return false;
        }
        if (Float.compare(rgb.max, this.max) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.whitePoint, (Object)rgb.whitePoint)) {
            return false;
        }
        if (!Arrays.equals(this.primaries, rgb.primaries)) {
            return false;
        }
        if (this.transferParameters != null) {
            return Intrinsics.areEqual((Object)this.transferParameters, (Object)rgb.transferParameters);
        }
        if (rgb.transferParameters == null) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.oetfOrig, (Object)rgb.oetfOrig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.eotfOrig, (Object)var1_1.eotfOrig);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = super.hashCode();
        result = result * 31 + this.whitePoint.hashCode();
        result = result * 31 + Arrays.hashCode(this.primaries);
        result = result * 31 + (!(this.min == 0.0f) ? Float.floatToIntBits(this.min) : 0);
        result = result * 31 + (!(this.max == 0.0f) ? Float.floatToIntBits(this.max) : 0);
        TransferParameters transferParameters = this.transferParameters;
        result = result * 31 + (transferParameters != null ? transferParameters.hashCode() : 0);
        if (this.transferParameters == null) {
            result = result * 31 + this.oetfOrig.hashCode();
            result = result * 31 + this.eotfOrig.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final double oetf$lambda$0(Rgb this$0, double x) {
        Rgb rgb;
        void var1_1;
        return RangesKt.coerceIn((double)this$0.oetfOrig.invoke((double)var1_1), (double)this$0.min, (double)rgb.max);
    }

    /*
     * WARNING - void declaration
     */
    private static final double oetfFunc$lambda$1(Rgb this$0, double x) {
        Rgb rgb;
        void var1_1;
        return RangesKt.coerceIn((double)this$0.oetfOrig.invoke((double)var1_1), (double)this$0.min, (double)rgb.max);
    }

    /*
     * WARNING - void declaration
     */
    private static final double eotf$lambda$2(Rgb this$0, double x) {
        Rgb rgb;
        void var1_1;
        return this$0.eotfOrig.invoke(RangesKt.coerceIn((double)var1_1, (double)this$0.min, (double)rgb.max));
    }

    /*
     * WARNING - void declaration
     */
    private static final double eotfFunc$lambda$3(Rgb this$0, double x) {
        Rgb rgb;
        void var1_1;
        return this$0.eotfOrig.invoke(RangesKt.coerceIn((double)var1_1, (double)this$0.min, (double)rgb.max));
    }

    /*
     * WARNING - void declaration
     */
    private static final double _init_$lambda$8(double $gamma, double x) {
        double d;
        void var2_1;
        return Math.pow(x < 0.0 ? 0.0 : var2_1, 1.0 / d);
    }

    /*
     * WARNING - void declaration
     */
    private static final double _init_$lambda$9(double $gamma, double x) {
        double d;
        void var2_1;
        return Math.pow(x < 0.0 ? 0.0 : var2_1, d);
    }

    private static final double DoubleIdentity$lambda$10(double d) {
        return d;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0081\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020\b2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020\b2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b)\u0010(R\u0014\u0010*\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb$Companion;", "", "<init>", "()V", "", "primaries", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "OETF", "EOTF", "", "min", "max", "", "id", "", "isSrgb", "([FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;FFI)Z", "", "point", "a", "b", "compare", "(DLandroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;)Z", "isWideGamut", "([FFF)Z", "area", "([F)F", "p1", "p2", "contains", "([F[F)Z", "xyPrimaries", "([F)[F", "computeXYZMatrix", "([FLandroidx/compose/ui/graphics/colorspace/WhitePoint;)[F", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "function", "generateOetf", "(Landroidx/compose/ui/graphics/colorspace/TransferParameters;)Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "generateEotf", "DoubleIdentity", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;"})
    @SourceDebugExtension(value={"SMAP\nRgb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb$Companion\n*L\n1#1,1259:1\n977#1:1260\n977#1:1261\n977#1:1262\n977#1:1263\n977#1:1264\n977#1:1265\n*S KotlinDebug\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb$Companion\n*L\n1050#1:1260\n1051#1:1261\n1057#1:1262\n1058#1:1263\n1063#1:1264\n1064#1:1265\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isSrgb(float[] primaries, WhitePoint whitePoint, DoubleFunction OETF, DoubleFunction EOTF, float min, float max, int id) {
            void var2_2;
            if (id == 0) {
                return true;
            }
            if (!ColorSpaceKt.compare(primaries, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics())) {
                return false;
            }
            if (!ColorSpaceKt.compare((WhitePoint)var2_2, Illuminant.INSTANCE.getD65())) {
                return false;
            }
            if (!(min == 0.0f)) {
                return false;
            }
            if (!(max == 1.0f)) {
                return false;
            }
            Rgb srgb = ColorSpaces.INSTANCE.getSrgb();
            for (double x = 0.0; x <= 1.0; x += 0.00392156862745098) {
                if (!this.compare(x, OETF, srgb.getOetfOrig$ui_graphics())) {
                    return false;
                }
                if (this.compare(x, EOTF, srgb.getEotfOrig$ui_graphics())) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean compare(double point, DoubleFunction a, DoubleFunction b) {
            void var1_1;
            double rB;
            double rA = a.invoke(point);
            return Math.abs(rA - (rB = b.invoke((double)var1_1))) <= 0.001;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isWideGamut(float[] primaries, float min, float max) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.area(primaries) / this.area(ColorSpaces.INSTANCE.getNtsc1953Primaries$ui_graphics()) > 0.9f && this.contains((float[])var1_1, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics()) || var2_2 < 0.0f && var3_3 > 1.0f;
        }

        /*
         * WARNING - void declaration
         */
        private final float area(float[] primaries) {
            void var1_2;
            float f;
            void var2_3;
            void var3_4;
            if (primaries.length < 6) {
                return 0.0f;
            }
            float rx = primaries[0];
            float ry = primaries[1];
            float gx = primaries[2];
            float gy = primaries[3];
            float bx = primaries[4];
            float by = primaries[5];
            float det = rx * gy + ry * bx + gx * by - gy * bx - var3_4 * gx - var2_3 * by;
            float r = 0.5f * det;
            if (f < 0.0f) {
                return -r;
            }
            return (float)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean contains(float[] p1, float[] p2) {
            float bx$iv;
            float ay$iv;
            float ax$iv;
            float[] fArray = new float[6];
            float[] fArray2 = fArray;
            fArray[0] = p1[0] - p2[0];
            fArray2[1] = p1[1] - p2[1];
            fArray2[2] = p1[2] - p2[2];
            fArray2[3] = p1[3] - p2[3];
            fArray2[4] = p1[4] - p2[4];
            fArray2[5] = p1[5] - p2[5];
            float[] p0 = fArray2;
            float f = fArray2[0];
            float f2 = p0[1];
            float f3 = p2[0] - p2[4];
            float by$iv = p2[1] - p2[5];
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f || (ax$iv = p2[0] - p2[2]) * (by$iv = p0[1]) - (ay$iv = p2[1] - p2[3]) * (bx$iv = p0[0]) < 0.0f) {
                return false;
            }
            ax$iv = p0[2];
            by$iv = p2[3] - p2[1];
            ay$iv = p0[3];
            bx$iv = p2[2] - p2[0];
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f || (ax$iv = p2[2] - p2[4]) * (by$iv = p0[3]) - (ay$iv = p2[3] - p2[5]) * (bx$iv = p0[2]) < 0.0f) {
                return false;
            }
            ax$iv = p0[4];
            by$iv = p2[5] - p2[3];
            ay$iv = p0[5];
            bx$iv = p2[4] - p2[2];
            if (!(ax$iv * by$iv - ay$iv * bx$iv < 0.0f)) {
                void var2_2;
                void var1_1;
                ax$iv = p2[4] - p2[0];
                by$iv = var1_1[5];
                ay$iv = p2[5] - var2_2[1];
                bx$iv = p0[4];
                if (!(f * by$iv - ay$iv * bx$iv < 0.0f)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final float[] xyPrimaries(float[] primaries) {
            void var2_2;
            float[] xyPrimaries = new float[6];
            if (primaries.length == 9) {
                void var3_3;
                float sum = primaries[0] + primaries[1] + primaries[2];
                xyPrimaries[0] = primaries[0] / sum;
                xyPrimaries[1] = primaries[1] / sum;
                sum = primaries[3] + primaries[4] + primaries[5];
                xyPrimaries[2] = primaries[3] / sum;
                xyPrimaries[3] = primaries[4] / sum;
                sum = primaries[6] + primaries[7] + primaries[8];
                xyPrimaries[4] = primaries[6] / sum;
                xyPrimaries[5] = primaries[7] / var3_3;
            } else {
                void var1_1;
                ArraysKt.copyInto$default((float[])var1_1, (float[])xyPrimaries, (int)0, (int)0, (int)6, (int)6, null);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final float[] computeXYZMatrix(float[] primaries, WhitePoint whitePoint) {
            void var1_2;
            void var2_4;
            void var3_5;
            float rx = primaries[0];
            float ry = primaries[1];
            float gx = primaries[2];
            float gy = primaries[3];
            float bx = primaries[4];
            float by = primaries[5];
            float wx = whitePoint.getX();
            float wy = whitePoint.getY();
            float oneRxRy = (1.0f - rx) / ry;
            float oneGxGy = (1.0f - gx) / gy;
            float oneBxBy = (1.0f - bx) / by;
            float oneWxWy = (1.0f - wx) / wy;
            float rxRy = rx / ry;
            float gxGy = gx / gy;
            float bxBy = bx / by;
            float wxWy = wx / wy;
            float byNumerator = (oneWxWy - oneRxRy) * (gxGy - rxRy) - (wxWy - rxRy) * (oneGxGy - oneRxRy);
            float byDenominator = (oneBxBy - oneRxRy) * (gxGy - rxRy) - (bxBy - rxRy) * (oneGxGy - oneRxRy);
            float bY = byNumerator / byDenominator;
            float gY = (wxWy - rxRy - bY * (bxBy - rxRy)) / (gxGy - rxRy);
            float rY = 1.0f - gY - bY;
            float rYRy = rY / ry;
            float gYGy = gY / gy;
            float bYBy = bY / by;
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = rYRy * rx;
            fArray2[1] = rY;
            fArray2[2] = rYRy * (1.0f - var3_5 - ry);
            fArray2[3] = gYGy * gx;
            fArray2[4] = var2_4;
            fArray2[5] = gYGy * (1.0f - gx - gy);
            fArray2[6] = bYBy * bx;
            fArray2[7] = bY;
            fArray2[8] = bYBy * (1.0f - bx - var1_2);
            return fArray2;
        }

        /*
         * WARNING - void declaration
         */
        private final DoubleFunction generateOetf(TransferParameters function) {
            void var1_1;
            if (function.isHLGish$ui_graphics()) {
                return arg_0 -> Companion.generateOetf$lambda$0(function, arg_0);
            }
            if (function.isPQish$ui_graphics()) {
                return arg_0 -> Companion.generateOetf$lambda$1(function, arg_0);
            }
            if (function.getE() == 0.0 && function.getF() == 0.0) {
                return arg_0 -> Companion.generateOetf$lambda$2(function, arg_0);
            }
            return arg_0 -> Companion.generateOetf$lambda$3((TransferParameters)var1_1, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        private final DoubleFunction generateEotf(TransferParameters function) {
            void var1_1;
            if (function.isHLGish$ui_graphics()) {
                return arg_0 -> Companion.generateEotf$lambda$4(function, arg_0);
            }
            if (function.isPQish$ui_graphics()) {
                return arg_0 -> Companion.generateEotf$lambda$5(function, arg_0);
            }
            if (function.getE() == 0.0 && function.getF() == 0.0) {
                return arg_0 -> Companion.generateEotf$lambda$6(function, arg_0);
            }
            return arg_0 -> Companion.generateEotf$lambda$7((TransferParameters)var1_1, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        private static final double generateOetf$lambda$0(TransferParameters $function, double x) {
            void var1_1;
            TransferParameters transferParameters;
            return ColorSpaces.INSTANCE.transferHlgOetf$ui_graphics(transferParameters, (double)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static final double generateOetf$lambda$1(TransferParameters $function, double x) {
            void var1_1;
            TransferParameters transferParameters;
            return ColorSpaces.INSTANCE.transferSt2048Oetf$ui_graphics(transferParameters, (double)var1_1);
        }

        private static final double generateOetf$lambda$2(TransferParameters $function, double x) {
            TransferParameters transferParameters;
            return ColorSpaceKt.rcpResponse(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), transferParameters.getGamma());
        }

        private static final double generateOetf$lambda$3(TransferParameters $function, double x) {
            TransferParameters transferParameters;
            return ColorSpaceKt.rcpResponse(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getE(), $function.getF(), transferParameters.getGamma());
        }

        /*
         * WARNING - void declaration
         */
        private static final double generateEotf$lambda$4(TransferParameters $function, double x) {
            void var1_1;
            TransferParameters transferParameters;
            return ColorSpaces.INSTANCE.transferHlgEotf$ui_graphics(transferParameters, (double)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static final double generateEotf$lambda$5(TransferParameters $function, double x) {
            void var1_1;
            TransferParameters transferParameters;
            return ColorSpaces.INSTANCE.transferSt2048Eotf$ui_graphics(transferParameters, (double)var1_1);
        }

        private static final double generateEotf$lambda$6(TransferParameters $function, double x) {
            TransferParameters transferParameters;
            return ColorSpaceKt.response(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), transferParameters.getGamma());
        }

        private static final double generateEotf$lambda$7(TransferParameters $function, double x) {
            TransferParameters transferParameters;
            return ColorSpaceKt.response(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getE(), $function.getF(), transferParameters.getGamma());
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ float[] access$xyPrimaries(Companion $this, float[] primaries) {
            void var1_1;
            return $this.xyPrimaries((float[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ float[] access$computeXYZMatrix(Companion $this, float[] primaries, WhitePoint whitePoint) {
            void var2_2;
            void var1_1;
            return $this.computeXYZMatrix((float[])var1_1, (WhitePoint)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$isWideGamut(Companion $this, float[] primaries, float min, float max) {
            void var3_3;
            void var2_2;
            void var1_1;
            return $this.isWideGamut((float[])var1_1, (float)var2_2, (float)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$isSrgb(Companion $this, float[] primaries, WhitePoint whitePoint, DoubleFunction OETF, DoubleFunction EOTF, float min, float max, int id) {
            void var3_3;
            void var2_2;
            void var1_1;
            return $this.isSrgb((float[])var1_1, (WhitePoint)var2_2, (DoubleFunction)var3_3, EOTF, min, max, id);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ DoubleFunction access$generateOetf(Companion $this, TransferParameters function) {
            void var1_1;
            return $this.generateOetf((TransferParameters)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ DoubleFunction access$generateEotf(Companion $this, TransferParameters function) {
            void var1_1;
            return $this.generateEotf((TransferParameters)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

