/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.Lab;
import androidx.compose.ui.graphics.colorspace.Oklab;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import androidx.compose.ui.graphics.colorspace.Xyz;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u000b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\r\u0010\tJ\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0010\u0010\tR\u001a\u0010\u0013\u001a\u00020\u00128\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u00128\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00128\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001bR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b&\u0010!R\u0011\u0010'\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b'\u0010!R\u0011\u0010(\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b(\u0010!R\u0011\u0010)\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b)\u0010!R\u0011\u0010*\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b*\u0010!R\u0017\u0010+\u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b+\u0010!\u001a\u0004\b,\u0010#R\u0011\u0010-\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b-\u0010!R\u0011\u0010.\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b.\u0010!R\u0011\u0010/\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b/\u0010!R\u0011\u00100\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b0\u0010!R\u0011\u00101\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b1\u0010!R\u0011\u00102\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b2\u0010!R\u0011\u00104\u001a\u0002038\u0006\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0011\u00106\u001a\u0002038\u0006\u00a2\u0006\u0006\n\u0004\b6\u00105R\u001a\u00107\u001a\u00020\u001f8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b7\u0010!\u001a\u0004\b8\u0010#R\u0011\u00109\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b9\u0010!R\u0011\u0010:\u001a\u00020\u001f8\u0006\u00a2\u0006\u0006\n\u0004\b:\u0010!R\u0017\u0010;\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b;\u00105\u001a\u0004\b<\u0010=R \u0010?\u001a\b\u0012\u0004\u0012\u0002030>8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpaces;", "", "<init>", "()V", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "params", "", "x", "transferHlgOetf$ui_graphics", "(Landroidx/compose/ui/graphics/colorspace/TransferParameters;D)D", "transferHlgOetf", "transferHlgEotf$ui_graphics", "transferHlgEotf", "transferSt2048Oetf$ui_graphics", "transferSt2048Oetf", "pq", "transferSt2048Eotf$ui_graphics", "transferSt2048Eotf", "", "SrgbPrimaries", "[F", "getSrgbPrimaries$ui_graphics", "()[F", "Ntsc1953Primaries", "getNtsc1953Primaries$ui_graphics", "Bt2020Primaries", "SrgbTransferParameters", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "NoneTransferParameters", "Bt2020HlgTransferParameters", "Bt2020PqTransferParameters", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "Srgb", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "getSrgb", "()Landroidx/compose/ui/graphics/colorspace/Rgb;", "LinearSrgb", "getLinearSrgb", "ExtendedSrgb", "LinearExtendedSrgb", "Bt709", "Bt2020", "DciP3", "DisplayP3", "getDisplayP3", "Ntsc1953", "SmpteC", "AdobeRgb", "ProPhotoRgb", "Aces", "Acescg", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "CieXyz", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "CieLab", "Unspecified", "getUnspecified$ui_graphics", "Bt2020Hlg", "Bt2020Pq", "Oklab", "getOklab", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "ColorSpacesArray", "[Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getColorSpacesArray$ui_graphics", "()[Landroidx/compose/ui/graphics/colorspace/ColorSpace;"})
public final class ColorSpaces {
    public static final ColorSpaces INSTANCE = new ColorSpaces();
    private static final float[] SrgbPrimaries;
    private static final float[] Ntsc1953Primaries;
    public static final float[] Bt2020Primaries;
    public static final TransferParameters SrgbTransferParameters;
    private static final TransferParameters NoneTransferParameters;
    public static final TransferParameters Bt2020HlgTransferParameters;
    public static final TransferParameters Bt2020PqTransferParameters;
    private static final Rgb Srgb;
    private static final Rgb LinearSrgb;
    public static final Rgb ExtendedSrgb;
    public static final Rgb LinearExtendedSrgb;
    public static final Rgb Bt709;
    public static final Rgb Bt2020;
    public static final Rgb DciP3;
    private static final Rgb DisplayP3;
    public static final Rgb Ntsc1953;
    public static final Rgb SmpteC;
    public static final Rgb AdobeRgb;
    public static final Rgb ProPhotoRgb;
    public static final Rgb Aces;
    public static final Rgb Acescg;
    public static final ColorSpace CieXyz;
    public static final ColorSpace CieLab;
    private static final Rgb Unspecified;
    public static final Rgb Bt2020Hlg;
    public static final Rgb Bt2020Pq;
    private static final ColorSpace Oklab;
    private static final ColorSpace[] ColorSpacesArray;

    private ColorSpaces() {
    }

    public final float[] getSrgbPrimaries$ui_graphics() {
        return SrgbPrimaries;
    }

    public final float[] getNtsc1953Primaries$ui_graphics() {
        return Ntsc1953Primaries;
    }

    public final Rgb getSrgb() {
        return Srgb;
    }

    public final Rgb getLinearSrgb() {
        return LinearSrgb;
    }

    public final Rgb getDisplayP3() {
        return DisplayP3;
    }

    public final Rgb getUnspecified$ui_graphics() {
        return Unspecified;
    }

    public final ColorSpace getOklab() {
        return Oklab;
    }

    public final ColorSpace[] getColorSpacesArray$ui_graphics() {
        return ColorSpacesArray;
    }

    /*
     * WARNING - void declaration
     */
    public final double transferHlgOetf$ui_graphics(TransferParameters params, double x) {
        void v0;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        void absX = var2_2 * sign;
        double R = 1.0 / params.getA();
        double G = 1.0 / params.getB();
        double a = 1.0 / params.getC();
        double b = params.getD();
        double c = params.getE();
        double K = var1_1.getF() + 1.0;
        double result = v0 <= 1.0 ? R * Math.pow((double)absX, G) : a * Math.log((double)((absX /= K) - b)) + c;
        return sign * result;
    }

    /*
     * WARNING - void declaration
     */
    public final double transferHlgEotf$ui_graphics(TransferParameters params, double x) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        void absX = var2_2 * sign;
        double R = params.getA();
        double G = params.getB();
        double a = params.getC();
        double b = params.getD();
        double c = params.getE();
        double K = var1_1.getF() + 1.0;
        double result = absX * R <= 1.0 ? Math.pow((double)(absX * R), G) : Math.exp((double)((absX - c) * a)) + b;
        return K * sign * result;
    }

    /*
     * WARNING - void declaration
     */
    public final double transferSt2048Oetf$ui_graphics(TransferParameters params, double x) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        double sign = x < 0.0 ? -1.0 : 1.0;
        void absX = var2_2 * sign;
        double a = -params.getA();
        double b = params.getD();
        double c = 1.0 / params.getF();
        double d = params.getB();
        double e = -params.getE();
        double f = 1.0 / var1_1.getC();
        double tmp = Math.max(a + b * Math.pow((double)absX, c), 0.0);
        return sign * Math.pow(tmp / (d + e * Math.pow((double)absX, c)), f);
    }

    /*
     * WARNING - void declaration
     */
    public final double transferSt2048Eotf$ui_graphics(TransferParameters pq, double x) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)pq, (String)"pq");
        double sign = x < 0.0 ? -1.0 : 1.0;
        void absX = var2_2 * sign;
        double tmp = RangesKt.coerceAtLeast((double)(pq.getA() + pq.getB() * Math.pow((double)absX, pq.getC())), (double)0.0);
        return sign * Math.pow(tmp / (pq.getD() + pq.getE() * Math.pow((double)absX, pq.getC())), var1_1.getF());
    }

    private static final double ExtendedSrgb$lambda$0(double x) {
        return ColorSpaceKt.absRcpResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    private static final double ExtendedSrgb$lambda$1(double x) {
        return ColorSpaceKt.absResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    private static final double Bt2020Hlg$lambda$2(double x) {
        double d;
        return INSTANCE.transferHlgOetf$ui_graphics(Bt2020HlgTransferParameters, d);
    }

    private static final double Bt2020Hlg$lambda$3(double x) {
        double d;
        return INSTANCE.transferHlgEotf$ui_graphics(Bt2020HlgTransferParameters, d);
    }

    private static final double Bt2020Pq$lambda$4(double x) {
        double d;
        return INSTANCE.transferSt2048Oetf$ui_graphics(Bt2020PqTransferParameters, d);
    }

    private static final double Bt2020Pq$lambda$5(double x) {
        double d;
        return INSTANCE.transferSt2048Eotf$ui_graphics(Bt2020PqTransferParameters, d);
    }

    static {
        float[] fArray = new float[6];
        Object[] objectArray = fArray;
        fArray[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.3f;
        objectArray[3] = 0.6f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        SrgbPrimaries = objectArray;
        float[] fArray2 = new float[6];
        objectArray = fArray2;
        fArray2[0] = 0.67f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.21f;
        objectArray[3] = 0.71f;
        objectArray[4] = 0.14f;
        objectArray[5] = 0.08f;
        Ntsc1953Primaries = objectArray;
        float[] fArray3 = new float[6];
        objectArray = fArray3;
        fArray3[0] = 0.708f;
        objectArray[1] = 0.292f;
        objectArray[2] = 0.17f;
        objectArray[3] = 0.797f;
        objectArray[4] = 0.131f;
        objectArray[5] = 0.046f;
        Bt2020Primaries = objectArray;
        SrgbTransferParameters = new TransferParameters(2.4, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        NoneTransferParameters = new TransferParameters(2.2, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        Bt2020HlgTransferParameters = new TransferParameters(-3.0, 2.0, 2.0, 5.591816309728916, 0.28466892, 0.55991073, -0.685490157);
        Bt2020PqTransferParameters = new TransferParameters(-2.0, -1.555223, 1.860454, 0.012683313515655966, 18.8515625, -18.6875, 6.277394636015326);
        Srgb = new Rgb("sRGB IEC61966-2.1", SrgbPrimaries, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 0);
        LinearSrgb = new Rgb("sRGB IEC61966-2.1 (Linear)", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, 0.0f, 1.0f, 1);
        ExtendedSrgb = new Rgb("scRGB-nl IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::ExtendedSrgb$lambda$0, ColorSpaces::ExtendedSrgb$lambda$1, -0.799f, 2.399f, SrgbTransferParameters, 2);
        LinearExtendedSrgb = new Rgb("scRGB IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, -0.5f, 7.499f, 3);
        float[] fArray4 = new float[6];
        objectArray = fArray4;
        fArray4[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.3f;
        objectArray[3] = 0.6f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        Bt709 = new Rgb("Rec. ITU-R BT.709-5", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 4);
        float[] fArray5 = new float[6];
        objectArray = fArray5;
        fArray5[0] = 0.708f;
        objectArray[1] = 0.292f;
        objectArray[2] = 0.17f;
        objectArray[3] = 0.797f;
        objectArray[4] = 0.131f;
        objectArray[5] = 0.046f;
        Bt2020 = new Rgb("Rec. ITU-R BT.2020-1", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9096697898662786, 0.09033021013372146, 0.2222222222222222, 0.08145, 0.0, 0.0, 96, null), 5);
        float[] fArray6 = new float[6];
        objectArray = fArray6;
        fArray6[0] = 0.68f;
        objectArray[1] = 0.32f;
        objectArray[2] = 0.265f;
        objectArray[3] = 0.69f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        DciP3 = new Rgb("SMPTE RP 431-2-2007 DCI (P3)", (float[])objectArray, new WhitePoint(0.314f, 0.351f), 2.6, 0.0f, 1.0f, 6);
        float[] fArray7 = new float[6];
        objectArray = fArray7;
        fArray7[0] = 0.68f;
        objectArray[1] = 0.32f;
        objectArray[2] = 0.265f;
        objectArray[3] = 0.69f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        DisplayP3 = new Rgb("Display P3", (float[])objectArray, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 7);
        Ntsc1953 = new Rgb("NTSC (1953)", Ntsc1953Primaries, Illuminant.INSTANCE.getC(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 8);
        float[] fArray8 = new float[6];
        objectArray = fArray8;
        fArray8[0] = 0.63f;
        objectArray[1] = 0.34f;
        objectArray[2] = 0.31f;
        objectArray[3] = 0.595f;
        objectArray[4] = 0.155f;
        objectArray[5] = 0.07f;
        SmpteC = new Rgb("SMPTE-C RGB", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 9);
        float[] fArray9 = new float[6];
        objectArray = fArray9;
        fArray9[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.21f;
        objectArray[3] = 0.71f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        AdobeRgb = new Rgb("Adobe RGB (1998)", (float[])objectArray, Illuminant.INSTANCE.getD65(), 2.2, 0.0f, 1.0f, 10);
        float[] fArray10 = new float[6];
        objectArray = fArray10;
        fArray10[0] = 0.7347f;
        objectArray[1] = 0.2653f;
        objectArray[2] = 0.1596f;
        objectArray[3] = 0.8404f;
        objectArray[4] = 0.0366f;
        objectArray[5] = 1.0E-4f;
        ProPhotoRgb = new Rgb("ROMM RGB ISO 22028-2:2013", (float[])objectArray, Illuminant.INSTANCE.getD50(), new TransferParameters(1.8, 1.0, 0.0, 0.0625, 0.031248, 0.0, 0.0, 96, null), 11);
        float[] fArray11 = new float[6];
        objectArray = fArray11;
        fArray11[0] = 0.7347f;
        objectArray[1] = 0.2653f;
        objectArray[2] = 0.0f;
        objectArray[3] = 1.0f;
        objectArray[4] = 1.0E-4f;
        objectArray[5] = -0.077f;
        Aces = new Rgb("SMPTE ST 2065-1:2012 ACES", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 12);
        float[] fArray12 = new float[6];
        objectArray = fArray12;
        fArray12[0] = 0.713f;
        objectArray[1] = 0.293f;
        objectArray[2] = 0.165f;
        objectArray[3] = 0.83f;
        objectArray[4] = 0.128f;
        objectArray[5] = 0.044f;
        Acescg = new Rgb("Academy S-2014-004 ACEScg", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 13);
        CieXyz = new Xyz("Generic XYZ", 14);
        CieLab = new Lab("Generic L*a*b*", 15);
        Unspecified = new Rgb("None", SrgbPrimaries, Illuminant.INSTANCE.getD65(), NoneTransferParameters, 16);
        Bt2020Hlg = new Rgb("Hybrid Log Gamma encoding", Bt2020Primaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::Bt2020Hlg$lambda$2, ColorSpaces::Bt2020Hlg$lambda$3, 0.0f, 1.0f, Bt2020HlgTransferParameters, 17);
        Bt2020Pq = new Rgb("Perceptual Quantizer encoding", Bt2020Primaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::Bt2020Pq$lambda$4, ColorSpaces::Bt2020Pq$lambda$5, 0.0f, 1.0f, Bt2020PqTransferParameters, 18);
        Oklab = new Oklab("Oklab", 19);
        ColorSpace[] colorSpaceArray = new ColorSpace[20];
        objectArray = colorSpaceArray;
        colorSpaceArray[0] = Srgb;
        objectArray[1] = (float)LinearSrgb;
        objectArray[2] = (float)ExtendedSrgb;
        objectArray[3] = (float)LinearExtendedSrgb;
        objectArray[4] = (float)Bt709;
        objectArray[5] = (float)Bt2020;
        objectArray[6] = (float)DciP3;
        objectArray[7] = (float)DisplayP3;
        objectArray[8] = (float)Ntsc1953;
        objectArray[9] = (float)SmpteC;
        objectArray[10] = (float)AdobeRgb;
        objectArray[11] = (float)ProPhotoRgb;
        objectArray[12] = (float)Aces;
        objectArray[13] = (float)Acescg;
        objectArray[14] = (float)CieXyz;
        objectArray[15] = (float)CieLab;
        objectArray[16] = (float)Unspecified;
        objectArray[17] = (float)Bt2020Hlg;
        objectArray[18] = (float)Bt2020Pq;
        objectArray[19] = (float)Oklab;
        ColorSpacesArray = (ColorSpace[])objectArray;
    }
}

