/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0010\b'\u0018\u0000 >2\u00020\u0001:\u0001>B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\u000e\u0010\rJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0013\u0010\u0016J'\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010 \u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010)\u001a\u00020&2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0000H\u0010\u00a2\u0006\u0004\b'\u0010(J%\u0010*\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b\u00a2\u0006\u0004\b*\u0010\u0014J\u0017\u0010*\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H&\u00a2\u0006\u0004\b*\u0010\u0016J\u000f\u0010+\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001a\u0010/\u001a\u00020.2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b1\u00102R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00103\u001a\u0004\b4\u0010,R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00105\u001a\u0004\b6\u00107R\u001a\u0010\u0007\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00108\u001a\u0004\b9\u00102R\u0011\u0010;\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b:\u00102R\u0014\u0010<\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010="}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "", "name", "Landroidx/compose/ui/graphics/colorspace/ColorModel;", "model", "", "id", "<init>", "(Ljava/lang/String;JILkotlin/jvm/internal/DefaultConstructorMarker;)V", "component", "", "getMinValue", "(I)F", "getMaxValue", "r", "g", "b", "", "toXyz", "(FFF)[F", "v", "([F)[F", "v0", "v1", "v2", "", "toXy$ui_graphics", "(FFF)J", "toXy", "toZ$ui_graphics", "(FFF)F", "toZ", "x", "y", "z", "a", "colorSpace", "Landroidx/compose/ui/graphics/Color;", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "xyzaToColor", "fromXyz", "toString", "()Ljava/lang/String;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getName", "J", "getModel-xdoWZVw", "()J", "I", "getId$ui_graphics", "getComponentCount", "componentCount", "isSrgb", "()Z", "Companion"})
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,717:1\n53#2,3:718\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n*L\n246#1:718,3\n*E\n"})
public abstract class ColorSpace {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final long model;
    private final int id;

    /*
     * WARNING - void declaration
     */
    private ColorSpace(String name, long model, int id) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = var1_1;
        this.model = var2_2;
        this.id = id;
        if (((CharSequence)this.name).length() == 0) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (this.id < -1 || this.id > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final long getModel-xdoWZVw() {
        return this.model;
    }

    public final int getId$ui_graphics() {
        return this.id;
    }

    public final int getComponentCount() {
        return ColorModel.getComponentCount-impl(this.model);
    }

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(int var1);

    public abstract float getMaxValue(int var1);

    /*
     * WARNING - void declaration
     */
    public final float[] toXyz(float r, float g, float b) {
        void var3_3;
        void var2_2;
        void var1_1;
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = var1_1;
        fArray2[1] = var2_2;
        fArray2[2] = var3_3;
        return this.toXyz(fArray2);
    }

    public abstract float[] toXyz(float[] var1);

    /*
     * WARNING - void declaration
     */
    public long toXy$ui_graphics(float v0, float v1, float v2) {
        void var1_3;
        void var2_4;
        void var3_5;
        float[] xyz = this.toXyz(v0, v1, (float)var3_5);
        v1 = xyz[0];
        float val2$iv = xyz[1];
        long v1$iv = Float.floatToRawIntBits((float)var2_4);
        long v2$iv = Float.floatToRawIntBits((float)var1_3);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    public float toZ$ui_graphics(float v0, float v1, float v2) {
        void var3_4;
        void var2_3;
        void var1_1;
        float[] fArray = this.toXyz((float)var1_1, (float)var2_3, (float)var3_4);
        return fArray[2];
    }

    /*
     * WARNING - void declaration
     */
    public long xyzaToColor-JlNiLsg$ui_graphics(float x, float y, float z, float a, ColorSpace colorSpace) {
        void var1_2;
        void var3_4;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        float[] colors = this.fromXyz(x, (float)var2_3, (float)var3_4);
        return ColorKt.Color(colors[0], colors[1], (float)var1_2[2], a, colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    public final float[] fromXyz(float x, float y, float z) {
        void var3_3;
        void var2_2;
        void var1_1;
        float[] fArray = new float[ColorModel.getComponentCount-impl(this.model)];
        float[] xyz = fArray;
        fArray[0] = var1_1;
        xyz[1] = var2_2;
        xyz[2] = var3_3;
        return this.fromXyz(xyz);
    }

    public abstract float[] fromXyz(float[] var1);

    public String toString() {
        return this.name + " (id=" + this.id + ", model=" + ColorModel.toString-impl(this.model) + ")";
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColorSpace that = (ColorSpace)other;
        if (this.id != that.id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)that.name)) {
            return false;
        }
        return ColorModel.equals-impl0(this.model, var1_1.model);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.name.hashCode();
        result = result * 31 + ColorModel.hashCode-impl(this.model);
        var1_1 = var1_1 * 31 + this.id;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ ColorSpace(String name, long model, int id, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1, (long)var2_2, id);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

