/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BufferedImagePainter;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010,R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010-R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010.R\u0014\u0010\u0018\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010/R\u0014\u0010\u0019\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010/R\u001b\u00104\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001b\u00107\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00101\u001a\u0004\b6\u00103"}, d2={"Landroidx/compose/ui/graphics/PainterImage;", "Ljava/awt/Image;", "Ljava/awt/image/MultiResolutionImage;", "Landroidx/compose/ui/graphics/painter/Painter;", "painter", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "Landroidx/compose/ui/geometry/Size;", "size", "<init>", "(Landroidx/compose/ui/graphics/painter/Painter;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/awt/image/ImageObserver;", "observer", "", "getWidth", "(Ljava/awt/image/ImageObserver;)I", "getHeight", "", "destImageWidth", "destImageHeight", "getResolutionVariant", "(DD)Ljava/awt/Image;", "width", "height", "Landroidx/compose/ui/graphics/ImageBitmap;", "asBitmap", "(II)Landroidx/compose/ui/graphics/ImageBitmap;", "", "name", "", "getProperty", "(Ljava/lang/String;Ljava/awt/image/ImageObserver;)Ljava/lang/Object;", "Ljava/awt/image/ImageProducer;", "getSource", "()Ljava/awt/image/ImageProducer;", "Ljava/awt/Graphics;", "getGraphics", "()Ljava/awt/Graphics;", "", "Ljava/awt/image/BufferedImage;", "getResolutionVariants", "()Ljava/util/List;", "Landroidx/compose/ui/graphics/painter/Painter;", "Landroidx/compose/ui/unit/Density;", "Landroidx/compose/ui/unit/LayoutDirection;", "I", "defaultImage$delegate", "Lkotlin/Lazy;", "getDefaultImage", "()Ljava/awt/image/BufferedImage;", "defaultImage", "scaledImage$delegate", "getScaledImage", "scaledImage"})
@SourceDebugExtension(value={"SMAP\nDesktopImageConverters.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n+ 2 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 6 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,266:1\n57#2:267\n61#2:270\n60#3:268\n70#3:271\n53#3,3:274\n22#4:269\n22#4:272\n33#5:273\n536#6,17:277\n*S KotlinDebug\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n*L\n137#1:267\n138#1:270\n137#1:268\n138#1:271\n162#1:274,3\n137#1:269\n138#1:272\n162#1:273\n164#1:277,17\n*E\n"})
final class PainterImage
extends Image
implements MultiResolutionImage {
    private final Painter painter;
    private final Density density;
    private final LayoutDirection layoutDirection;
    private final int width;
    private final int height;
    private final Lazy defaultImage$delegate;
    private final Lazy scaledImage$delegate;

    /*
     * WARNING - void declaration
     */
    private PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size) {
        long l;
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        this.painter = var1_1;
        this.density = var2_3;
        this.layoutDirection = var3_4;
        long l2 = l = size;
        int n = (int)(l >> 32);
        this.width = (int)Float.intBitsToFloat(n);
        l2 = l = size;
        n = (int)l;
        this.height = (int)Float.intBitsToFloat(n);
        this.defaultImage$delegate = LazyKt.lazy(() -> PainterImage.defaultImage_delegate$lambda$2(this));
        this.scaledImage$delegate = LazyKt.lazy(() -> PainterImage.scaledImage_delegate$lambda$3(this));
    }

    @Override
    public final int getWidth(ImageObserver observer) {
        return this.width;
    }

    @Override
    public final int getHeight(ImageObserver observer) {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        void var2_4;
        void var1_2;
        void var3_3;
        int width = (int)destImageWidth;
        int height = (int)var3_3;
        if (this.painter instanceof BufferedImagePainter && ((BufferedImagePainter)this.painter).getImage().getWidth() == width && ((BufferedImagePainter)this.painter).getImage().getHeight() == height) {
            return ((BufferedImagePainter)this.painter).getImage();
        }
        return DesktopImageConverters_desktopKt.toAwtImage(this.asBitmap((int)var1_2, (int)var2_4));
    }

    /*
     * WARNING - void declaration
     */
    private final ImageBitmap asBitmap(int width2, int height) {
        void var3_7;
        void var1_3;
        void var2_6;
        void canvas$iv;
        void layoutDirection$iv;
        void density$iv;
        CanvasDrawScope.DrawParams drawParams;
        void this_$iv;
        void val1$iv$iv22;
        void width$iv22;
        ImageBitmap bitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(width2, height, 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(bitmap);
        float width2 = width2;
        float height$iv22 = height;
        void var8_9 = width$iv22;
        float val2$iv$iv = height$iv22;
        long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv22);
        long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
        long floatSize = Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        CanvasDrawScope width$iv22 = new CanvasDrawScope();
        Density height$iv22 = this.density;
        Object object = this.layoutDirection;
        Canvas val1$iv$iv22 = canvas;
        long size$iv = floatSize;
        CanvasDrawScope.DrawParams drawParams2 = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams2.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams2.component2();
        Canvas prevCanvas$iv = drawParams2.component3();
        long prevSize$iv = drawParams2.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = drawParams = this_$iv.getDrawParams();
        drawParams.setDensity((Density)density$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection((LayoutDirection)layoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas((Canvas)canvas$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(size$iv);
        canvas$iv.save();
        DrawScope $this$asBitmap_u24lambda_u241 = (DrawScope)this_$iv;
        object = this.painter;
        Painter.draw-x_KDEd0$default((Painter)object, (DrawScope)var2_6, floatSize, 0.0f, null, 6, null);
        canvas$iv.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = $this$draw_yzxVdVo_u24lambda_u240$iv = var1_3.getDrawParams();
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return var3_7;
    }

    @Override
    public final Object getProperty(String name, ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = Image.UndefinedProperty;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UndefinedProperty");
        return object;
    }

    @Override
    public final ImageProducer getSource() {
        ImageProducer imageProducer = this.getDefaultImage().getSource();
        Intrinsics.checkNotNullExpressionValue((Object)imageProducer, (String)"getSource(...)");
        return imageProducer;
    }

    @Override
    public final Graphics getGraphics() {
        Graphics graphics = this.getDefaultImage().getGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"getGraphics(...)");
        return graphics;
    }

    private final BufferedImage getDefaultImage() {
        Lazy lazy = this.defaultImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    private final BufferedImage getScaledImage() {
        Lazy lazy = this.scaledImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    public final List<BufferedImage> getResolutionVariants() {
        Object[] objectArray = this.painter;
        if (this.painter instanceof BufferedImagePainter || objectArray instanceof BitmapPainter) {
            return CollectionsKt.listOf((Object)this.getDefaultImage());
        }
        Object[] objectArray2 = new BufferedImage[2];
        objectArray = objectArray2;
        objectArray2[0] = this.getDefaultImage();
        objectArray[1] = this.getScaledImage();
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final BufferedImage defaultImage_delegate$lambda$2(PainterImage this$0) {
        PainterImage painterImage;
        if (this$0.painter instanceof BufferedImagePainter) {
            return ((BufferedImagePainter)this$0.painter).getImage();
        }
        PainterImage painterImage2 = this$0;
        return DesktopImageConverters_desktopKt.toAwtImage(painterImage2.asBitmap(painterImage2.width, painterImage.height));
    }

    private static final BufferedImage scaledImage_delegate$lambda$3(PainterImage this$0) {
        PainterImage painterImage;
        PainterImage painterImage2 = this$0;
        return DesktopImageConverters_desktopKt.toAwtImage(painterImage2.asBitmap(MathKt.roundToInt((float)((float)painterImage2.width * this$0.density.getDensity())), MathKt.roundToInt((float)((float)this$0.height * painterImage.density.getDensity()))));
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size, DefaultConstructorMarker $constructor_marker) {
        this((Painter)var1_1, (Density)var2_2, (LayoutDirection)var3_3, size);
        void var3_3;
        void var2_2;
        void var1_1;
    }
}

