/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.collection.FloatFloatPair;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a7\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a%\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\b\u001a-\u0010\t\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a7\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a=\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a'\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"", "p0", "p1", "p2", "p3", "t", "evaluateCubic", "(FFFFF)F", "(FFF)F", "findFirstCubicRoot", "(FFFF)F", "", "roots", "", "index", "findQuadraticRoots", "(FFF[FI)I", "p0y", "p1y", "p2y", "p3y", "Landroidx/collection/FloatFloatPair;", "computeCubicVerticalBounds", "(FFFF[FI)J", "r", "writeValidRootInUnitRange", "(F[FI)I"})
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1001:1\n151#1:1002\n469#1:1003\n470#1:1014\n469#1:1015\n470#1:1026\n469#1:1027\n470#1:1038\n469#1:1039\n470#1:1050\n469#1:1051\n470#1:1062\n451#1:1063\n451#1:1064\n451#1:1065\n469#1:1066\n470#1:1077\n469#1:1078\n470#1:1089\n469#1:1090\n470#1:1101\n469#1:1112\n470#1:1123\n469#1:1124\n470#1:1135\n469#1:1136\n470#1:1147\n469#1:1148\n470#1:1159\n469#1:1160\n470#1:1171\n469#1:1172\n470#1:1183\n270#1:1184\n270#1:1185\n975#1:1186\n975#1:1187\n989#1:1188\n989#1:1189\n270#1:1190\n469#1:1201\n470#1:1212\n453#1:1213\n453#1:1216\n65#2,10:1004\n65#2,10:1016\n65#2,10:1028\n65#2,10:1040\n65#2,10:1052\n65#2,10:1067\n65#2,10:1079\n65#2,10:1091\n83#2,10:1102\n65#2,10:1113\n65#2,10:1125\n65#2,10:1137\n65#2,10:1149\n65#2,10:1161\n65#2,10:1173\n65#2,10:1191\n65#2,10:1202\n46#2:1214\n56#2:1215\n65#2,10:1217\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n131#1:1002\n131#1:1003\n131#1:1014\n151#1:1015\n151#1:1026\n171#1:1027\n171#1:1038\n174#1:1039\n174#1:1050\n176#1:1051\n176#1:1062\n205#1:1063\n207#1:1064\n209#1:1065\n212#1:1066\n212#1:1077\n217#1:1078\n217#1:1089\n220#1:1090\n220#1:1101\n241#1:1112\n241#1:1123\n244#1:1124\n244#1:1135\n247#1:1136\n247#1:1147\n251#1:1148\n251#1:1159\n254#1:1160\n254#1:1171\n261#1:1172\n261#1:1183\n344#1:1184\n359#1:1185\n378#1:1186\n379#1:1187\n403#1:1188\n404#1:1189\n436#1:1190\n480#1:1201\n480#1:1212\n615#1:1213\n796#1:1216\n131#1:1004,10\n151#1:1016,10\n171#1:1028,10\n174#1:1040,10\n176#1:1052,10\n212#1:1067,10\n217#1:1079,10\n220#1:1091,10\n237#1:1102,10\n241#1:1113,10\n244#1:1125,10\n247#1:1137,10\n251#1:1149,10\n254#1:1161,10\n261#1:1173,10\n469#1:1191,10\n480#1:1202,10\n780#1:1214\n783#1:1215\n836#1:1217,10\n*E\n"})
public final class BezierKt {
    /*
     * WARNING - void declaration
     */
    private static final float evaluateCubic(float p0, float p1, float p2, float p3, float t) {
        float f;
        void var1_1;
        void var2_2;
        void var3_3;
        float a = p3 + 3.0f * (p1 - p2) - p0;
        float b = 3.0f * (p2 - p1 * 2.0f + p0);
        float c = 3.0f * (p1 - p0);
        return (float)(((var3_3 * t + var2_2) * t + var1_1) * t + f);
    }

    /*
     * WARNING - void declaration
     */
    public static final float evaluateCubic(float p1, float p2, float t) {
        void var2_2;
        float f;
        void var1_1;
        void var3_3;
        float a = 0.33333334f + (p1 - p2);
        float b = p2 - p1 * 2.0f;
        return 3.0f * ((var3_3 * t + var1_1) * t + f) * var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final float findFirstCubicRoot(float p0, float p1, float p2, float p3) {
        float f;
        float s$iv;
        float f2;
        float r$iv;
        double d;
        void var3_3;
        double d2;
        double a = 3.0 * ((double)p0 - 2.0 * (double)p1 + (double)p2);
        double b = 3.0 * (double)(p1 - p0);
        double c = p0;
        double d3 = d2 = (double)(-p0) + 3.0 * (double)(p1 - p2) + (double)var3_3;
        if (Math.abs(d) < 1.0E-7) {
            float f3;
            float f4;
            float r$iv2;
            double d4;
            d3 = a;
            if (Math.abs(d4) < 1.0E-7) {
                float s$iv2;
                float f5;
                float r$iv3;
                double d5;
                d3 = b;
                if (Math.abs(d5) < 1.0E-7) {
                    return Float.NaN;
                }
                float f6 = r$iv3 = (float)(-c / b);
                float $this$fastCoerceAtLeast$iv$iv$iv = r$iv3;
                float $this$fastCoerceAtMost$iv$iv$iv = f5 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
                float f7 = s$iv2 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
                if (Math.abs(f7 - r$iv3) > 1.05E-6f) {
                    return Float.NaN;
                }
                return s$iv2;
            }
            double d6 = b;
            double q = Math.sqrt(d6 * d6 - a * 4.0 * c);
            double a2 = a * 2.0;
            float f8 = r$iv2 = (float)((q - b) / a2);
            float $this$fastCoerceAtLeast$iv$iv$iv = r$iv2;
            float $this$fastCoerceAtMost$iv$iv$iv = f4 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float s$iv3 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            float root = Math.abs(s$iv3 - r$iv2) > 1.05E-6f ? Float.NaN : s$iv3;
            if (!Float.isNaN(root)) {
                return root;
            }
            f8 = r$iv2 = (float)((-b - q) / a2);
            $this$fastCoerceAtLeast$iv$iv$iv = r$iv2;
            $this$fastCoerceAtMost$iv$iv$iv = f3 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float f9 = s$iv3 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            if (Math.abs(f9 - r$iv2) > 1.05E-6f) {
                return Float.NaN;
            }
            return s$iv3;
        }
        double d7 = a /= d2;
        double o3 = ((b /= d2) * 3.0 - d7 * d7) / 9.0;
        double q2 = (a * 2.0 * a * a - a * 9.0 * b + (c /= d2) * 27.0) / 54.0;
        double d8 = o3;
        double discriminant = q2 * q2 + d8 * d8 * o3;
        double a3 = a / 3.0;
        if (discriminant < 0.0) {
            void var2_2;
            float f10;
            float f11;
            float f12;
            float r$iv4;
            double d9;
            double d10;
            double d11 = o3;
            double d12 = -(d11 * d11 * o3);
            double r = Math.sqrt(d12);
            double d13 = d10 = -q2 / r;
            double $this$fastCoerceAtLeast$iv$iv = d10;
            double $this$fastCoerceAtMost$iv$iv = d9 < -1.0 ? -1.0 : $this$fastCoerceAtLeast$iv$iv;
            double d14 = $this$fastCoerceAtMost$iv$iv > 1.0 ? 1.0 : $this$fastCoerceAtMost$iv$iv;
            double phi = Math.acos(d14);
            float t1 = 2.0f * MathHelpersKt.fastCbrt((float)((float)r));
            p2 = r$iv4 = (float)((double)t1 * Math.cos(phi / 3.0) - a3);
            float $this$fastCoerceAtLeast$iv$iv$iv = r$iv4;
            float $this$fastCoerceAtMost$iv$iv$iv = f12 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float s$iv4 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            float root = Math.abs(s$iv4 - r$iv4) > 1.05E-6f ? Float.NaN : s$iv4;
            if (!Float.isNaN(root)) {
                return root;
            }
            s$iv4 = r$iv4 = (float)((double)t1 * Math.cos((phi + Math.PI * 2) / 3.0) - a3);
            $this$fastCoerceAtLeast$iv$iv$iv = r$iv4;
            $this$fastCoerceAtMost$iv$iv$iv = f11 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            s$iv4 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            r$iv4 = Math.abs(s$iv4 - r$iv4) > 1.05E-6f ? Float.NaN : s$iv4;
            if (!Float.isNaN(r$iv4)) {
                return r$iv4;
            }
            s$iv4 = r$iv4 = (float)((double)t1 * Math.cos((phi + Math.PI * 4) / 3.0) - a3);
            $this$fastCoerceAtLeast$iv$iv$iv = r$iv4;
            $this$fastCoerceAtMost$iv$iv$iv = f10 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float f13 = s$iv4 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            if (Math.abs(f13 - r$iv4) > 1.05E-6f) {
                return Float.NaN;
            }
            return (float)var2_2;
        }
        if (discriminant == 0.0) {
            void var1_1;
            float f14;
            float f15;
            float r$iv5;
            float u1 = -MathHelpersKt.fastCbrt((float)((float)q2));
            float f16 = r$iv5 = u1 * 2.0f - (float)a3;
            float $this$fastCoerceAtLeast$iv$iv$iv = r$iv5;
            float $this$fastCoerceAtMost$iv$iv$iv = f15 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float s$iv5 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            float root = Math.abs(s$iv5 - r$iv5) > 1.05E-6f ? Float.NaN : s$iv5;
            if (!Float.isNaN(root)) {
                return root;
            }
            f16 = r$iv5 = -u1 - (float)a3;
            $this$fastCoerceAtLeast$iv$iv$iv = r$iv5;
            $this$fastCoerceAtMost$iv$iv$iv = f14 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
            float f17 = s$iv5 = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
            if (Math.abs(f17 - r$iv5) > 1.05E-6f) {
                return Float.NaN;
            }
            return (float)var1_1;
        }
        double sd = Math.sqrt(discriminant);
        float u1 = MathHelpersKt.fastCbrt((float)((float)(-q2 + sd)));
        float v1 = MathHelpersKt.fastCbrt((float)((float)(q2 + sd)));
        float f18 = r$iv = (float)((double)(u1 - v1) - a3);
        float $this$fastCoerceAtLeast$iv$iv$iv = r$iv;
        float $this$fastCoerceAtMost$iv$iv$iv = f2 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
        float f19 = s$iv = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
        if (Math.abs(f19 - r$iv) > 1.05E-6f) {
            return Float.NaN;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static final int findQuadraticRoots(float p0, float p1, float p2, float[] roots, int index) {
        void var0_1;
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - b * 2.0 + c;
        int rootCount = 0;
        if (!(d == 0.0)) {
            double d2 = b;
            double v1 = -Math.sqrt(d2 * d2 - a * c);
            double v2 = -a + b;
            rootCount = 0 + BezierKt.writeValidRootInUnitRange((float)(-(v1 + v2) / d), roots, index);
            if ((rootCount += BezierKt.writeValidRootInUnitRange((float)((v1 - v2) / d), roots, index + rootCount)) > 1) {
                void var2_3;
                void var1_2;
                float s = roots[index];
                float t = roots[index + 1];
                if (s > t) {
                    roots[index] = t;
                    roots[index + 1] = s;
                } else if (var1_2 == var2_3) {
                    --rootCount;
                }
            }
        } else if (!(b == c)) {
            void var3_4;
            rootCount = 0 + BezierKt.writeValidRootInUnitRange((float)((b * 2.0 - c) / (b * 2.0 - c * 2.0)), (float[])var3_4, index);
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, float[] roots, int index) {
        void roots$iv;
        void p1$iv;
        void p0$iv;
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - p0y);
        float d1 = 3.0f * (p2y - p1y);
        float d32 = 3.0f * (p3y - p2y);
        int count = BezierKt.findQuadraticRoots(d0, d1, d32, roots, index);
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d32 - d1);
        float[] d32 = roots;
        int index$iv = index + count;
        float minY = Math.min(p0y, p3y);
        float maxY = Math.max(p0y, p3y);
        int n = count += BezierKt.access$writeValidRootInUnitRange((float)(-p0$iv / (p1$iv - p0$iv)), (float[])roots$iv, index$iv);
        for (int i = 0; i < n; ++i) {
            float t = roots[i];
            float y = BezierKt.evaluateCubic(p0y, p1y, p2y, p3y, t);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return FloatFloatPair.constructor-impl((float)minY, (float)maxY);
    }

    private static final int writeValidRootInUnitRange(float r, float[] roots, int index) {
        float f;
        float v;
        float f2;
        float r$iv;
        float f3 = r$iv = r;
        float $this$fastCoerceAtLeast$iv$iv$iv = r$iv;
        float $this$fastCoerceAtMost$iv$iv$iv = f2 < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv$iv;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv$iv;
        var1_1[var2_2] = v = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : f3;
        if (Float.isNaN(f)) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$writeValidRootInUnitRange(float r, float[] roots, int index) {
        void var2_2;
        void var1_1;
        return BezierKt.writeValidRootInUnitRange(r, (float[])var1_1, (int)var2_2);
    }
}

