/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameType;
import io.ktor.websocket.UtilsKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010\"\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0018\u0010$\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u001cR\u0011\u0010,\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0011\u0010/\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b-\u0010."}, d2={"Lio/ktor/websocket/Serializer;", "", "<init>", "()V", "Lio/ktor/websocket/Frame;", "f", "", "enqueue", "(Lio/ktor/websocket/Frame;)V", "Ljava/nio/ByteBuffer;", "buffer", "serialize", "(Ljava/nio/ByteBuffer;)V", "frame", "", "mask", "serializeHeader", "(Lio/ktor/websocket/Frame;Ljava/nio/ByteBuffer;Z)V", "", "estimateFrameHeaderSize", "(Lio/ktor/websocket/Frame;Z)I", "writeCurrentPayload", "(Ljava/nio/ByteBuffer;)Z", "maskSize", "(Z)I", "maskedIfNeeded", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "setMaskBuffer", "(Z)V", "Ljava/util/concurrent/ArrayBlockingQueue;", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "frameBody", "Ljava/nio/ByteBuffer;", "maskBuffer", "Lio/ktor/websocket/FrameType;", "lastDataFrameType", "Lio/ktor/websocket/FrameType;", "masking", "Z", "getMasking", "()Z", "setMasking", "getHasOutstandingBytes", "hasOutstandingBytes", "getRemainingCapacity", "()I", "remainingCapacity"})
@SourceDebugExtension(value={"SMAP\nSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Serializer.kt\nio/ktor/websocket/Serializer\n+ 2 Utils.kt\nio/ktor/websocket/UtilsKt__UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n14#2:128\n14#2:129\n14#2:130\n14#2:131\n14#2:132\n1#3:133\n*S KotlinDebug\n*F\n+ 1 Serializer.kt\nio/ktor/websocket/Serializer\n*L\n75#1:128\n76#1:129\n77#1:130\n78#1:131\n82#1:132\n*E\n"})
public final class Serializer {
    private final ArrayBlockingQueue<Frame> messages = new ArrayBlockingQueue(1024);
    private ByteBuffer frameBody;
    private ByteBuffer maskBuffer;
    private FrameType lastDataFrameType;
    private boolean masking;

    public final boolean getMasking() {
        return this.masking;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMasking(boolean bl) {
        void var1_1;
        this.masking = var1_1;
    }

    public final boolean getHasOutstandingBytes() {
        return !((Collection)this.messages).isEmpty() || this.frameBody != null;
    }

    public final int getRemainingCapacity() {
        return this.messages.remainingCapacity();
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueue(Frame f) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.messages.put((Frame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (this.writeCurrentPayload(buffer)) {
            void var2_2;
            void var3_3;
            Frame frame;
            if (this.messages.peek() == null) {
                return;
            }
            boolean mask = this.masking;
            this.setMaskBuffer(mask);
            int headerSize = this.estimateFrameHeaderSize(frame, mask);
            if (buffer.remaining() < headerSize) break;
            this.serializeHeader(frame, buffer, (boolean)var3_3);
            this.messages.remove();
            this.frameBody = this.maskedIfNeeded(var2_2.getBuffer());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void serializeHeader(Frame frame, ByteBuffer buffer, boolean mask) {
        ByteBuffer byteBuffer;
        void var3_3;
        int n;
        int size = frame.getBuffer().remaining();
        int formattedLength = size < 126 ? size : (size <= 65535 ? 126 : 127);
        FrameType frameType = this.lastDataFrameType;
        if (frameType == null) {
            if (!frame.getFin()) {
                this.lastDataFrameType = frame.getFrameType();
            }
            n = frame.getFrameType().getOpcode();
        } else if (frameType == frame.getFrameType()) {
            if (frame.getFin()) {
                this.lastDataFrameType = null;
            }
            n = 0;
        } else {
            if (!frame.getFrameType().getControlFrame()) {
                throw new IllegalStateException("Can't continue with different data frame opcode");
            }
            n = frame.getFrameType().getOpcode();
        }
        int continuationOpcode = n;
        boolean bl = frame.getFin();
        int n2 = bl ? 128 : 0;
        bl = frame.getRsv1();
        int n3 = n2 | (bl ? 64 : 0);
        bl = frame.getRsv2();
        int n4 = n3 | (bl ? 32 : 0);
        bl = frame.getRsv3();
        int header = n4 | (bl ? 16 : 0) | continuationOpcode;
        buffer.put((byte)header);
        bl = var3_3;
        buffer.put((byte)((bl ? 128 : 0) | formattedLength));
        switch (formattedLength) {
            case 126: {
                buffer.putShort((short)frame.getBuffer().remaining());
                break;
            }
            case 127: {
                void var1_1;
                buffer.putLong(var1_1.getBuffer().remaining());
            }
        }
        if ((byteBuffer = this.maskBuffer) != null && (byteBuffer = byteBuffer.duplicate()) != null) {
            void var2_2;
            NIOKt.moveTo$default((ByteBuffer)byteBuffer, (ByteBuffer)var2_2, (int)0, (int)2, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int estimateFrameHeaderSize(Frame f, boolean mask) {
        void var2_3;
        void var1_2;
        int size = f.getBuffer().remaining();
        return (size < 126 ? 2 : (var1_2 <= Short.MAX_VALUE ? 4 : 10)) + this.maskSize((boolean)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean writeCurrentPayload(ByteBuffer buffer) {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer = this.frameBody;
        if (byteBuffer == null) {
            return true;
        }
        ByteBuffer frame = byteBuffer;
        NIOKt.moveTo$default((ByteBuffer)byteBuffer, (ByteBuffer)var1_1, (int)0, (int)2, null);
        if (!var2_2.hasRemaining()) {
            this.frameBody = null;
            return true;
        }
        return false;
    }

    private final int maskSize(boolean mask) {
        if (mask) {
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final ByteBuffer maskedIfNeeded(ByteBuffer $this$maskedIfNeeded) {
        ByteBuffer byteBuffer;
        block3: {
            void var1_1;
            block2: {
                void var2_2;
                ByteBuffer byteBuffer2;
                byteBuffer = this.maskBuffer;
                if (byteBuffer == null) break block2;
                ByteBuffer mask = byteBuffer;
                ByteBuffer byteBuffer3 = byteBuffer2 = NIOKt.copy$default((ByteBuffer)$this$maskedIfNeeded, (int)0, (int)1, null);
                UtilsKt.xor(byteBuffer2, (ByteBuffer)var2_2);
                byteBuffer = byteBuffer2;
                if (byteBuffer != null) break block3;
            }
            byteBuffer = var1_1;
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaskBuffer(boolean mask) {
        ByteBuffer byteBuffer;
        void var1_1;
        Serializer serializer = this;
        if (var1_1 != false) {
            void var2_3;
            ByteBuffer byteBuffer2;
            ByteBuffer $this$setMaskBuffer_u24lambda_u242 = byteBuffer2 = ByteBuffer.allocate(4);
            Serializer serializer2 = serializer;
            $this$setMaskBuffer_u24lambda_u242.putInt(Random.Default.nextInt());
            var2_3.clear();
            serializer = serializer2;
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer = null;
        }
        serializer.maskBuffer = byteBuffer;
    }
}

