/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.Frame;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lio/ktor/websocket/Frame$Text;", "", "readText", "(Lio/ktor/websocket/Frame$Text;)Ljava/lang/String;", "Lio/ktor/websocket/Frame;", "", "readBytes", "(Lio/ktor/websocket/Frame;)[B", "Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/CloseReason;", "readReason", "(Lio/ktor/websocket/Frame$Close;)Lio/ktor/websocket/CloseReason;"})
@SourceDebugExtension(value={"SMAP\nFrameCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,202:1\n1#2:203\n21#3,3:204\n21#3,3:207\n*S KotlinDebug\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n*L\n169#1:204,3\n191#1:207,3\n*E\n"})
public final class FrameCommonKt {
    /*
     * WARNING - void declaration
     */
    public static final String readText(Frame.Text $this$readText) {
        void var1_2;
        Frame.Text text;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        if (!$this$readText.getFin()) {
            String string = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException(string.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"newDecoder(...)");
        Buffer builder$iv = new Buffer();
        Sink $this$readText_u24lambda_u241 = (Sink)builder$iv;
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        BytePacketBuilderKt.writeFully$default((Sink)var2_3, (byte[])text.getData(), (int)0, (int)0, (int)6, null);
        return EncodingKt.decode$default((CharsetDecoder)charsetDecoder2, (Source)((Source)var1_2), (int)0, (int)2, null);
    }

    public static final byte[] readBytes(Frame $this$readBytes) {
        Frame frame;
        Intrinsics.checkNotNullParameter((Object)$this$readBytes, (String)"<this>");
        byte[] byArray = frame.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static final CloseReason readReason(Frame.Close $this$readReason) {
        void var2_1;
        void var1_3;
        Frame.Close close2;
        Intrinsics.checkNotNullParameter((Object)$this$readReason, (String)"<this>");
        if ($this$readReason.getData().length < 2) {
            return null;
        }
        Buffer builder$iv = new Buffer();
        Sink sink = (Sink)builder$iv;
        BytePacketBuilderKt.writeFully$default((Sink)sink, (byte[])$this$readReason.getData(), (int)0, (int)0, (int)6, null);
        Frame.Close packet = (Source)builder$iv;
        short code = packet.readShort();
        String message = StringsKt.readText$default((Source)close2, null, (int)0, (int)3, null);
        return new CloseReason((short)var1_3, (String)var2_1);
    }
}

