/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.platform;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.W32APIOptions;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.him188.ani.app.platform.DesktopSystemProxyDetector;
import me.him188.ani.app.platform.SystemProxyInfo;
import me.him188.ani.utils.logging.LoggerKt;
import me.him188.ani.utils.logging.LoggerKt_jvmKt;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0018\u0010\u0011\u001a\u00060\u000fj\u0002`\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lme/him188/ani/app/platform/WindowsSystemProxyDetector;", "Lme/him188/ani/app/platform/DesktopSystemProxyDetector;", "<init>", "()V", "Lme/him188/ani/app/platform/SystemProxyInfo;", "detect", "()Lme/him188/ani/app/platform/SystemProxyInfo;", "Lcom/sun/jna/Pointer;", "ptr", "", "pointerToString", "(Lcom/sun/jna/Pointer;)Ljava/lang/String;", "Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;", "getWindowsProxySettings", "()Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;", "Lorg/slf4j/Logger;", "Lme/him188/ani/utils/logging/Logger;", "logger", "Lorg/slf4j/Logger;", "Lkotlin/Result;", "Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WinHttp;", "winHttp", "Ljava/lang/Object;", "WINHTTP_CURRENT_USER_IE_PROXY_CONFIG", "WinHttp"})
@SourceDebugExtension(value={"SMAP\nDesktopSystemProxyDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopSystemProxyDetector.kt\nme/him188/ani/app/platform/WindowsSystemProxyDetector\n+ 2 LoggerKt.jvm.kt\nme/him188/ani/utils/logging/LoggerKt_jvmKt\n+ 3 LoggerKt.kt\nme/him188/ani/utils/logging/LoggerKt\n*L\n1#1,93:1\n41#2:94\n86#3,4:95\n*S KotlinDebug\n*F\n+ 1 DesktopSystemProxyDetector.kt\nme/him188/ani/app/platform/WindowsSystemProxyDetector\n*L\n24#1:94\n49#1:95,4\n*E\n"})
public final class WindowsSystemProxyDetector
extends DesktopSystemProxyDetector {
    private final Logger logger;
    private final Object winHttp;
    public static final int $stable = 8;

    public WindowsSystemProxyDetector() {
        super(null);
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        Intrinsics.checkNotNullExpressionValue((Object)iLoggerFactory, (String)"getILoggerFactory(...)");
        this.logger = LoggerKt_jvmKt.getLogger((ILoggerFactory)iLoggerFactory, WindowsSystemProxyDetector.class);
        Object object = this;
        WindowsSystemProxyDetector windowsSystemProxyDetector = object;
        try {
            Library library = Native.load((String)"winhttp", WinHttp.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type me.him188.ani.app.platform.WindowsSystemProxyDetector.WinHttp");
            object = Result.constructor-impl((Object)((WinHttp)library));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        windowsSystemProxyDetector.winHttp = object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SystemProxyInfo detect() {
        void var2_2;
        WINHTTP_CURRENT_USER_IE_PROXY_CONFIG wINHTTP_CURRENT_USER_IE_PROXY_CONFIG = this.getWindowsProxySettings();
        if (wINHTTP_CURRENT_USER_IE_PROXY_CONFIG == null) {
            return null;
        }
        WINHTTP_CURRENT_USER_IE_PROXY_CONFIG proxyConfig = wINHTTP_CURRENT_USER_IE_PROXY_CONFIG;
        String string2 = this.pointerToString(proxyConfig.lpszProxy);
        if (string2 == null) {
            return null;
        }
        String urlString = string2;
        if (StringsKt.startsWith$default((String)string2, (String)"http=", (boolean)false, (int)2, null)) {
            urlString = StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)urlString, (CharSequence)"http="), (String)";", null, (int)2, null);
        }
        Url url = StringsKt.contains$default((CharSequence)urlString, (CharSequence)"://", (boolean)false, (int)2, null) ? URLUtilsKt.Url((String)urlString) : URLUtilsKt.Url((String)("http://" + urlString));
        Logger $this$info$iv = this.logger;
        if ($this$info$iv.isInfoEnabled()) {
            void var1_1;
            void var3_3;
            LoggerKt.info((Logger)var3_3, (String)("Detected system proxy: " + var1_1));
        }
        return new SystemProxyInfo((Url)var2_2);
    }

    private final String pointerToString(Pointer ptr) {
        Pointer pointer = ptr;
        if (pointer != null) {
            return pointer.getWideString(0L);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final WINHTTP_CURRENT_USER_IE_PROXY_CONFIG getWindowsProxySettings() {
        WINHTTP_CURRENT_USER_IE_PROXY_CONFIG proxyConfig = new WINHTTP_CURRENT_USER_IE_PROXY_CONFIG();
        Object object = this.winHttp;
        ResultKt.throwOnFailure((Object)object);
        boolean bl = ((WinHttp)object).WinHttpGetIEProxyConfigForCurrentUser(proxyConfig);
        if (bl) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\r"}, d2={"Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;", "Lcom/sun/jna/Structure;", "<init>", "()V", "", "", "getFieldOrder", "()Ljava/util/List;", "", "fAutoDetect", "Z", "Lcom/sun/jna/Pointer;", "lpszAutoConfigUrl", "Lcom/sun/jna/Pointer;", "lpszProxy", "lpszProxyBypass"})
    public static final class WINHTTP_CURRENT_USER_IE_PROXY_CONFIG
    extends Structure {
        @JvmField
        public boolean fAutoDetect;
        @JvmField
        public Pointer lpszAutoConfigUrl;
        @JvmField
        public Pointer lpszProxy;
        @JvmField
        public Pointer lpszProxyBypass;
        public static final int $stable = 8;

        protected final List<String> getFieldOrder() {
            Object[] objectArray = new String[4];
            Object[] objectArray2 = objectArray;
            objectArray[0] = "fAutoDetect";
            objectArray2[1] = "lpszAutoConfigUrl";
            objectArray2[2] = "lpszProxy";
            objectArray2[3] = "lpszProxyBypass";
            return CollectionsKt.listOf((Object[])objectArray2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00c0\u0006\u0003"}, d2={"Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WinHttp;", "Lcom/sun/jna/Library;", "Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;", "pProxyConfig", "", "WinHttpGetIEProxyConfigForCurrentUser", "(Lme/him188/ani/app/platform/WindowsSystemProxyDetector$WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;)Z"})
    public static interface WinHttp
    extends Library {
        public boolean WinHttpGetIEProxyConfigForCurrentUser(WINHTTP_CURRENT_USER_IE_PROXY_CONFIG var1);
    }
}

