/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.jfa.foundation;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import de.jangassen.jfa.foundation.FoundationLibrary;
import de.jangassen.jfa.foundation.ID;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    private static final Function myObjcMsgSend;
    private static final Map<String, Object> ourMainThreadRunnables;
    private static final Object RUNNABLE_LOCK;
    private static long ourCurrentRunnableCount;

    public static ID getObjcClass(String className) {
        String string;
        return myFoundationLibrary.objc_getClass(string);
    }

    public static Pointer createSelector(String s) {
        String string;
        return myFoundationLibrary.sel_registerName(string);
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] prepInvoke(ID id, Pointer selector, Object[] args) {
        void var3_3;
        void var2_2;
        void var1_1;
        ID iD;
        Object[] objectArray = new Object[args.length + 2];
        Object[] invokArgs = objectArray;
        objectArray[0] = iD;
        invokArgs[1] = var1_1;
        System.arraycopy(args, 0, invokArgs, 2, ((void)var2_2).length);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static ID invoke(ID id, Pointer selector, Object ... args) {
        void var2_2;
        void var1_1;
        ID iD;
        return new ID(myObjcMsgSend.invokeLong(Foundation.prepInvoke(iD, (Pointer)var1_1, (Object[])var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public static ID invoke(String cls, String selector, Object ... args) {
        void var2_2;
        void var1_1;
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector((String)var1_1), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ID invoke(ID id, String selector, Object ... args) {
        void var2_2;
        void var1_1;
        return Foundation.invoke(id, Foundation.createSelector((String)var1_1), (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ID allocateObjcClassPair(ID superCls, String name) {
        void var1_1;
        ID iD;
        return myFoundationLibrary.objc_allocateClassPair(iD, (String)var1_1, 0);
    }

    public static void registerObjcClassPair(ID cls) {
        ID iD;
        myFoundationLibrary.objc_registerClassPair(iD);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean addMethod(ID cls, Pointer selectorName, Callback impl, String types) {
        void var3_3;
        void var2_2;
        void var1_1;
        ID iD;
        return myFoundationLibrary.class_addMethod(iD, (Pointer)var1_1, (Callback)var2_2, (String)var3_3);
    }

    public static ID nsString(String s) {
        String string;
        if (s == null) {
            return ID.NIL;
        }
        return NSString.create(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStringViaUTF8(ID cfString) {
        void var1_3;
        ID iD;
        if (ID.NIL.equals((Object)cfString)) {
            return null;
        }
        int lengthInChars = myFoundationLibrary.CFStringGetLength(cfString);
        byte[] buffer = new byte[lengthInChars = 3 * lengthInChars + 1];
        byte by = myFoundationLibrary.CFStringGetCString(iD, buffer, buffer.length, 0x8000100);
        if (by == 0) {
            throw new RuntimeException("Could not convert string");
        }
        return Native.toString((byte[])var1_3);
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        long l;
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(l) & 0xFFFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void var0;
        ourMainThreadRunnables = new HashMap<String, Object>();
        RUNNABLE_LOCK = new Object();
        ourCurrentRunnableCount = 0L;
        FoundationLibrary foundationLibrary = null;
        Function objcMsgSend = null;
        try {
            foundationLibrary = (FoundationLibrary)Native.load((String)"Foundation", FoundationLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
            NativeLibrary nativeLibrary = ((Library.Handler)Proxy.getInvocationHandler(foundationLibrary)).getNativeLibrary();
            objcMsgSend = nativeLibrary.getFunction("objc_msgSend");
        }
        catch (RuntimeException runtimeException) {}
        myFoundationLibrary = var0;
        myObjcMsgSend = var1_1;
    }

    private static final class NSString {
        private static final ID nsStringCls = Foundation.getObjcClass("NSString");
        private static final Pointer stringSel = Foundation.createSelector("string");
        private static final Pointer allocSel = Foundation.createSelector("alloc");
        private static final Pointer autoreleaseSel = Foundation.createSelector("autorelease");
        private static final Pointer initWithBytesLengthEncodingSel = Foundation.createSelector("initWithBytes:length:encoding:");
        private static final long nsEncodingUTF16LE = Foundation.convertCFEncodingToNS(0x14000100L);

        public static ID create(String s) {
            Object object;
            if (s.isEmpty()) {
                return Foundation.invoke(nsStringCls, stringSel, new Object[0]);
            }
            Object utf16Bytes = s.getBytes(StandardCharsets.UTF_16LE);
            return Foundation.invoke(Foundation.invoke(Foundation.invoke(nsStringCls, allocSel, new Object[0]), initWithBytesLengthEncodingSel, utf16Bytes, ((Object)object).length, nsEncodingUTF16LE), autoreleaseSel, new Object[0]);
        }
    }

    public static class CGFloat
    implements NativeMapped {
        private final double value;

        public CGFloat() {
            this(0.0);
        }

        /*
         * WARNING - void declaration
         */
        public CGFloat(double d) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Object fromNative(Object o, FromNativeContext fromNativeContext) {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return new CGFloat(((Float)o).floatValue());
                }
                case 8: {
                    void var1_1;
                    return new CGFloat((Double)var1_1);
                }
            }
            throw new IllegalStateException();
        }

        public Object toNative() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.valueOf((float)this.value);
                }
                case 8: {
                    return this.value;
                }
            }
            throw new IllegalStateException();
        }

        public Class<?> nativeType() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.class;
                }
                case 8: {
                    return Double.class;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class NSAutoreleasePool {
        private final ID myDelegate = Foundation.invoke(Foundation.invoke("NSAutoreleasePool", "alloc", new Object[0]), "init", new Object[0]);

        public void drain() {
            Foundation.invoke(this.myDelegate, "drain", new Object[0]);
        }
    }
}

