/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.paragraph.Paragraph;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0006\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\"\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001aR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\"R$\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#8\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R$\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020#8\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b)\u0010&\u001a\u0004\b*\u0010("}, d2={"Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "", "text", "Landroidx/compose/ui/text/TextStyle;", "style", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "annotations", "Landroidx/compose/ui/text/Placeholder;", "placeholders", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "fontFamilyResolver", "<init>", "(Ljava/lang/String;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "layouter", "()Landroidx/compose/ui/text/platform/ParagraphLayouter;", "newLayouter", "Ljava/lang/String;", "getText", "()Ljava/lang/String;", "Landroidx/compose/ui/text/TextStyle;", "Ljava/util/List;", "Landroidx/compose/ui/unit/Density;", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "textDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getTextDirection", "()Landroidx/compose/ui/text/style/ResolvedTextDirection;", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "", "value", "minIntrinsicWidth", "F", "getMinIntrinsicWidth", "()F", "maxIntrinsicWidth", "getMaxIntrinsicWidth"})
public final class SkiaParagraphIntrinsics
implements ParagraphIntrinsics {
    private final String text;
    private final TextStyle style;
    private final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Density density;
    private final FontFamily.Resolver fontFamilyResolver;
    private final ResolvedTextDirection textDirection;
    private ParagraphLayouter layouter;
    private float minIntrinsicWidth;
    private float maxIntrinsicWidth;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SkiaParagraphIntrinsics(String text, TextStyle style, List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text;
        this.style = var2_2;
        this.annotations = var3_3;
        this.placeholders = placeholders;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.textDirection = SkiaParagraphIntrinsics_skikoKt.resolveTextDirection-Ikz0yAw(this.text, TextDirection.box-impl(this.style.getTextDirection-s_7X-co()), this.style.getLocaleList());
        ParagraphLayouter paragraphLayouter = this.layouter = this.newLayouter();
        Intrinsics.checkNotNull((Object)paragraphLayouter);
        Paragraph para = paragraphLayouter.layoutParagraph(Float.POSITIVE_INFINITY);
        this.minIntrinsicWidth = (float)Math.ceil(para.getMinIntrinsicWidth());
        this.maxIntrinsicWidth = (float)Math.ceil(var1_1.getMaxIntrinsicWidth());
    }

    public final String getText() {
        return this.text;
    }

    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    /*
     * WARNING - void declaration
     */
    public final ParagraphLayouter layouter() {
        void var1_1;
        ParagraphLayouter paragraphLayouter = this.layouter;
        if (paragraphLayouter == null) {
            paragraphLayouter = this.newLayouter();
        }
        ParagraphLayouter layouter = paragraphLayouter;
        this.layouter = null;
        return var1_1;
    }

    private final ParagraphLayouter newLayouter() {
        return new ParagraphLayouter(this.text, this.textDirection, this.style, this.annotations, this.placeholders, this.density, this.fontFamilyResolver);
    }

    @Override
    public final float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }
}

