/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.Platform;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.ResourceFont;
import androidx.compose.ui.text.platform.SystemFont;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.Typeface;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u000f\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\"\u0018\u0010\u000f\u001a\u00020\f*\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e"}, d2={"Landroidx/compose/ui/text/font/Font;", "font", "Lorg/jetbrains/skia/Typeface;", "loadTypeface", "(Landroidx/compose/ui/text/font/Font;)Lorg/jetbrains/skia/Typeface;", "", "resourceName", "typefaceResource", "(Ljava/lang/String;)Lorg/jetbrains/skia/Typeface;", "Landroidx/compose/ui/text/platform/Platform;", "currentPlatform", "()Landroidx/compose/ui/text/platform/Platform;", "Lorg/jetbrains/skia/FontStyle;", "getSkFontStyle", "(Landroidx/compose/ui/text/font/Font;)Lorg/jetbrains/skia/FontStyle;", "skFontStyle"})
@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public final class DesktopFont_desktopKt {
    public static final Typeface loadTypeface(Font font) {
        Font font2;
        Typeface typeface2;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        PlatformFont platformFont = (PlatformFont)font;
        if (platformFont instanceof ResourceFont) {
            typeface2 = DesktopFont_desktopKt.typefaceResource(((ResourceFont)font).getName());
        } else if (platformFont instanceof FileFont) {
            FontMgr fontMgr = FontMgr.Companion.getDefault();
            String string = ((FileFont)font).getFile().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            typeface2 = FontMgr.makeFromFile$default((FontMgr)fontMgr, (String)string, (int)0, (int)2, null);
        } else if (platformFont instanceof LoadedFont) {
            typeface2 = FontMgr.makeFromData$default((FontMgr)FontMgr.Companion.getDefault(), (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((byte[])((LoadedFont)font).getGetData$ui_text().invoke()), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        } else if (platformFont instanceof SystemFont) {
            typeface2 = FontMgr.Companion.getDefault().matchFamilyStyle(((PlatformFont)((SystemFont)font)).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface3 = typeface2;
        if (typeface2 == null && (typeface3 = FontMgr.Companion.getDefault().legacyMakeTypeface(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font))) == null) {
            throw new IllegalStateException("loadTypeface legacyMakeTypeface failed".toString());
        }
        platformFont = typeface3;
        return PlatformFont_skikoKt.cloneWithVariationSettings(typeface3, ((PlatformFont)font2).getVariationSettings());
    }

    private static final Typeface typefaceResource(String resourceName) {
        Object object;
        Object object2;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        Object object3 = classLoader;
        InputStream inputStream = classLoader.getResourceAsStream((String)resourceName);
        if (inputStream == null && (inputStream = ((Object)((Object)typefaceResource.resource.1.INSTANCE)).getClass().getResourceAsStream((String)resourceName)) == null) {
            throw new IllegalStateException(("Can't load font from " + (String)resourceName).toString());
        }
        resourceName = inputStream;
        resourceName = inputStream;
        object3 = null;
        try {
            object2 = (InputStream)resourceName;
            object2 = ((InputStream)object2).readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object3 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)resourceName, (Throwable)object3);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)resourceName, null);
        Object bytes = object2;
        FontMgr fontMgr = FontMgr.Companion.getDefault();
        Intrinsics.checkNotNull((Object)bytes);
        Typeface typeface2 = FontMgr.makeFromData$default((FontMgr)fontMgr, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])object, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)typeface2);
        return typeface2;
    }

    private static final org.jetbrains.skia.FontStyle getSkFontStyle(Font $this$skFontStyle) {
        Font font;
        return new org.jetbrains.skia.FontStyle($this$skFontStyle.getWeight().getWeight(), 5, FontStyle.equals-impl0(font.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA()) ? FontSlant.ITALIC : FontSlant.UPRIGHT);
    }

    /*
     * WARNING - void declaration
     */
    public static final Platform currentPlatform() {
        void var0;
        String name = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"Linux", (boolean)false, (int)2, null)) {
            return Platform.Linux;
        }
        if (StringsKt.startsWith$default((String)name, (String)"Win", (boolean)false, (int)2, null)) {
            return Platform.Windows;
        }
        if (Intrinsics.areEqual((Object)var0, (Object)"Mac OS X")) {
            return Platform.MacOS;
        }
        return Platform.Unknown;
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

