/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018"}, d2={"Landroidx/compose/ui/text/input/SetComposingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "Landroidx/compose/ui/text/AnnotatedString;", "annotatedString", "", "newCursorPosition", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;I)V", "", "text", "(Ljava/lang/String;I)V", "Landroidx/compose/ui/text/input/EditingBuffer;", "buffer", "", "applyTo", "(Landroidx/compose/ui/text/input/EditingBuffer;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Landroidx/compose/ui/text/AnnotatedString;", "I", "getNewCursorPosition", "getText"})
public final class SetComposingTextCommand
implements EditCommand {
    public final AnnotatedString annotatedString;
    private final int newCursorPosition;

    /*
     * WARNING - void declaration
     */
    public SetComposingTextCommand(AnnotatedString annotatedString, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        this.annotatedString = var1_1;
        this.newCursorPosition = var2_2;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    /*
     * WARNING - void declaration
     */
    public SetComposingTextCommand(String text, int newCursorPosition) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new AnnotatedString((String)var1_1, null, 2, null), (int)var2_2);
    }

    public final String getText() {
        return this.annotatedString.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text()) {
            int compositionStart = buffer.getCompositionStart$ui_text();
            EditingBuffer editingBuffer = buffer;
            editingBuffer.replace$ui_text(editingBuffer.getCompositionStart$ui_text(), buffer.getCompositionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                int n = compositionStart;
                buffer.setComposition$ui_text(n, n + this.getText().length());
            }
        } else {
            int selectionStart = buffer.getSelectionStart$ui_text();
            EditingBuffer editingBuffer = buffer;
            editingBuffer.replace$ui_text(editingBuffer.getSelectionStart$ui_text(), buffer.getSelectionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                int n = selectionStart;
                buffer.setComposition$ui_text(n, n + this.getText().length());
            }
        }
        int newCursor = buffer.getCursor$ui_text();
        int newCursorInBuffer = this.newCursorPosition > 0 ? newCursor + this.newCursorPosition - 1 : newCursor + this.newCursorPosition - this.getText().length();
        buffer.setCursor$ui_text(RangesKt.coerceIn((int)var2_2, (int)0, (int)var1_1.getLength$ui_text()));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetComposingTextCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getText(), (Object)((SetComposingTextCommand)other).getText())) {
            return false;
        }
        return this.newCursorPosition == ((SetComposingTextCommand)var1_1).newCursorPosition;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.getText().hashCode();
        var1_1 = var1_1 * 31 + this.newCursorPosition;
        return (int)var1_1;
    }

    public final String toString() {
        return "SetComposingTextCommand(text='" + this.getText() + "', newCursorPosition=" + this.newCursorPosition + ")";
    }
}

