/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.GapBuffer;
import androidx.compose.ui.text.input.GapBufferKt;
import androidx.compose.ui.text.input.GapBuffer_jvmKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer;", "", "", "text", "<init>", "(Ljava/lang/String;)V", "", "start", "end", "", "replace", "(IILjava/lang/String;)V", "index", "", "get", "(I)C", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Landroidx/compose/ui/text/input/GapBuffer;", "buffer", "Landroidx/compose/ui/text/input/GapBuffer;", "bufStart", "I", "bufEnd", "getLength", "()I", "length", "Companion"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/PartialGapBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,318:1\n118#2,4:319\n118#2,4:323\n*S KotlinDebug\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/PartialGapBuffer\n*L\n242#1:319,4\n245#1:323,4\n*E\n"})
public final class PartialGapBuffer {
    public static final Companion Companion = new Companion(null);
    public String text;
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PartialGapBuffer(String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = var1_1;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLength() {
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + var1_1.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, String text) {
        void var3_3;
        void var4_4;
        int bufferEnd;
        int bufferStart;
        while (true) {
            GapBuffer buffer;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            boolean bl = start <= end;
            if (!bl) {
                InlineClassHelperKt.throwIllegalArgumentException("start index must be less than or equal to end index: " + start + " > " + end);
            }
            if (!(bl = start >= 0)) {
                InlineClassHelperKt.throwIllegalArgumentException("start must be non-negative, but was " + start);
            }
            if ((buffer = this.buffer) == null) {
                char[] charArray = new char[Math.max(255, text.length() + 128)];
                int leftCopyCount = Math.min(start, 64);
                int rightCopyCount = Math.min(this.text.length() - end, 64);
                GapBuffer_jvmKt.toCharArray(this.text, charArray, 0, start - leftCopyCount, start);
                int n = end;
                GapBuffer_jvmKt.toCharArray(this.text, charArray, charArray.length - rightCopyCount, n, n + rightCopyCount);
                GapBufferKt.access$toCharArray(text, charArray, leftCopyCount);
                this.buffer = new GapBuffer(charArray, leftCopyCount + text.length(), charArray.length - rightCopyCount);
                this.bufStart = start - leftCopyCount;
                this.bufEnd = end + rightCopyCount;
                return;
            }
            bufferStart = start - this.bufStart;
            bufferEnd = end - this.bufStart;
            if (bufferStart >= 0 && bufferEnd <= var4_4.length()) break;
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
        }
        var4_4.replace(bufferStart, bufferEnd, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var3_3;
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index);
        }
        GapBuffer buffer = gapBuffer;
        if (index < this.bufStart) {
            return this.text.charAt(index);
        }
        int gapBufLength = buffer.length();
        if (index < gapBufLength + this.bufStart) {
            void var2_2;
            return var2_2.get(index - this.bufStart);
        }
        return this.text.charAt((int)(var1_1 - (var3_3 - this.bufEnd + this.bufStart)));
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        void var1_1;
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text;
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        var1_1.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

