/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.GapBufferKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001e\u001a\u00020\u00102\n\u0010\u001d\u001a\u00060\u001bj\u0002`\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\nJ\u000f\u0010!\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010$R\u0016\u0010(\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010$"}, d2={"Landroidx/compose/ui/text/input/GapBuffer;", "", "", "initBuffer", "", "initGapStart", "initGapEnd", "<init>", "([CII)V", "gapLength", "()I", "index", "", "get", "(I)C", "requestSize", "", "makeSureAvailableSpace", "(I)V", "start", "end", "delete", "(II)V", "", "text", "replace", "(IILjava/lang/String;)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "append", "(Ljava/lang/StringBuilder;)V", "length", "toString", "()Ljava/lang/String;", "capacity", "I", "buffer", "[C", "gapStart", "gapEnd"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/ui/text/input/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
final class GapBuffer {
    private int capacity;
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    /*
     * WARNING - void declaration
     */
    public GapBuffer(char[] initBuffer, int initGapStart, int initGapEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)initBuffer, (String)"initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = var1_1;
        this.gapStart = var2_2;
        this.gapEnd = var3_3;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var1_1;
        if (index < this.gapStart) {
            return this.buffer[index];
        }
        return this.buffer[var1_1 - this.gapStart + this.gapEnd];
    }

    /*
     * WARNING - void declaration
     */
    private final void makeSureAvailableSpace(int requestSize) {
        void var2_3;
        void var1_2;
        void var3_4;
        if (requestSize <= this.gapLength()) {
            return;
        }
        int necessarySpace = requestSize - this.gapLength();
        int newCapacity = this.capacity << 1;
        while (newCapacity - this.capacity < necessarySpace) {
            newCapacity <<= 1;
        }
        char[] newBuffer = new char[newCapacity];
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)0, (int)0, (int)this.gapStart);
        int tailLength = this.capacity - this.gapEnd;
        int newEnd = newCapacity - tailLength;
        ArraysKt.copyInto((char[])this.buffer, (char[])newBuffer, (int)newEnd, (int)this.gapEnd, (int)(this.gapEnd + var3_4));
        this.buffer = var1_2;
        this.capacity = var2_3;
        this.gapEnd = newEnd;
    }

    /*
     * WARNING - void declaration
     */
    private final void delete(int start, int end) {
        void var1_1;
        void var2_2;
        void var3_4;
        if (start < this.gapStart && end <= this.gapStart) {
            int copyLen = this.gapStart - end;
            ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)(this.gapEnd - copyLen), (int)end, (int)this.gapStart);
            this.gapStart = start;
            this.gapEnd -= copyLen;
            return;
        }
        if (start < this.gapStart && end >= this.gapStart) {
            this.gapEnd = end + this.gapLength();
            this.gapStart = start;
            return;
        }
        int startInBuffer = start + this.gapLength();
        int endInBuffer = end + this.gapLength();
        int copyLen = startInBuffer - this.gapEnd;
        ArraysKt.copyInto((char[])this.buffer, (char[])this.buffer, (int)this.gapStart, (int)this.gapEnd, (int)var3_4);
        this.gapStart += var2_2;
        this.gapEnd = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void replace(int start, int end, String text) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.makeSureAvailableSpace(text.length() - (end - start));
        this.delete((int)var1_1, (int)var2_2);
        GapBufferKt.access$toCharArray(text, this.buffer, this.gapStart);
        this.gapStart += var3_3.length();
    }

    /*
     * WARNING - void declaration
     */
    public final void append(StringBuilder builder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        StringBuilder stringBuilder = builder;
        char[] cArray = this.buffer;
        int n = this.gapStart;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, 0, n), (String)"append(...)");
        stringBuilder = var1_1;
        cArray = this.buffer;
        int n2 = this.gapEnd;
        n = this.capacity;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cArray, n2, n - n2), (String)"append(...)");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)var2_2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

