/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.BackspaceCommand;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.MoveCursorCommand;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0014\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0013*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0000@BX\u0080\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001a8\u0000@BX\u0080\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c"}, d2={"Landroidx/compose/ui/text/input/EditProcessor;", "", "<init>", "()V", "Landroidx/compose/ui/text/input/TextFieldValue;", "value", "Landroidx/compose/ui/text/input/TextInputSession;", "textInputSession", "", "reset", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/TextInputSession;)V", "", "Landroidx/compose/ui/text/input/EditCommand;", "editCommands", "apply", "(Ljava/util/List;)Landroidx/compose/ui/text/input/TextFieldValue;", "toTextFieldValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "failedCommand", "", "generateBatchErrorMessage", "(Ljava/util/List;Landroidx/compose/ui/text/input/EditCommand;)Ljava/lang/String;", "toStringForLog", "(Landroidx/compose/ui/text/input/EditCommand;)Ljava/lang/String;", "mBufferState", "Landroidx/compose/ui/text/input/TextFieldValue;", "Landroidx/compose/ui/text/input/EditingBuffer;", "mBuffer", "Landroidx/compose/ui/text/input/EditingBuffer;"})
@SourceDebugExtension(value={"SMAP\nEditProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n35#2,5:170\n1#3:175\n*S KotlinDebug\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n*L\n101#1:170,5\n*E\n"})
public final class EditProcessor {
    public TextFieldValue mBufferState = new TextFieldValue(AnnotatedStringKt.emptyAnnotatedString(), TextRange.Companion.getZero-d9O1mEE(), null, null);
    public EditingBuffer mBuffer = new EditingBuffer(this.mBufferState.getAnnotatedString(), this.mBufferState.getSelection-d9O1mEE(), null);
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public final void reset(TextFieldValue value, TextInputSession textInputSession) {
        void var2_2;
        void newValue;
        TextFieldValue textFieldValue;
        boolean compositionChanged;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean textChanged = false;
        boolean selectionChanged = false;
        boolean bl = compositionChanged = !Intrinsics.areEqual((Object)value.getComposition-MzsxiRA(), (Object)this.mBuffer.getComposition-MzsxiRA$ui_text());
        if (!Intrinsics.areEqual((Object)this.mBufferState.getAnnotatedString().getText(), (Object)value.getAnnotatedString().getText())) {
            this.mBuffer = new EditingBuffer(value.getAnnotatedString(), value.getSelection-d9O1mEE(), null);
            textChanged = true;
        } else if (!TextRange.equals-impl0(this.mBufferState.getSelection-d9O1mEE(), value.getSelection-d9O1mEE())) {
            this.mBuffer.setSelection$ui_text(TextRange.getMin-impl(value.getSelection-d9O1mEE()), TextRange.getMax-impl(value.getSelection-d9O1mEE()));
            selectionChanged = true;
        }
        if (value.getComposition-MzsxiRA() == null) {
            this.mBuffer.commitComposition$ui_text();
        } else if (!TextRange.getCollapsed-impl(value.getComposition-MzsxiRA().unbox-impl())) {
            this.mBuffer.setComposition$ui_text(TextRange.getMin-impl(value.getComposition-MzsxiRA().unbox-impl()), TextRange.getMax-impl(value.getComposition-MzsxiRA().unbox-impl()));
        }
        if (textChanged || !selectionChanged && compositionChanged) {
            this.mBuffer.commitComposition$ui_text();
            textFieldValue = TextFieldValue.copy-3r_uNRQ$default(value, null, 0L, null, 3, null);
        } else {
            textFieldValue = newValue;
        }
        newValue = textFieldValue;
        TextFieldValue oldValue = this.mBufferState;
        this.mBufferState = newValue;
        void v2 = var2_2;
        if (v2 != null) {
            void var1_1;
            void var3_4;
            v2.updateState((TextFieldValue)var3_4, (TextFieldValue)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final TextFieldValue apply(List<? extends EditCommand> editCommands) {
        void var3_3;
        TextFieldValue newState;
        void $this$apply_u24lambda_u242;
        AnnotatedString annotatedString;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
        EditCommand lastCommand = null;
        try {
            List<? extends EditCommand> $this$fastForEach$iv = editCommands;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                object2 = $this$fastForEach$iv.get(index$iv);
                EditCommand it = object2;
                lastCommand = object2;
                it.applyTo(this.mBuffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.generateBatchErrorMessage((List<? extends EditCommand>)object, (EditCommand)((Object)annotatedString)), e);
        }
        long index$iv = this.mBuffer.getSelection-d9O1mEE$ui_text();
        object = this.mBuffer.toAnnotatedString$ui_text();
        object2 = TextRange.box-impl((long)$this$apply_u24lambda_u242);
        ((TextRange)object2).unbox-impl();
        Object object3 = !TextRange.getReversed-impl(this.mBufferState.getSelection-d9O1mEE()) ? object2 : null;
        long l = object3 != null ? ((TextRange)object3).unbox-impl() : TextRangeKt.TextRange(TextRange.getMax-impl((long)$this$apply_u24lambda_u242), TextRange.getMin-impl((long)$this$apply_u24lambda_u242));
        AnnotatedString annotatedString2 = object;
        object = this.mBuffer.getComposition-MzsxiRA$ui_text();
        long l2 = l;
        annotatedString = annotatedString2;
        this.mBufferState = newState = new TextFieldValue(annotatedString, l2, (TextRange)object, null);
        return var3_3;
    }

    public final TextFieldValue toTextFieldValue() {
        return this.mBufferState;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateBatchErrorMessage(List<? extends EditCommand> editCommands, EditCommand failedCommand) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        StringBuilder $this$generateBatchErrorMessage_u24lambda_u244 = stringBuilder = new StringBuilder();
        stringBuilder.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength$ui_text() + ", composition=" + this.mBuffer.getComposition-MzsxiRA$ui_text() + ", selection=" + TextRange.toString-impl(this.mBuffer.getSelection-d9O1mEE$ui_text()) + "):").append('\n');
        CollectionsKt.joinTo$default((Iterable)((Iterable)var1_1), (Appendable)$this$generateBatchErrorMessage_u24lambda_u244, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> EditProcessor.generateBatchErrorMessage$lambda$4$lambda$3((EditCommand)var2_2, this, arg_0), (int)60, null);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String toStringForLog(EditCommand $this$toStringForLog) {
        void var1_1;
        EditCommand editCommand = $this$toStringForLog;
        if (editCommand instanceof CommitTextCommand) {
            return "CommitTextCommand(text.length=" + ((CommitTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((CommitTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        }
        if (editCommand instanceof SetComposingTextCommand) {
            return "SetComposingTextCommand(text.length=" + ((SetComposingTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((SetComposingTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        }
        if (editCommand instanceof SetComposingRegionCommand) {
            return ((SetComposingRegionCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof DeleteSurroundingTextCommand) {
            return ((DeleteSurroundingTextCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof DeleteSurroundingTextInCodePointsCommand) {
            return ((DeleteSurroundingTextInCodePointsCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof SetSelectionCommand) {
            return ((SetSelectionCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof FinishComposingTextCommand) {
            return ((FinishComposingTextCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof BackspaceCommand) {
            return ((BackspaceCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof MoveCursorCommand) {
            return ((MoveCursorCommand)$this$toStringForLog).toString();
        }
        if (editCommand instanceof DeleteAllCommand) {
            return ((DeleteAllCommand)$this$toStringForLog).toString();
        }
        String string = Reflection.getOrCreateKotlinClass(var1_1.getClass()).getSimpleName();
        if (string == null) {
            string = "{anonymous EditCommand}";
        }
        return "Unknown EditCommand: " + string;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateBatchErrorMessage$lambda$4$lambda$3(EditCommand $failedCommand, EditProcessor this$0, EditCommand it) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        string = string == it ? " > " : "   ";
        return (String)string + super.toStringForLog((EditCommand)var2_2);
    }
}

