/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "", "lengthBeforeCursor", "lengthAfterCursor", "<init>", "(II)V", "Landroidx/compose/ui/text/input/EditingBuffer;", "buffer", "", "applyTo", "(Landroidx/compose/ui/text/input/EditingBuffer;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "I"})
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,558:1\n118#2,4:559\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n*L\n309#1:559,4\n*E\n"})
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    public final int lengthBeforeCursor;
    public final int lengthAfterCursor;

    /*
     * WARNING - void declaration
     */
    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        void var2_2;
        boolean bl;
        this.lengthBeforeCursor = bl;
        this.lengthAfterCursor = var2_2;
        bl = this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyTo(EditingBuffer buffer) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = this.lengthBeforeCursor;
        for (int i = 0; i < n; ++i) {
            if (buffer.getSelectionStart$ui_text() > ++beforeLenInChars) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionStart$ui_text() - beforeLenInChars - 1);
                EditingBuffer editingBuffer2 = buffer;
                char trail = editingBuffer2.get$ui_text(editingBuffer2.getSelectionStart$ui_text() - beforeLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = buffer.getSelectionStart$ui_text();
            break;
        }
        int afterLenInChars = 0;
        int n2 = this.lengthAfterCursor;
        for (int i = 0; i < n2; ++i) {
            if (buffer.getSelectionEnd$ui_text() + ++afterLenInChars < buffer.getLength$ui_text()) {
                EditingBuffer editingBuffer = buffer;
                char lead = editingBuffer.get$ui_text(editingBuffer.getSelectionEnd$ui_text() + afterLenInChars - 1);
                EditingBuffer editingBuffer3 = buffer;
                char trail = editingBuffer3.get$ui_text(editingBuffer3.getSelectionEnd$ui_text() + afterLenInChars);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail)) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = buffer.getLength$ui_text() - buffer.getSelectionEnd$ui_text();
            break;
        }
        EditingBuffer editingBuffer = buffer;
        editingBuffer.delete$ui_text(editingBuffer.getSelectionEnd$ui_text(), buffer.getSelectionEnd$ui_text() + var3_3);
        EditingBuffer editingBuffer4 = buffer;
        editingBuffer4.delete$ui_text(editingBuffer4.getSelectionStart$ui_text() - var2_2, var1_1.getSelectionStart$ui_text());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)var1_1).lengthAfterCursor;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.lengthBeforeCursor;
        var1_1 = var1_1 * 31 + this.lengthAfterCursor;
        return (int)var1_1;
    }

    public final String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ")";
    }
}

