/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.ParagraphInfo;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.util.ListUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a%\u0010\u0005\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a%\u0010\t\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a9\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a%\u0010\u0014\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0006"}, d2={"", "Landroidx/compose/ui/text/ParagraphInfo;", "paragraphInfoList", "", "index", "findParagraphByIndex", "(Ljava/util/List;I)I", "", "y", "findParagraphByY", "(Ljava/util/List;F)I", "Landroidx/compose/ui/text/TextRange;", "range", "Lkotlin/Function1;", "", "action", "findParagraphsByRange-Sb-Bc2M", "(Ljava/util/List;JLkotlin/jvm/functions/Function1;)V", "findParagraphsByRange", "lineIndex", "findParagraphByLineIndex"})
@SourceDebugExtension(value={"SMAP\nMultiParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraphKt\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1227:1\n1092#1,11:1232\n1092#1,11:1247\n1092#1,11:1258\n118#2,4:1228\n118#2,4:1243\n*S KotlinDebug\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/MultiParagraphKt\n*L\n1022#1:1232,11\n1048#1:1247,11\n1082#1:1258,11\n1018#1:1228,4\n1029#1:1243,4\n*E\n"})
public final class MultiParagraphKt {
    /*
     * WARNING - void declaration
     */
    public static final int findParagraphByIndex(List<ParagraphInfo> paragraphInfoList, int index) {
        boolean bl;
        int paragraphIndex;
        int n;
        block5: {
            int n2;
            Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
            int lastLineEnd = ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getEndIndex();
            n = index <= ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getEndIndex() ? 1 : 0;
            if (n == 0) {
                InlineClassHelperKt.throwIllegalArgumentException("Index " + index + " should be less or equal than last line's end " + lastLineEnd);
            }
            List<ParagraphInfo> $this$fastBinarySearch$iv = paragraphInfoList;
            int low$iv = 0;
            int high$iv = $this$fastBinarySearch$iv.size() - 1;
            while (low$iv <= high$iv) {
                int cmp$iv;
                ParagraphInfo paragraphInfo;
                int mid$iv = low$iv + high$iv >>> 1;
                ParagraphInfo paragraphInfo2 = paragraphInfo = $this$fastBinarySearch$iv.get(mid$iv);
                if ((paragraphInfo.getStartIndex() > index ? 1 : (cmp$iv = paragraphInfo2.getEndIndex() <= index ? -1 : 0)) < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                n2 = mid$iv;
                break block5;
            }
            n2 = paragraphIndex = -(low$iv + 1);
        }
        boolean bl2 = paragraphIndex >= 0 ? paragraphIndex < ((Collection)paragraphInfoList).size() : (bl = false);
        if (!bl2) {
            List<ParagraphInfo> list;
            void var1_1;
            InlineClassHelperKt.throwIllegalArgumentException("Found paragraph index " + paragraphIndex + " should be in range [0, " + paragraphInfoList.size() + ").\nDebug info: index=" + (int)var1_1 + ", paragraphs=[" + ListUtilsKt.fastJoinToString$default(list, null, null, null, (int)0, null, MultiParagraphKt::findParagraphByIndex$lambda$3$lambda$2, (int)31, null) + "]");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final int findParagraphByY(List<ParagraphInfo> paragraphInfoList, float y) {
        void var2_2;
        List<ParagraphInfo> $this$fastBinarySearch$iv;
        Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
        if (y <= 0.0f) {
            return 0;
        }
        if (y >= ((ParagraphInfo)CollectionsKt.last(paragraphInfoList)).getBottom()) {
            return CollectionsKt.getLastIndex(paragraphInfoList);
        }
        int low$iv = 0;
        int high$iv = $this$fastBinarySearch$iv.size() - 1;
        while (low$iv <= high$iv) {
            int cmp$iv;
            ParagraphInfo paragraphInfo;
            ParagraphInfo paragraphInfo2;
            int mid$iv = low$iv + high$iv >>> 1;
            ParagraphInfo paragraphInfo3 = paragraphInfo2 = $this$fastBinarySearch$iv.get(mid$iv);
            if ((paragraphInfo.getTop() > y ? 1 : (cmp$iv = paragraphInfo3.getBottom() <= y ? -1 : 0)) < 0) {
                low$iv = mid$iv + 1;
                continue;
            }
            if (cmp$iv > 0) {
                high$iv = mid$iv - 1;
                continue;
            }
            return mid$iv;
        }
        return (int)(-(var2_2 + true));
    }

    public static final void findParagraphsByRange-Sb-Bc2M(List<ParagraphInfo> paragraphInfoList, long range, Function1<? super ParagraphInfo, Unit> action) {
        int n;
        ParagraphInfo paragraph;
        Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        int n2 = paragraphInfoList.size();
        for (int i = n = MultiParagraphKt.findParagraphByIndex(paragraphInfoList, TextRange.getMin-impl(range)); i < n2 && (paragraph = paragraphInfoList.get(i)).getStartIndex() < TextRange.getMax-impl(range); ++i) {
            if (paragraph.getStartIndex() == paragraph.getEndIndex()) continue;
            action.invoke((Object)paragraph);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int findParagraphByLineIndex(List<ParagraphInfo> paragraphInfoList, int lineIndex) {
        void var2_2;
        List<ParagraphInfo> $this$fastBinarySearch$iv;
        Intrinsics.checkNotNullParameter(paragraphInfoList, (String)"paragraphInfoList");
        int low$iv = 0;
        int high$iv = $this$fastBinarySearch$iv.size() - 1;
        while (low$iv <= high$iv) {
            int cmp$iv;
            ParagraphInfo paragraphInfo;
            int mid$iv = low$iv + high$iv >>> 1;
            ParagraphInfo paragraphInfo2 = paragraphInfo = $this$fastBinarySearch$iv.get(mid$iv);
            if ((paragraphInfo.getStartLineIndex() > lineIndex ? 1 : (cmp$iv = paragraphInfo2.getEndLineIndex() <= lineIndex ? -1 : 0)) < 0) {
                low$iv = mid$iv + 1;
                continue;
            }
            if (cmp$iv > 0) {
                high$iv = mid$iv - 1;
                continue;
            }
            return mid$iv;
        }
        return (int)(-(var2_2 + true));
    }

    private static final CharSequence findParagraphByIndex$lambda$3$lambda$2(ParagraphInfo it) {
        ParagraphInfo paragraphInfo;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[" + it.getStartIndex() + ", " + paragraphInfo.getEndIndex() + ")";
    }
}

