/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.MultiParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphIntrinsicInfo;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.ParagraphIntrinsicsKt;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R#\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001f\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\"\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\u001eR \u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b$\u0010\u0017\u001a\u0004\b%\u0010\u0019R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010("}, d2={"Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "Landroidx/compose/ui/text/ParagraphIntrinsics;", "Landroidx/compose/ui/text/AnnotatedString;", "annotatedString", "Landroidx/compose/ui/text/TextStyle;", "style", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "placeholders", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "fontFamilyResolver", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;Ljava/util/List;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;)V", "Landroidx/compose/ui/text/ParagraphStyle;", "defaultStyle", "resolveTextDirection", "(Landroidx/compose/ui/text/ParagraphStyle;Landroidx/compose/ui/text/ParagraphStyle;)Landroidx/compose/ui/text/ParagraphStyle;", "Landroidx/compose/ui/text/AnnotatedString;", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "Ljava/util/List;", "getPlaceholders", "()Ljava/util/List;", "", "minIntrinsicWidth$delegate", "Lkotlin/Lazy;", "getMinIntrinsicWidth", "()F", "minIntrinsicWidth", "maxIntrinsicWidth$delegate", "getMaxIntrinsicWidth", "maxIntrinsicWidth", "Landroidx/compose/ui/text/ParagraphIntrinsicInfo;", "infoList", "getInfoList$ui_text", "", "getHasStaleResolvedFonts", "()Z", "hasStaleResolvedFonts"})
@SourceDebugExtension(value={"SMAP\nMultiParagraphIntrinsics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,157:1\n1284#2:158\n1286#2:164\n1285#2,3:165\n151#3,2:159\n35#3,3:161\n39#3:168\n153#3:169\n103#3:170\n35#3,5:171\n104#3:176\n169#3,12:177\n169#3,12:189\n*S KotlinDebug\n*F\n+ 1 MultiParagraphIntrinsics.kt\nandroidx/compose/ui/text/MultiParagraphIntrinsics\n*L\n98#1:158\n98#1:164\n98#1:165,3\n98#1:159,2\n98#1:161,3\n98#1:168\n98#1:169\n125#1:170\n125#1:171,5\n125#1:176\n79#1:177,12\n85#1:189,12\n*E\n"})
public final class MultiParagraphIntrinsics
implements ParagraphIntrinsics {
    private final AnnotatedString annotatedString;
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    private final Lazy minIntrinsicWidth$delegate;
    private final Lazy maxIntrinsicWidth$delegate;
    private final List<ParagraphIntrinsicInfo> infoList;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public MultiParagraphIntrinsics(AnnotatedString annotatedString, TextStyle style, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, FontFamily.Resolver fontFamilyResolver) {
        void defaultParagraphStyle$iv;
        void $this$mapEachParagraphStyle$iv;
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.annotatedString = annotatedString;
        this.placeholders = placeholders;
        this.minIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.minIntrinsicWidth_delegate$lambda$1(this));
        this.maxIntrinsicWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> MultiParagraphIntrinsics.maxIntrinsicWidth_delegate$lambda$3(this));
        ParagraphStyle paragraphStyle = style.toParagraphStyle();
        MultiParagraphIntrinsics multiParagraphIntrinsics = this;
        placeholders = multiParagraphIntrinsics.annotatedString;
        ParagraphStyle paragraphStyle2 = paragraphStyle;
        MultiParagraphIntrinsics multiParagraphIntrinsics2 = multiParagraphIntrinsics;
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastMap$iv$iv = AnnotatedStringKt.normalizedParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, (ParagraphStyle)defaultParagraphStyle$iv);
        ArrayList target$iv$iv = new ArrayList($this$fastMap$iv$iv.size());
        List<AnnotatedString.Range<ParagraphStyle>> $this$fastForEach$iv$iv$iv = $this$fastMap$iv$iv;
        int n = ((Collection)$this$fastForEach$iv$iv$iv).size();
        for (int index$iv$iv$iv = 0; index$iv$iv$iv < n; ++index$iv$iv$iv) {
            void paragraphStyleItem;
            void paragraphStyleRange$iv;
            AnnotatedString.Range<ParagraphStyle> range;
            AnnotatedString.Range<ParagraphStyle> it$iv$iv = range = $this$fastForEach$iv$iv$iv.get(index$iv$iv$iv);
            Collection collection = target$iv$iv;
            Object object = AnnotatedStringKt.access$substringWithoutParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyleRange$iv.getStart(), paragraphStyleRange$iv.getEnd());
            AnnotatedString annotatedString2 = object;
            ParagraphStyle currentParagraphStyle = MultiParagraphIntrinsics.access$resolveTextDirection(this, (ParagraphStyle)paragraphStyleItem.getItem(), paragraphStyle);
            String string = annotatedString2.getText();
            TextStyle textStyle = style.merge(currentParagraphStyle);
            List list = annotatedString2.getAnnotations$ui_text();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            object = list;
            List list2 = MultiParagraphIntrinsicsKt.access$getLocalPlaceholders(this.getPlaceholders(), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd());
            collection.add(new ParagraphIntrinsicInfo(ParagraphIntrinsicsKt.ParagraphIntrinsics(string, textStyle, (List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>>)object, density, fontFamilyResolver, list2), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd()));
        }
        multiParagraphIntrinsics2.infoList = target$iv$iv;
    }

    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public final float getMinIntrinsicWidth() {
        Lazy lazy = this.minIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @Override
    public final float getMaxIntrinsicWidth() {
        Lazy lazy = this.maxIntrinsicWidth$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final List<ParagraphIntrinsicInfo> getInfoList$ui_text() {
        return this.infoList;
    }

    @Override
    public final boolean getHasStaleResolvedFonts() {
        List<ParagraphIntrinsicInfo> $this$fastForEach$iv$iv = this.infoList;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = $this$fastForEach$iv$iv.get(index$iv$iv);
            ParagraphIntrinsicInfo paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            paragraphIntrinsicInfo2 = paragraphIntrinsicInfo;
            if (!paragraphIntrinsicInfo.getIntrinsics().getHasStaleResolvedFonts()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final ParagraphStyle resolveTextDirection(ParagraphStyle style, ParagraphStyle defaultStyle) {
        void var2_2;
        void var1_1;
        if (!TextDirection.equals-impl0(style.getTextDirection-s_7X-co(), TextDirection.Companion.getUnspecified-s_7X-co())) {
            return style;
        }
        return ParagraphStyle.copy-ykzQM6k$default((ParagraphStyle)var1_1, 0, var2_2.getTextDirection-s_7X-co(), 0L, null, null, null, 0, 0, null, 509, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final float minIntrinsicWidth_delegate$lambda$1(MultiParagraphIntrinsics this$0) {
        Object object;
        Object v0;
        List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this$0.infoList;
        if ($this$fastMaxBy$iv.isEmpty()) {
            v0 = null;
        } else {
            void var1_1;
            Object maxElem$iv = $this$fastMaxBy$iv.get(0);
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = (ParagraphIntrinsicInfo)maxElem$iv;
            float maxValue$iv = paragraphIntrinsicInfo.getIntrinsics().getMinIntrinsicWidth();
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex((List)$this$fastMaxBy$iv);
            if (n > 0) {
                while (true) {
                    Object e$iv;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo2;
                    float v$iv;
                    if (Float.compare(maxValue$iv, v$iv = (paragraphIntrinsicInfo2 = (ParagraphIntrinsicInfo)(e$iv = $this$fastMaxBy$iv.get(i$iv))).getIntrinsics().getMinIntrinsicWidth()) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            v0 = var1_1;
        }
        if ((object = (ParagraphIntrinsicInfo)v0) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null) {
            return object.getMinIntrinsicWidth();
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float maxIntrinsicWidth_delegate$lambda$3(MultiParagraphIntrinsics this$0) {
        Object object;
        Object v0;
        List<ParagraphIntrinsicInfo> $this$fastMaxBy$iv = this$0.infoList;
        if ($this$fastMaxBy$iv.isEmpty()) {
            v0 = null;
        } else {
            void var1_1;
            Object maxElem$iv = $this$fastMaxBy$iv.get(0);
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = (ParagraphIntrinsicInfo)maxElem$iv;
            float maxValue$iv = paragraphIntrinsicInfo.getIntrinsics().getMaxIntrinsicWidth();
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex((List)$this$fastMaxBy$iv);
            if (n > 0) {
                while (true) {
                    Object e$iv;
                    ParagraphIntrinsicInfo paragraphIntrinsicInfo2;
                    float v$iv;
                    if (Float.compare(maxValue$iv, v$iv = (paragraphIntrinsicInfo2 = (ParagraphIntrinsicInfo)(e$iv = $this$fastMaxBy$iv.get(i$iv))).getIntrinsics().getMaxIntrinsicWidth()) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            v0 = var1_1;
        }
        if ((object = (ParagraphIntrinsicInfo)v0) != null && (object = ((ParagraphIntrinsicInfo)object).getIntrinsics()) != null) {
            return object.getMaxIntrinsicWidth();
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ParagraphStyle access$resolveTextDirection(MultiParagraphIntrinsics $this, ParagraphStyle style, ParagraphStyle defaultStyle) {
        void var2_2;
        void var1_1;
        return $this.resolveTextDirection((ParagraphStyle)var1_1, (ParagraphStyle)var2_2);
    }
}

