/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.collection.IntList;
import androidx.collection.IntListKt;
import androidx.collection.MutableIntList;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.Bullet;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.StringAnnotation;
import androidx.compose.ui.text.StringAnnotationKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.unit.TextUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 B2\u00020\u0001:\u0004CDEBB)\b\u0000\u0012\u0016\u0010\u0005\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0018\u00010\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0002\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ1\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010\"J)\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001e\u0010#J)\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b%\u0010#J\u001d\u0010&\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b&\u0010'J\u001a\u0010)\u001a\u00020 2\b\u0010\u0018\u001a\u0004\u0018\u00010(H\u0096\u0002\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0000\u00a2\u0006\u0004\b/\u00100J1\u00103\u001a\u00020\u00002\"\u00102\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000301\u00a2\u0006\u0004\b3\u00104J7\u00105\u001a\u00020\u00002(\u00102\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u000201\u00a2\u0006\u0004\b5\u00104R*\u0010\u0005\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0018\u00010\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u00106\u001a\u0004\b7\u00108R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00109\u001a\u0004\b:\u0010.R\"\u0010<\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\u0003\u0018\u00010\u00028\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b<\u00106R(\u0010>\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\u0003\u0018\u00010\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b>\u00106\u001a\u0004\b?\u00108R\u0014\u0010A\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010,"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "annotations", "", "text", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/util/List;)V", "", "index", "", "get", "(I)C", "startIndex", "endIndex", "subSequence", "(II)Landroidx/compose/ui/text/AnnotatedString;", "Landroidx/compose/ui/text/TextRange;", "range", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "other", "plus", "(Landroidx/compose/ui/text/AnnotatedString;)Landroidx/compose/ui/text/AnnotatedString;", "tag", "start", "end", "getStringAnnotations", "(Ljava/lang/String;II)Ljava/util/List;", "", "hasStringAnnotations", "(Ljava/lang/String;II)Z", "(II)Ljava/util/List;", "Landroidx/compose/ui/text/LinkAnnotation;", "getLinkAnnotations", "hasLinkAnnotations", "(II)Z", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "hasEqualAnnotations", "(Landroidx/compose/ui/text/AnnotatedString;)Z", "Lkotlin/Function1;", "transform", "mapAnnotations", "(Lkotlin/jvm/functions/Function1;)Landroidx/compose/ui/text/AnnotatedString;", "flatMapAnnotations", "Ljava/util/List;", "getAnnotations$ui_text", "()Ljava/util/List;", "Ljava/lang/String;", "getText", "Landroidx/compose/ui/text/SpanStyle;", "spanStylesOrNull", "Landroidx/compose/ui/text/ParagraphStyle;", "paragraphStylesOrNull", "getParagraphStylesOrNull$ui_text", "getLength", "length", "Companion", "Range", "Builder", "Annotation"})
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IntList.kt\nandroidx/collection/IntList\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1622:1\n35#2,5:1623\n251#2,2:1640\n35#2,5:1642\n253#2:1647\n103#2:1648\n35#2,5:1649\n104#2:1654\n251#2,2:1655\n35#2,5:1657\n253#2:1662\n231#2,2:1663\n35#2,5:1665\n233#2:1670\n231#2,2:1671\n35#2,5:1673\n233#2:1678\n231#2,2:1679\n35#2,5:1681\n233#2:1686\n103#2:1687\n35#2,5:1688\n104#2:1693\n1056#3:1628\n366#4:1629\n70#4:1630\n118#5,4:1631\n118#5,4:1636\n1#6:1635\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n121#1:1623,5\n221#1:1640,2\n221#1:1642,5\n221#1:1647\n231#1:1648\n231#1:1649,5\n231#1:1654\n246#1:1655,2\n246#1:1657,5\n246#1:1662\n263#1:1663,2\n263#1:1665,5\n263#1:1670\n281#1:1671,2\n281#1:1673,5\n281#1:1678\n297#1:1679,2\n297#1:1681,5\n297#1:1686\n306#1:1687\n306#1:1688,5\n306#1:1693\n137#1:1628\n148#1:1629\n151#1:1630\n153#1:1631,4\n177#1:1636,4\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    public static final Companion Companion = new Companion(null);
    private final List<Range<? extends Annotation>> annotations;
    private final String text;
    public final List<Range<SpanStyle>> spanStylesOrNull;
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    public static final Saver<AnnotatedString, ?> Saver = SaversKt.getAnnotatedStringSaver();

    public AnnotatedString(List<? extends Range<? extends Annotation>> annotations, String text) {
        List list;
        Collection<Range<Annotation>> $this$fastForEach$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.annotations = annotations;
        this.text = text;
        List spanStyles = null;
        Iterable paragraphStyles = null;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            $this$fastForEach$iv = list2;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Range<? extends Annotation> range;
                Range<? extends Annotation> annotation = range = $this$fastForEach$iv.get(index$iv);
                if (range.getItem() instanceof SpanStyle) {
                    if (spanStyles == null) {
                        spanStyles = new ArrayList();
                    }
                    Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.SpanStyle>");
                    spanStyles.add(annotation);
                    continue;
                }
                if (!(annotation.getItem() instanceof ParagraphStyle)) continue;
                if (paragraphStyles == null) {
                    paragraphStyles = new ArrayList();
                }
                Intrinsics.checkNotNull(annotation, (String)"null cannot be cast to non-null type androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.ParagraphStyle>");
                paragraphStyles.add(annotation);
            }
        }
        this.spanStylesOrNull = spanStyles;
        List<Range<ParagraphStyle>> list3 = this.paragraphStylesOrNull = paragraphStyles;
        if (list3 != null) {
            paragraphStyles = list3;
            list = CollectionsKt.sortedWith((Iterable)paragraphStyles, (Comparator)new Comparator(){

                /*
                 * WARNING - void declaration
                 */
                public final int compare(T a, T b) {
                    void var1_1;
                    Comparable comparable;
                    a = (Range)a;
                    Range it = (Range)((Object)comparable);
                    comparable = Integer.valueOf(((Range)a).getStart());
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(var1_1.getStart()));
                }
            });
        } else {
            list = null;
        }
        List sorted = list;
        $this$fastForEach$iv = list;
        if (!($this$fastForEach$iv == null || $this$fastForEach$iv.isEmpty())) {
            MutableIntList previousEnds = IntListKt.mutableIntListOf((int)((Range)CollectionsKt.first((List)sorted)).getEnd());
            int n = sorted.size();
            for (int i = 1; i < n; ++i) {
                Range current;
                block11: {
                    int previousEnd;
                    current = (Range)sorted.get(i);
                    while (true) {
                        IntList intList = (IntList)previousEnds;
                        if (!(intList._size != 0)) break block11;
                        previousEnd = previousEnds.last();
                        if (current.getStart() < previousEnd) break;
                        MutableIntList mutableIntList = previousEnds;
                        IntList intList2 = (IntList)mutableIntList;
                        mutableIntList.removeAt(intList2._size - 1);
                    }
                    boolean bl = current.getEnd() <= previousEnd;
                    if (!bl) {
                        InlineClassHelperKt.throwIllegalArgumentException("Paragraph overlap not allowed, end " + current.getEnd() + " should be less than or equal to " + previousEnd);
                    }
                }
                previousEnds.add(current.getEnd());
            }
        }
    }

    public final List<Range<? extends Annotation>> getAnnotations$ui_text() {
        return this.annotations;
    }

    public final String getText() {
        return this.text;
    }

    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotatedString(String text, List<? extends Range<? extends Annotation>> annotations) {
        void var1_1;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Object object3 = this;
        object2 = (Collection)object2;
        if (object2.isEmpty()) {
            object2 = object3;
            object = null;
            object3 = object2;
        } else {
            object = object2;
        }
        ((AnnotatedString)object3)((List)object, (String)var1_1);
    }

    public /* synthetic */ AnnotatedString(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    public final int getLength() {
        return this.text.length();
    }

    /*
     * WARNING - void declaration
     */
    public final char get(int index) {
        void var1_1;
        return this.text.charAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AnnotatedString subSequence(int startIndex, int endIndex) {
        void var3_5;
        void var2_3;
        void var1_1;
        boolean bl = startIndex <= endIndex;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("start (" + startIndex + ") should be less or equal to end (" + endIndex + ")");
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        List list = AnnotatedStringKt.access$filterRanges(this.annotations, (int)var1_1, (int)var2_3);
        return new AnnotatedString(list, (String)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        void var1_1;
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString plus(AnnotatedString other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u245 = new Builder(this);
        $this$plus_u24lambda_u245.append((AnnotatedString)var1_1);
        return var2_2.toAnnotatedString();
    }

    public final List<Range<String>> getStringAnnotations(String tag, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Annotation>> list = this.annotations;
        if (list != null) {
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            List<Range<? extends Annotation>> $this$fastForEach$iv$iv = $this$fastFilteredMap$iv;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object object = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range<? extends Annotation> it$iv = object;
                Range<? extends Annotation> it = object;
                if (!(((Range)object).getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                it = it$iv;
                object = target$iv;
                object.add(StringAnnotationKt.unbox(it));
            }
            return target$iv;
        }
        return CollectionsKt.emptyList();
    }

    public final boolean hasStringAnnotations(String tag, int start, int end) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            List<Range<? extends Annotation>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Annotation>> list2 = list;
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = list;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> range = $this$fastForEach$iv$iv.get(index$iv$iv);
                    Range<? extends Annotation> range2 = range;
                    range2 = range;
                    Range<? extends Annotation> it = range;
                    if (!(range.getItem() instanceof StringAnnotation && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block2;
                }
                return false;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<String>> getStringAnnotations(int start, int end) {
        List<Range<? extends Annotation>> list = this.annotations;
        if (list != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Annotation>> $this$fastFilteredMap$iv = list;
            ArrayList target$iv = new ArrayList($this$fastFilteredMap$iv.size());
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object object = $this$fastForEach$iv$iv.get(index$iv$iv);
                Object it$iv = object;
                Range it = (Range)object;
                if (!(it.getItem() instanceof StringAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                it = (Range)it$iv;
                object = target$iv;
                object.add(StringAnnotationKt.unbox(it));
            }
            return target$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start, int end) {
        List list;
        List<Range<? extends Annotation>> list2 = this.annotations;
        if (list2 != null) {
            void $this$fastForEach$iv$iv;
            List<Range<? extends Annotation>> $this$fastFilter$iv = list2;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Range it = (Range)e;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list = target$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list;
    }

    public final boolean hasLinkAnnotations(int start, int end) {
        boolean bl;
        block2: {
            List<Range<? extends Annotation>> list = this.annotations;
            if (list != null) {
                List<Range<? extends Annotation>> $this$fastForEach$iv$iv = list;
                $this$fastForEach$iv$iv = list;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Annotation> range = $this$fastForEach$iv$iv.get(index$iv$iv);
                    Range<? extends Annotation> range2 = range;
                    range2 = range;
                    Range<? extends Annotation> it = range;
                    if (!(range.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block2;
                }
                return false;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)var1_1).annotations);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.text.hashCode();
        List<Range<? extends Annotation>> list = this.annotations;
        var1_1 = var1_1 * 31 + (list != null ? ((Object)list).hashCode() : 0);
        return (int)var1_1;
    }

    @Override
    public final String toString() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasEqualAnnotations(AnnotatedString other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual(this.annotations, var1_1.annotations);
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString mapAnnotations(Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Builder builder = new Builder(this);
        builder.mapAnnotations$ui_text((Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>>)var1_1);
        return var2_2.toAnnotatedString();
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotatedString flatMapAnnotations(Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Builder builder = new Builder(this);
        builder.flatMapAnnotations$ui_text((Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>>)var1_1);
        return var2_2.toAnnotatedString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Annotation;", "", "Landroidx/compose/ui/text/Bullet;", "Landroidx/compose/ui/text/LinkAnnotation;", "Landroidx/compose/ui/text/ParagraphStyle;", "Landroidx/compose/ui/text/SpanStyle;", "Landroidx/compose/ui/text/StringAnnotation;", "Landroidx/compose/ui/text/TtsAnnotation;", "Landroidx/compose/ui/text/UrlAnnotation;"})
    public static interface Annotation {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002DEB\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\f\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\f\u0010\u000fJ)\u0010\f\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\u0012J\u0017\u0010\f\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\f\u0010\u0015J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\tJ%\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\u0016J%\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010%\u001a\u00020\u00032\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u000b\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0007\u00a2\u0006\u0004\b)\u0010*J3\u00101\u001a\u00020\u000b2\"\u0010.\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,0+H\u0000\u00a2\u0006\u0004\b/\u00100J9\u00104\u001a\u00020\u000b2(\u0010.\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,020+H\u0000\u00a2\u0006\u0004\b3\u00100R\u0018\u0010\b\u001a\u000605j\u0002`68\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00107R\"\u0010;\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020:09088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\"\u0010=\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-09088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u0011\u0010@\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010B\u001a\u00020A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010C"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "", "capacity", "<init>", "(I)V", "Landroidx/compose/ui/text/AnnotatedString;", "text", "(Landroidx/compose/ui/text/AnnotatedString;)V", "", "", "append", "(Ljava/lang/String;)V", "", "(Ljava/lang/CharSequence;)Landroidx/compose/ui/text/AnnotatedString$Builder;", "start", "end", "(Ljava/lang/CharSequence;II)Landroidx/compose/ui/text/AnnotatedString$Builder;", "", "char", "(C)Landroidx/compose/ui/text/AnnotatedString$Builder;", "(Landroidx/compose/ui/text/AnnotatedString;II)V", "Landroidx/compose/ui/text/SpanStyle;", "style", "addStyle", "(Landroidx/compose/ui/text/SpanStyle;II)V", "tag", "annotation", "addStringAnnotation", "(Ljava/lang/String;Ljava/lang/String;II)V", "pushStyle", "(Landroidx/compose/ui/text/SpanStyle;)I", "pushStringAnnotation", "(Ljava/lang/String;Ljava/lang/String;)I", "Landroidx/compose/ui/text/LinkAnnotation;", "link", "pushLink", "(Landroidx/compose/ui/text/LinkAnnotation;)I", "pop", "()V", "toAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "transform", "mapAnnotations$ui_text", "(Lkotlin/jvm/functions/Function1;)V", "mapAnnotations", "", "flatMapAnnotations$ui_text", "flatMapAnnotations", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "styleStack", "Ljava/util/List;", "annotations", "getLength", "()I", "length", "Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;", "bulletScope", "Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;", "MutableRange", "BulletScope"})
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n35#2,5:1623\n35#2,5:1628\n151#2,2:1645\n35#2,5:1647\n153#2:1652\n530#2,2:1653\n35#2,3:1655\n532#2:1658\n151#2,2:1659\n35#2,5:1661\n153#2:1666\n533#2,2:1667\n39#2:1669\n535#2:1670\n81#3,4:1633\n81#3,4:1637\n81#3,4:1641\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n544#1:1623,5\n563#1:1628,5\n1003#1:1645,2\n1003#1:1647,5\n1003#1:1652\n1020#1:1653,2\n1020#1:1655,3\n1020#1:1658\n1021#1:1659,2\n1021#1:1661,5\n1021#1:1666\n1020#1:1667,2\n1020#1:1669\n1020#1:1670\n833#1:1633,4\n974#1:1637,4\n991#1:1641,4\n*E\n"})
    public static final class Builder
    implements Appendable {
        private final StringBuilder text;
        private final List<MutableRange<? extends Object>> styleStack;
        private final List<MutableRange<? extends Annotation>> annotations;
        private final BulletScope bulletScope;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public Builder(int capacity) {
            void var1_1;
            this.text = new StringBuilder((int)var1_1);
            this.styleStack = new ArrayList();
            this.annotations = new ArrayList();
            this.bulletScope = new BulletScope(this);
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(AnnotatedString text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append((AnnotatedString)var1_1);
        }

        public final int getLength() {
            return this.text.length();
        }

        /*
         * WARNING - void declaration
         */
        public final void append(String text) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(CharSequence text) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text);
            } else {
                void var1_1;
                this.text.append((CharSequence)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(CharSequence text, int start, int end) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text, start, end);
            } else {
                void var3_3;
                void var2_2;
                void var1_1;
                this.text.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder append(char c) {
            void var1_1;
            this.text.append((char)var1_1);
            return this;
        }

        public final void append(AnnotatedString text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            List<Range<? extends Annotation>> list = text.getAnnotations$ui_text();
            if (list != null) {
                List<Range<? extends Annotation>> $this$fastForEach$iv = list;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Range<? extends Annotation> range;
                    Range<? extends Annotation> it = range = $this$fastForEach$iv.get(index$iv);
                    this.annotations.add(new MutableRange<Annotation>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
                return;
            }
        }

        public final void append(AnnotatedString text, int start, int end) {
            int n;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int insertionStart = this.text.length();
            this.text.append(text.getText(), start, end);
            List list = AnnotatedStringKt.getLocalAnnotations$default(text, start, n, null, 4, null);
            if (list != null) {
                List $this$fastForEach$iv = list;
                n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Object e = $this$fastForEach$iv.get(index$iv);
                    Range it = (Range)e;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addStyle(SpanStyle style, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.annotations.add(new MutableRange(var1_1, (int)var2_2, (int)var3_3, null, 8, null));
        }

        /*
         * WARNING - void declaration
         */
        public final void addStringAnnotation(String tag, String annotation, int start, int end) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableRange<StringAnnotation>(StringAnnotation.box-impl(StringAnnotation.constructor-impl((String)var2_2)), (int)var3_3, end, (String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStyle(SpanStyle style) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = new MutableRange(style, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Annotation>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushStringAnnotation(String tag, String annotation) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange it = new MutableRange(StringAnnotation.box-impl(StringAnnotation.constructor-impl((String)var2_2)), this.text.length(), 0, tag, 4, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Annotation>)var1_1);
            return this.styleStack.size() - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int pushLink(LinkAnnotation link) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            MutableRange it = new MutableRange(link, this.text.length(), 0, null, 12, null);
            this.styleStack.add(it);
            this.annotations.add((MutableRange<? extends Annotation>)var1_1);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            boolean bl = !((Collection)this.styleStack).isEmpty();
            if (!bl) {
                InlineClassHelperKt.throwIllegalStateException("Nothing to pop.");
            }
            MutableRange<? extends Object> mutableRange = this.styleStack.remove(this.styleStack.size() - 1);
            mutableRange.setEnd(this.text.length());
        }

        /*
         * WARNING - void declaration
         */
        public final AnnotatedString toAnnotatedString() {
            String string;
            void $this$fastForEach$iv$iv;
            void $this$fastMap$iv;
            String string2 = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            List list = this.annotations;
            String string3 = string2;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                void it;
                Object e;
                Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
                it$iv = (MutableRange)it$iv;
                Collection collection = target$iv;
                collection.add(it.toRange(this.text.length()));
            }
            list = (List)((Object)string);
            string = string3;
            return new AnnotatedString(string, list);
        }

        public final void mapAnnotations$ui_text(Function1<? super Range<? extends Annotation>, ? extends Range<? extends Annotation>> transform) {
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            int n = ((Collection)this.annotations).size();
            for (int i = 0; i < n; ++i) {
                Range newAnnotation = (Range)transform.invoke((Object)MutableRange.toRange$default(this.annotations.get(i), 0, 1, null));
                this.annotations.set(i, MutableRange.Companion.fromRange(newAnnotation));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void flatMapAnnotations$ui_text(Function1<? super Range<? extends Annotation>, ? extends List<? extends Range<? extends Annotation>>> transform) {
            void var1_1;
            void var3_3;
            void $this$fastForEach$iv$iv;
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            List<MutableRange<? extends Annotation>> $this$fastFlatMap$iv = this.annotations;
            ArrayList target$iv = new ArrayList($this$fastFlatMap$iv.size());
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object e = $this$fastForEach$iv$iv.get(index$iv$iv);
                Object e2 = e;
                e2 = e;
                MutableRange annotation = (MutableRange)e;
                List $this$fastMap$iv = (List)transform.invoke((Object)MutableRange.toRange$default(annotation, 0, 1, null));
                ArrayList target$iv2 = new ArrayList($this$fastMap$iv.size());
                List $this$fastForEach$iv$iv2 = $this$fastMap$iv;
                int n2 = ((Collection)$this$fastForEach$iv$iv2).size();
                for (int index$iv$iv2 = 0; index$iv$iv2 < n2; ++index$iv$iv2) {
                    void it;
                    Object e3;
                    Object it$iv = e3 = $this$fastForEach$iv$iv2.get(index$iv$iv2);
                    it$iv = (Range)it$iv;
                    Collection collection = target$iv2;
                    collection.add(MutableRange.Companion.fromRange(it));
                }
                Iterable list$iv = target$iv2;
                CollectionsKt.addAll((Collection)target$iv, (Iterable)list$iv);
            }
            List replacedAnnotations = (List)var3_3;
            this.annotations.clear();
            this.annotations.addAll((Collection)var1_1);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u00028\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0006R&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$BulletScope;", "", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "builder", "<init>", "(Landroidx/compose/ui/text/AnnotatedString$Builder;)V", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "", "Lkotlin/Pair;", "Landroidx/compose/ui/unit/TextUnit;", "Landroidx/compose/ui/text/Bullet;", "bulletListSettingStack", "Ljava/util/List;"})
        public static final class BulletScope {
            public final Builder builder;
            public final List<Pair<TextUnit, Bullet>> bulletListSettingStack;
            public static final int $stable = 8;

            /*
             * WARNING - void declaration
             */
            public BulletScope(Builder builder) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                this.builder = var1_1;
                this.bulletListSettingStack = new ArrayList();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0083\b\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB+\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00028\u00008\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u001c\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001b"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "", "start", "end", "", "tag", "<init>", "(Ljava/lang/Object;IILjava/lang/String;)V", "defaultEnd", "Landroidx/compose/ui/text/AnnotatedString$Range;", "toRange", "(I)Landroidx/compose/ui/text/AnnotatedString$Range;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "I", "setEnd", "(I)V", "Ljava/lang/String;", "Companion"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n81#2,4:1623\n81#2,4:1627\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n*L\n418#1:1623,4\n429#1:1627,4\n*E\n"})
        private static final class MutableRange<T> {
            public static final Companion Companion = new Companion(null);
            public final T item;
            public final int start;
            private int end;
            public final String tag;

            /*
             * WARNING - void declaration
             */
            public MutableRange(T item, int start, int end, String tag) {
                void var3_3;
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = var1_1;
                this.start = var2_2;
                this.end = var3_3;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            /*
             * WARNING - void declaration
             */
            public final void setEnd(int n) {
                void var1_1;
                this.end = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Range<T> toRange(int defaultEnd) {
                void var1_1;
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean bl = end != Integer.MIN_VALUE;
                if (!bl) {
                    InlineClassHelperKt.throwIllegalStateException("Item.end should be set first");
                }
                return new Range<T>(this.item, this.start, (int)var1_1, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
            }

            public final int hashCode() {
                int n = this.item == null ? 0 : this.item.hashCode();
                n = n * 31 + Integer.hashCode(this.start);
                n = n * 31 + Integer.hashCode(this.end);
                n = n * 31 + this.tag.hashCode();
                return n;
            }

            public final boolean equals(Object other) {
                MutableRange mutableRange;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                mutableRange = mutableRange;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\"\u0004\b\u0001\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\t"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange$Companion;", "", "<init>", "()V", "T", "Landroidx/compose/ui/text/AnnotatedString$Range;", "range", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "fromRange", "(Landroidx/compose/ui/text/AnnotatedString$Range;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;"})
            public static final class Companion {
                private Companion() {
                }

                /*
                 * WARNING - void declaration
                 */
                public final <T> MutableRange<T> fromRange(Range<T> range) {
                    void var1_1;
                    Intrinsics.checkNotNullParameter(range, (String)"range");
                    return new MutableRange<T>(range.getItem(), range.getStart(), range.getEnd(), var1_1.getTag());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Companion;", "", "<init>", "()V", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/ui/text/AnnotatedString;", "Saver", "Landroidx/compose/runtime/saveable/Saver;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\f\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ>\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u000fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001e\u0010\u000fR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0019"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "", "start", "end", "", "tag", "<init>", "(Ljava/lang/Object;IILjava/lang/String;)V", "(Ljava/lang/Object;II)V", "component1", "()Ljava/lang/Object;", "component2", "()I", "component3", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getItem", "I", "getStart", "getEnd", "Ljava/lang/String;", "getTag"})
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,1622:1\n118#2,4:1623\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n*L\n387#1:1623,4\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        private final String tag;

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end, String tag) {
            void var3_4;
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = var1_1;
            this.start = var2_3;
            this.end = var3_4;
            this.tag = tag;
            boolean bl = this.start <= this.end;
            if (!bl) {
                InlineClassHelperKt.throwIllegalArgumentException("Reversed range is not supported");
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final String getTag() {
            return this.tag;
        }

        /*
         * WARNING - void declaration
         */
        public Range(T item, int start, int end) {
            this(var1_1, (int)var2_2, (int)var3_3, "");
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        /*
         * WARNING - void declaration
         */
        public final Range<T> copy(T item, int start, int end, String tag) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<void>(var1_1, (int)var2_2, (int)var3_3, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        public final String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ")";
        }

        public final int hashCode() {
            int n = this.item == null ? 0 : this.item.hashCode();
            n = n * 31 + Integer.hashCode(this.start);
            n = n * 31 + Integer.hashCode(this.end);
            n = n * 31 + this.tag.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            Range range;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            range = range;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

