/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ViewportHint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b\u0080\b\u0018\u0000 (*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0001(B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB5\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J5\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010!R\u001f\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001f\u001a\u0004\b\"\u0010!R\u0017\u0010\u000b\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010#\u001a\u0004\b$\u0010\u0013R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010'"}, d2={"Landroidx/paging/TransformablePage;", "", "T", "", "originalPageOffset", "", "data", "<init>", "(ILjava/util/List;)V", "", "originalPageOffsets", "hintOriginalPageOffset", "hintOriginalIndices", "([ILjava/util/List;ILjava/util/List;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "index", "presentedItemsBefore", "presentedItemsAfter", "originalPageOffsetFirst", "originalPageOffsetLast", "Landroidx/paging/ViewportHint$Access;", "viewportHintFor", "(IIIII)Landroidx/paging/ViewportHint$Access;", "Ljava/util/List;", "getData", "()Ljava/util/List;", "getHintOriginalIndices", "I", "getHintOriginalPageOffset", "[I", "getOriginalPageOffsets", "()[I", "Companion"})
public final class TransformablePage<T> {
    public static final Companion Companion = new Companion(null);
    private final int[] originalPageOffsets;
    private final List<T> data;
    private final int hintOriginalPageOffset;
    private final List<Integer> hintOriginalIndices;
    private static final TransformablePage<Object> EMPTY_INITIAL_PAGE = new TransformablePage(0, CollectionsKt.emptyList());

    /*
     * WARNING - void declaration
     */
    public TransformablePage(int[] originalPageOffsets, List<? extends T> data, int hintOriginalPageOffset, List<Integer> hintOriginalIndices) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)originalPageOffsets, (String)"originalPageOffsets");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.originalPageOffsets = string;
        this.data = var2_2;
        this.hintOriginalPageOffset = var3_3;
        this.hintOriginalIndices = hintOriginalIndices;
        if (!(!(this.originalPageOffsets.length == 0))) {
            string = "originalPageOffsets cannot be empty when constructing TransformablePage";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.hintOriginalIndices == null || this.hintOriginalIndices.size() == this.data.size())) {
            StringBuilder stringBuilder = new StringBuilder("If originalIndices (size = ");
            List<Integer> list = this.hintOriginalIndices;
            Intrinsics.checkNotNull(list);
            string = stringBuilder.append(list.size()).append(") is provided, it must be same length as data (size = ").append(this.data.size()).append(')').toString();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int[] getOriginalPageOffsets() {
        return this.originalPageOffsets;
    }

    public final List<T> getData() {
        return this.data;
    }

    public final int getHintOriginalPageOffset() {
        return this.hintOriginalPageOffset;
    }

    public final List<Integer> getHintOriginalIndices() {
        return this.hintOriginalIndices;
    }

    /*
     * WARNING - void declaration
     */
    public TransformablePage(int originalPageOffset, List<? extends T> data) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = originalPageOffset;
        this(nArray2, (List<T>)var2_2, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final ViewportHint.Access viewportHintFor(int index, int presentedItemsBefore, int presentedItemsAfter, int originalPageOffsetFirst, int originalPageOffsetLast) {
        void var3_3;
        void var2_2;
        void var1_1;
        IntRange intRange = this.hintOriginalIndices;
        return new ViewportHint.Access(this.hintOriginalPageOffset, (intRange != null && (intRange = CollectionsKt.getIndices((Collection)((Collection)intRange))) != null ? intRange.contains(index) : false) ? ((Number)this.hintOriginalIndices.get(index)).intValue() : var1_1, (int)var2_2, (int)var3_3, originalPageOffsetFirst, originalPageOffsetLast);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformablePage cfr_ignored_0 = (TransformablePage)other;
        if (!Arrays.equals(this.originalPageOffsets, ((TransformablePage)other).originalPageOffsets)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.data, ((TransformablePage)other).data)) {
            return false;
        }
        if (this.hintOriginalPageOffset != ((TransformablePage)other).hintOriginalPageOffset) {
            return false;
        }
        return Intrinsics.areEqual(this.hintOriginalIndices, ((TransformablePage)var1_1).hintOriginalIndices);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = Arrays.hashCode(this.originalPageOffsets);
        result = result * 31 + ((Object)this.data).hashCode();
        result = result * 31 + this.hintOriginalPageOffset;
        List<Integer> list = this.hintOriginalIndices;
        var1_1 = var1_1 * 31 + (list != null ? ((Object)list).hashCode() : 0);
        return (int)var1_1;
    }

    public final String toString() {
        return "TransformablePage(originalPageOffsets=" + Arrays.toString(this.originalPageOffsets) + ", data=" + this.data + ", hintOriginalPageOffset=" + this.hintOriginalPageOffset + ", hintOriginalIndices=" + this.hintOriginalIndices + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Landroidx/paging/TransformablePage$Companion;", "", "<init>", "()V", "Landroidx/paging/TransformablePage;", "EMPTY_INITIAL_PAGE", "Landroidx/paging/TransformablePage;", "getEMPTY_INITIAL_PAGE", "()Landroidx/paging/TransformablePage;"})
    public static final class Companion {
        private Companion() {
        }

        public final TransformablePage<Object> getEMPTY_INITIAL_PAGE() {
            return EMPTY_INITIAL_PAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

