/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ItemSnapshotList;
import androidx.paging.LoadType;
import androidx.paging.PageEvent;
import androidx.paging.PagingDataEvent;
import androidx.paging.PlaceholderPaddedList;
import androidx.paging.TransformablePage;
import androidx.paging.ViewportHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0006\b\u0001\u0018\u0000 C*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001CB\u0017\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B+\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010 J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J#\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J!\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000(\u00a2\u0006\u0004\b*\u0010+J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000,\u00a2\u0006\u0004\b-\u0010.J\u000f\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u00102\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bH\u0002\u00a2\u0006\u0004\b2\u00103R$\u00105\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b8\u0016@RX\u0097\u000e\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0014\u0010:\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00108R\u0014\u0010<\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00108R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010>R$\u0010\r\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b8\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\r\u00106\u001a\u0004\b?\u00108R$\u0010\f\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b8\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\f\u00106\u001a\u0004\b@\u00108R\u0014\u0010B\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u00108"}, d2={"Landroidx/paging/PageStore;", "", "T", "Landroidx/paging/PlaceholderPaddedList;", "Landroidx/paging/PageEvent$Insert;", "insertEvent", "<init>", "(Landroidx/paging/PageEvent$Insert;)V", "", "Landroidx/paging/TransformablePage;", "pages", "", "placeholdersBefore", "placeholdersAfter", "(Ljava/util/List;II)V", "index", "Landroidx/paging/ViewportHint$Access;", "accessHintForPresenterIndex", "(I)Landroidx/paging/ViewportHint$Access;", "", "checkIndex", "(I)V", "Landroidx/paging/PageEvent$Drop;", "drop", "Landroidx/paging/PagingDataEvent;", "dropPages", "(Landroidx/paging/PageEvent$Drop;)Landroidx/paging/PagingDataEvent;", "Lkotlin/ranges/IntRange;", "pageOffsetsToDrop", "dropPagesWithOffsets", "(Lkotlin/ranges/IntRange;)I", "get", "(I)Ljava/lang/Object;", "getItem", "Landroidx/paging/ViewportHint$Initial;", "initializeHint", "()Landroidx/paging/ViewportHint$Initial;", "insert", "insertPage", "(Landroidx/paging/PageEvent$Insert;)Landroidx/paging/PagingDataEvent;", "Landroidx/paging/PageEvent;", "pageEvent", "processEvent", "(Landroidx/paging/PageEvent;)Landroidx/paging/PagingDataEvent;", "Landroidx/paging/ItemSnapshotList;", "snapshot", "()Landroidx/paging/ItemSnapshotList;", "", "toString", "()Ljava/lang/String;", "fullCount", "(Ljava/util/List;)I", "<set-?>", "dataCount", "I", "getDataCount", "()I", "getOriginalPageOffsetFirst", "originalPageOffsetFirst", "getOriginalPageOffsetLast", "originalPageOffsetLast", "", "Ljava/util/List;", "getPlaceholdersAfter", "getPlaceholdersBefore", "getSize", "size", "Companion"})
@SourceDebugExtension(value={"SMAP\nPageStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageStore.kt\nandroidx/paging/PageStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,255:1\n1#2:256\n1360#3:257\n1446#3,5:258\n1360#3:263\n1446#3,5:264\n1360#3:269\n1446#3,5:270\n12774#4,2:275\n*S KotlinDebug\n*F\n+ 1 PageStore.kt\nandroidx/paging/PageStore\n*L\n79#1:257\n79#1:258,5\n168#1:263\n168#1:264,5\n183#1:269\n183#1:270,5\n200#1:275,2\n*E\n"})
public final class PageStore<T>
implements PlaceholderPaddedList<T> {
    public static final Companion Companion = new Companion(null);
    private final List<TransformablePage<T>> pages;
    private int dataCount;
    private int placeholdersBefore;
    private int placeholdersAfter;
    private static final PageStore<Object> INITIAL = new PageStore<Object>(PageEvent.Insert.Companion.getEMPTY_REFRESH_LOCAL());

    /*
     * WARNING - void declaration
     */
    public PageStore(List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        this.pages = CollectionsKt.toMutableList((Collection)pages);
        this.dataCount = this.fullCount((List<TransformablePage<T>>)var1_1);
        this.placeholdersBefore = var2_2;
        this.placeholdersAfter = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public PageStore(PageEvent.Insert<T> insertEvent) {
        void var1_1;
        Intrinsics.checkNotNullParameter(insertEvent, (String)"insertEvent");
        this(insertEvent.getPages(), insertEvent.getPlaceholdersBefore(), var1_1.getPlaceholdersAfter());
    }

    @Override
    public final int getDataCount() {
        return this.dataCount;
    }

    private final int getOriginalPageOffsetFirst() {
        Integer n = ArraysKt.minOrNull((int[])((TransformablePage)CollectionsKt.first(this.pages)).getOriginalPageOffsets());
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    private final int getOriginalPageOffsetLast() {
        Integer n = ArraysKt.maxOrNull((int[])((TransformablePage)CollectionsKt.last(this.pages)).getOriginalPageOffsets());
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    @Override
    public final int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    @Override
    public final int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            void var1_1;
            throw new IndexOutOfBoundsException("Index: " + (int)var1_1 + ", Size: " + this.getSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_2;
        int n = this.getDataCount();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            void it;
            int n2 = i;
            ArrayList<T> arrayList2 = arrayList;
            arrayList2.add(this.getItem((int)it));
        }
        String items = CollectionsKt.joinToString$default((Iterable)arrayList, null, null, null, (int)0, null, null, (int)63, null);
        return "[(" + this.getPlaceholdersBefore() + " placeholders), " + (String)var1_2 + ", (" + this.getPlaceholdersAfter() + " placeholders)]";
    }

    /*
     * WARNING - void declaration
     */
    public final T get(int index) {
        void var1_1;
        this.checkIndex(index);
        int localIndex = index - this.getPlaceholdersBefore();
        if (localIndex < 0 || localIndex >= this.getDataCount()) {
            return null;
        }
        return this.getItem((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ItemSnapshotList<T> snapshot() {
        void var2_4;
        Object object = this.pages;
        int n = this.getPlaceholdersAfter();
        int n2 = this.getPlaceholdersBefore();
        Collection destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (TransformablePage)object2;
            Iterable list$iv$iv = ((TransformablePage)object2).getData();
            CollectionsKt.addAll((Collection)destination$iv$iv, object2);
        }
        object = (List)var2_4;
        int n3 = n;
        int n4 = n2;
        return new ItemSnapshotList(n4, n3, object);
    }

    /*
     * WARNING - void declaration
     */
    public final T getItem(int index) {
        void var1_1;
        void var2_2;
        void indexInPage;
        int pageSize;
        int localPageCount = this.pages.size();
        for (int pageIndex = 0; pageIndex < localPageCount && (pageSize = this.pages.get(pageIndex).getData().size()) <= indexInPage; indexInPage -= pageSize, ++pageIndex) {
        }
        return this.pages.get((int)var2_2).getData().get((int)var1_1);
    }

    @Override
    public final int getSize() {
        return this.getPlaceholdersBefore() + this.getDataCount() + this.getPlaceholdersAfter();
    }

    /*
     * WARNING - void declaration
     */
    private final int fullCount(List<TransformablePage<T>> $this$fullCount) {
        Object object = $this$fullCount;
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            void var2_3;
            Object e = object.next();
            TransformablePage it = (TransformablePage)e;
            int n2 = n;
            n = var2_3.getData().size();
            n = n2 + n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final PagingDataEvent<T> processEvent(PageEvent<T> pageEvent) {
        Intrinsics.checkNotNullParameter(pageEvent, (String)"pageEvent");
        PageEvent<T> pageEvent2 = pageEvent;
        if (pageEvent2 instanceof PageEvent.Insert) {
            return this.insertPage((PageEvent.Insert)pageEvent);
        }
        if (pageEvent2 instanceof PageEvent.Drop) {
            void var1_1;
            return this.dropPages((PageEvent.Drop)var1_1);
        }
        throw new IllegalStateException("Paging received an event to process StaticList or LoadStateUpdate while\nprocessing Inserts and Drops. If you see this exception, it is most\nlikely a bug in the library. Please file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
    }

    /*
     * WARNING - void declaration
     */
    public final ViewportHint.Initial initializeHint() {
        void var1_1;
        int presentedItems = this.getDataCount();
        return new ViewportHint.Initial(presentedItems / 2, (int)(var1_1 / 2), this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    /*
     * WARNING - void declaration
     */
    public final ViewportHint.Access accessHintForPresenterIndex(int index) {
        void var1_1;
        void var3_3;
        void var2_2;
        int pageIndex = 0;
        for (int indexInPage = index - this.getPlaceholdersBefore(); indexInPage >= this.pages.get(pageIndex).getData().size() && pageIndex < CollectionsKt.getLastIndex(this.pages); indexInPage -= this.pages.get(pageIndex).getData().size(), ++pageIndex) {
        }
        return this.pages.get((int)var2_2).viewportHintFor((int)var3_3, index - this.getPlaceholdersBefore(), this.getSize() - var1_1 - this.getPlaceholdersAfter() - 1, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    /*
     * WARNING - void declaration
     */
    private final PagingDataEvent<T> insertPage(PageEvent.Insert<T> insert) {
        int insertSize = this.fullCount(((PageEvent.Insert)insert).getPages());
        switch (WhenMappings.$EnumSwitchMapping$0[((PageEvent.Insert)insert).getLoadType().ordinal()]) {
            case 1: {
                throw new IllegalStateException("Paging received a refresh event in the middle of an actively loading generation\nof PagingData. If you see this exception, it is most likely a bug in the library.\nPlease file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
            }
            case 2: {
                Object $this$flatMapTo$iv$iv22;
                int oldPlaceholdersBefore22 = this.getPlaceholdersBefore();
                this.pages.addAll(0, ((PageEvent.Insert)insert).getPages());
                this.dataCount = this.getDataCount() + insertSize;
                this.placeholdersBefore = ((PageEvent.Insert)insert).getPlaceholdersBefore();
                Iterable<Object> iterable = ((PageEvent.Insert)insert).getPages();
                insert = iterable;
                Collection destination$iv$iv22 = new ArrayList();
                $this$flatMapTo$iv$iv22 = $this$flatMapTo$iv$iv22.iterator();
                while ($this$flatMapTo$iv$iv22.hasNext()) {
                    iterable = $this$flatMapTo$iv$iv22.next();
                    TransformablePage transformablePage = (TransformablePage)((Object)iterable);
                    Iterable list$iv$iv = transformablePage.getData();
                    CollectionsKt.addAll((Collection)destination$iv$iv22, (Iterable)list$iv$iv);
                }
                int $this$flatMapTo$iv$iv22 = oldPlaceholdersBefore22;
                int destination$iv$iv22 = this.getPlaceholdersBefore();
                List oldPlaceholdersBefore22 = (List)destination$iv$iv22;
                return new PagingDataEvent.Prepend(oldPlaceholdersBefore22, destination$iv$iv22, $this$flatMapTo$iv$iv22);
            }
            case 3: {
                void var3_11;
                List list;
                TransformablePage $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void destination$iv$iv22;
                Object $this$flatMapTo$iv$iv22;
                int oldPlaceholdersAfter = this.getPlaceholdersAfter();
                int oldDataCount = this.getDataCount();
                this.pages.addAll(this.pages.size(), ((PageEvent.Insert)$this$flatMapTo$iv$iv22).getPages());
                this.dataCount = this.getDataCount() + destination$iv$iv22;
                this.placeholdersAfter = ((PageEvent.Insert)$this$flatMapTo$iv$iv22).getPlaceholdersAfter();
                $this$flatMapTo$iv$iv22 = ((PageEvent.Insert)$this$flatMapTo$iv$iv22).getPages();
                int n = this.getPlaceholdersBefore() + oldDataCount;
                destination$iv$iv22 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void var2_7;
                    Object t = iterator.next();
                    $this$flatMapTo$iv$iv = (TransformablePage)t;
                    Iterable list$iv$iv = $this$flatMapTo$iv$iv.getData();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)var2_7);
                }
                list = list;
                void var1_3 = var3_11;
                int n2 = this.getPlaceholdersAfter();
                List list2 = list;
                int n3 = n;
                return new PagingDataEvent.Append(n3, list2, n2, (int)var1_3);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final int dropPagesWithOffsets(IntRange pageOffsetsToDrop) {
        void var2_2;
        int removeCount = 0;
        Iterator<TransformablePage<T>> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            boolean bl;
            TransformablePage<T> page;
            block2: {
                page = pageIterator.next();
                for (int n : page.getOriginalPageOffsets()) {
                    int it = n;
                    if (!pageOffsetsToDrop.contains(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            removeCount += page.getData().size();
            pageIterator.remove();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final PagingDataEvent<T> dropPages(PageEvent.Drop<T> drop) {
        void var3_4;
        void var1_1;
        void var2_2;
        int itemDropCount = this.dropPagesWithOffsets(new IntRange(drop.getMinPageOffset(), drop.getMaxPageOffset()));
        this.dataCount = this.getDataCount() - itemDropCount;
        if (drop.getLoadType() == LoadType.PREPEND) {
            int oldPlaceholdersBefore = this.getPlaceholdersBefore();
            this.placeholdersBefore = drop.getPlaceholdersRemaining();
            return new PagingDataEvent.DropPrepend(itemDropCount, this.getPlaceholdersBefore(), oldPlaceholdersBefore);
        }
        int oldPlaceholdersAfter = this.getPlaceholdersAfter();
        this.placeholdersAfter = drop.getPlaceholdersRemaining();
        return new PagingDataEvent.DropAppend(this.getPlaceholdersBefore() + this.getDataCount(), (int)var2_2, var1_1.getPlaceholdersRemaining(), (int)var3_4);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\"\b\b\u0001\u0010\u0004*\u00020\u00012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f"}, d2={"Landroidx/paging/PageStore$Companion;", "", "<init>", "()V", "T", "Landroidx/paging/PageEvent$Insert;", "event", "Landroidx/paging/PageStore;", "initial$paging_common", "(Landroidx/paging/PageEvent$Insert;)Landroidx/paging/PageStore;", "initial", "INITIAL", "Landroidx/paging/PageStore;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final <T> PageStore<T> initial$paging_common(PageEvent.Insert<T> event) {
            if (event != null) {
                void var1_1;
                return new PageStore(var1_1);
            }
            PageStore pageStore = INITIAL;
            Intrinsics.checkNotNull((Object)pageStore, (String)"null cannot be cast to non-null type androidx.paging.PageStore<T of androidx.paging.PageStore.Companion.initial>");
            return pageStore;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LoadType.PREPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LoadType.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

