/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.MutableLoadStateCollection;
import androidx.paging.PageEvent;
import androidx.paging.TransformablePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)"}, d2={"Landroidx/paging/FlattenedPageEventStorage;", "", "T", "<init>", "()V", "Landroidx/paging/PageEvent;", "event", "", "add", "(Landroidx/paging/PageEvent;)V", "", "getAsEvents", "()Ljava/util/List;", "Landroidx/paging/PageEvent$Insert;", "handleInsert", "(Landroidx/paging/PageEvent$Insert;)V", "Landroidx/paging/PageEvent$LoadStateUpdate;", "handleLoadStateUpdate", "(Landroidx/paging/PageEvent$LoadStateUpdate;)V", "Landroidx/paging/PageEvent$Drop;", "handlePageDrop", "(Landroidx/paging/PageEvent$Drop;)V", "Landroidx/paging/PageEvent$StaticList;", "handleStaticList", "(Landroidx/paging/PageEvent$StaticList;)V", "Landroidx/paging/LoadStates;", "mediatorStates", "Landroidx/paging/LoadStates;", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/TransformablePage;", "pages", "Lkotlin/collections/ArrayDeque;", "", "placeholdersAfter", "I", "placeholdersBefore", "", "receivedFirstEvent", "Z", "Landroidx/paging/MutableLoadStateCollection;", "sourceStates", "Landroidx/paging/MutableLoadStateCollection;"})
@SourceDebugExtension(value={"SMAP\nCachedPageEventFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedPageEventFlow.kt\nandroidx/paging/FlattenedPageEventStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1#2:282\n1855#3,2:283\n*S KotlinDebug\n*F\n+ 1 CachedPageEventFlow.kt\nandroidx/paging/FlattenedPageEventStorage\n*L\n222#1:283,2\n*E\n"})
public final class FlattenedPageEventStorage<T> {
    private int placeholdersBefore;
    private int placeholdersAfter;
    private final ArrayDeque<TransformablePage<T>> pages = new ArrayDeque();
    private final MutableLoadStateCollection sourceStates = new MutableLoadStateCollection();
    private LoadStates mediatorStates;
    private boolean receivedFirstEvent;

    /*
     * WARNING - void declaration
     */
    public final void add(PageEvent<T> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.receivedFirstEvent = true;
        PageEvent<T> pageEvent = event;
        if (pageEvent instanceof PageEvent.Insert) {
            this.handleInsert((PageEvent.Insert)event);
            return;
        }
        if (pageEvent instanceof PageEvent.Drop) {
            this.handlePageDrop((PageEvent.Drop)event);
            return;
        }
        if (pageEvent instanceof PageEvent.LoadStateUpdate) {
            this.handleLoadStateUpdate((PageEvent.LoadStateUpdate)event);
            return;
        }
        if (pageEvent instanceof PageEvent.StaticList) {
            void var1_1;
            this.handleStaticList((PageEvent.StaticList)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePageDrop(PageEvent.Drop<T> event2) {
        this.sourceStates.set(event2.getLoadType(), LoadState.NotLoading.Companion.getIncomplete$paging_common());
        switch (WhenMappings.$EnumSwitchMapping$0[event2.getLoadType().ordinal()]) {
            case 1: {
                this.placeholdersBefore = event2.getPlaceholdersRemaining();
                int event2 = event2.getPageCount();
                for (int i = 0; i < event2; ++i) {
                    this.pages.removeFirst();
                }
                break;
            }
            case 2: {
                void var1_1;
                PageEvent.Drop<T> event2;
                this.placeholdersAfter = event2.getPlaceholdersRemaining();
                int n = var1_1.getPageCount();
                for (int i = 0; i < n; ++i) {
                    this.pages.removeLast();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Page drop type must be prepend or append");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInsert(PageEvent.Insert<T> event) {
        this.sourceStates.set(event.getSourceLoadStates());
        this.mediatorStates = event.getMediatorLoadStates();
        switch (WhenMappings.$EnumSwitchMapping$0[event.getLoadType().ordinal()]) {
            case 3: {
                this.pages.clear();
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.placeholdersBefore = event.getPlaceholdersBefore();
                this.pages.addAll((Collection)event.getPages());
                return;
            }
            case 1: {
                this.placeholdersBefore = event.getPlaceholdersBefore();
                Object object = (Iterable)RangesKt.downTo((int)(event.getPages().size() - 1), (int)0);
                object = object.iterator();
                while (object.hasNext()) {
                    void var3_3;
                    int it = ((IntIterator)object).nextInt();
                    this.pages.addFirst(event.getPages().get((int)var3_3));
                }
                return;
            }
            case 2: {
                void var1_1;
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.pages.addAll((Collection)var1_1.getPages());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleLoadStateUpdate(PageEvent.LoadStateUpdate<T> event) {
        void var1_1;
        this.sourceStates.set(event.getSource());
        this.mediatorStates = var1_1.getMediator();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleStaticList(PageEvent.StaticList<T> event) {
        void var1_1;
        if (event.getSourceLoadStates() != null) {
            this.sourceStates.set(event.getSourceLoadStates());
        }
        if (event.getMediatorLoadStates() != null) {
            this.mediatorStates = event.getMediatorLoadStates();
        }
        this.pages.clear();
        this.placeholdersAfter = 0;
        this.placeholdersBefore = 0;
        this.pages.add(new TransformablePage(0, var1_1.getData()));
    }

    /*
     * WARNING - void declaration
     */
    public final List<PageEvent<T>> getAsEvents() {
        void var1_1;
        if (!this.receivedFirstEvent) {
            return CollectionsKt.emptyList();
        }
        List events = new ArrayList();
        LoadStates source = this.sourceStates.snapshot();
        if (!((Collection)this.pages).isEmpty()) {
            events.add(PageEvent.Insert.Companion.Refresh(CollectionsKt.toList((Iterable)((Iterable)this.pages)), this.placeholdersBefore, this.placeholdersAfter, source, this.mediatorStates));
        } else {
            void var2_2;
            events.add(new PageEvent.LoadStateUpdate((LoadStates)var2_2, this.mediatorStates));
        }
        return var1_1;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.PREPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LoadType.APPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LoadType.REFRESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

