/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.PagingState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001:\u000245B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0005J\u0015\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0005J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0018\u00010\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010!\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001c\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R&\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010+0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\"\u0010.\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103"}, d2={"Landroidx/paging/AccessorState;", "", "Key", "Value", "<init>", "()V", "Landroidx/paging/LoadType;", "loadType", "Landroidx/paging/PagingState;", "pagingState", "", "add", "(Landroidx/paging/LoadType;Landroidx/paging/PagingState;)Z", "", "clearErrors", "clearPendingRequest", "(Landroidx/paging/LoadType;)V", "clearPendingRequests", "Landroidx/paging/LoadStates;", "computeLoadStates", "()Landroidx/paging/LoadStates;", "Landroidx/paging/LoadState;", "computeLoadTypeState", "(Landroidx/paging/LoadType;)Landroidx/paging/LoadState;", "Lkotlin/Pair;", "getPendingBoundary", "()Lkotlin/Pair;", "getPendingRefresh", "()Landroidx/paging/PagingState;", "Landroidx/paging/AccessorState$BlockState;", "state", "setBlockState", "(Landroidx/paging/LoadType;Landroidx/paging/AccessorState$BlockState;)V", "Landroidx/paging/LoadState$Error;", "errorState", "setError", "(Landroidx/paging/LoadType;Landroidx/paging/LoadState$Error;)V", "", "blockStates", "[Landroidx/paging/AccessorState$BlockState;", "errors", "[Landroidx/paging/LoadState$Error;", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/AccessorState$PendingRequest;", "pendingRequests", "Lkotlin/collections/ArrayDeque;", "refreshAllowed", "Z", "getRefreshAllowed", "()Z", "setRefreshAllowed", "(Z)V", "BlockState", "PendingRequest"})
@SourceDebugExtension(value={"SMAP\nRemoteMediatorAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n1747#2,3:461\n288#2,2:464\n288#2,2:466\n288#2,2:468\n*S KotlinDebug\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n*L\n133#1:461,3\n173#1:464,2\n220#1:466,2\n224#1:468,2\n*E\n"})
final class AccessorState<Key, Value> {
    private final BlockState[] blockStates;
    private final LoadState.Error[] errors;
    private final ArrayDeque<PendingRequest<Key, Value>> pendingRequests;
    private boolean refreshAllowed;

    public AccessorState() {
        int n;
        int n2 = 0;
        int n3 = LoadType.values().length;
        Object[] objectArray = new BlockState[n3];
        AccessorState accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = BlockState.UNBLOCKED;
        }
        accessorState.blockStates = objectArray;
        n2 = 0;
        n3 = LoadType.values().length;
        objectArray = new LoadState.Error[n3];
        accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = null;
        }
        accessorState.errors = objectArray;
        this.pendingRequests = new ArrayDeque();
    }

    public final boolean getRefreshAllowed() {
        return this.refreshAllowed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRefreshAllowed(boolean bl) {
        void var1_1;
        this.refreshAllowed = var1_1;
    }

    public final LoadStates computeLoadStates() {
        LoadState loadState = this.computeLoadTypeState(LoadType.REFRESH);
        LoadState loadState2 = this.computeLoadTypeState(LoadType.APPEND);
        LoadState loadState3 = this.computeLoadTypeState(LoadType.PREPEND);
        return new LoadStates(loadState, loadState3, loadState2);
    }

    /*
     * WARNING - void declaration
     */
    private final LoadState computeLoadTypeState(LoadType loadType) {
        void var2_2;
        boolean bl;
        BlockState blockState = this.blockStates[loadType.ordinal()];
        Iterable $this$any$iv = (Iterable)this.pendingRequests;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(((PendingRequest)(object = (PendingRequest)object)).getLoadType() == loadType)) continue;
                bl = true;
                break;
            }
        } else {
            boolean bl2;
            bl = bl2 = false;
        }
        if (bl && blockState != BlockState.REQUIRES_REFRESH) {
            return LoadState.Loading.INSTANCE;
        }
        LoadState.Error error = this.errors[loadType.ordinal()];
        if (error != null) {
            return error;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[var2_2.ordinal()]) {
            case 1: {
                void var1_1;
                return WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()] == 1 ? LoadState.NotLoading.Companion.getIncomplete$paging_common() : LoadState.NotLoading.Companion.getComplete$paging_common();
            }
            case 2: {
                return LoadState.NotLoading.Companion.getIncomplete$paging_common();
            }
            case 3: {
                return LoadState.NotLoading.Companion.getIncomplete$paging_common();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(LoadType loadType, PagingState<Key, Value> pagingState) {
        Object v0;
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            object = (Iterable)this.pendingRequests;
            object = object.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                PendingRequest pendingRequest = (PendingRequest)element$iv;
                if (!(pendingRequest.getLoadType() == loadType)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PendingRequest existing = v0;
        if (existing != null) {
            existing.setPagingState(pagingState);
            return false;
        }
        BlockState blockState = this.blockStates[loadType.ordinal()];
        if (blockState == BlockState.REQUIRES_REFRESH && loadType != LoadType.REFRESH) {
            this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState));
            return false;
        }
        if (object != BlockState.UNBLOCKED && loadType != LoadType.REFRESH) {
            return false;
        }
        if (loadType == LoadType.REFRESH) {
            this.setError(LoadType.REFRESH, null);
        }
        if (this.errors[loadType.ordinal()] == null) {
            void var2_2;
            void var1_1;
            return this.pendingRequests.add(new PendingRequest((LoadType)var1_1, var2_2));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBlockState(LoadType loadType, BlockState state) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.blockStates[var1_1.ordinal()] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final PagingState<Key, Value> getPendingRefresh() {
        Object v0;
        Object object;
        block2: {
            object = (Iterable)this.pendingRequests;
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                Object element$iv = object.next();
                PendingRequest pendingRequest = (PendingRequest)element$iv;
                if (!(pendingRequest.getLoadType() == LoadType.REFRESH)) continue;
                v0 = var2_2;
                break block2;
            }
            v0 = null;
        }
        object = v0;
        if (object != null) {
            return ((PendingRequest)object).getPagingState();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Pair<LoadType, PagingState<Key, Value>> getPendingBoundary() {
        Object v0;
        Object object;
        block2: {
            object = (Iterable)this.pendingRequests;
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                void var3_3;
                Object element$iv = object.next();
                PendingRequest it = (PendingRequest)element$iv;
                if (!(it.getLoadType() != LoadType.REFRESH && this.blockStates[var3_3.getLoadType().ordinal()] == BlockState.UNBLOCKED)) continue;
                v0 = var2_2;
                break block2;
            }
            v0 = null;
        }
        object = v0;
        if (object != null) {
            Object it = object;
            return TuplesKt.to((Object)((Object)((PendingRequest)it).getLoadType()), ((PendingRequest)object).getPagingState());
        }
        return null;
    }

    public final void clearPendingRequests() {
        this.pendingRequests.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearPendingRequest(LoadType loadType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        CollectionsKt.removeAll((List)((List)this.pendingRequests), (Function1)new Function1<PendingRequest<Key, Value>, Boolean>((LoadType)var1_1){
            final /* synthetic */ LoadType $loadType;
            {
                void var1_1;
                this.$loadType = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(PendingRequest<Key, Value> it) {
                void var1_1;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return var1_1.getLoadType() == this.$loadType;
            }
        });
    }

    public final void clearErrors() {
        int n = this.errors.length;
        for (int i = 0; i < n; ++i) {
            this.errors[i] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setError(LoadType loadType, LoadState.Error errorState) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        this.errors[var1_1.ordinal()] = var2_2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Landroidx/paging/AccessorState$BlockState;", "", "<init>", "(Ljava/lang/String;I)V", "UNBLOCKED", "COMPLETED", "REQUIRES_REFRESH"})
    public static final class BlockState
    extends Enum<BlockState> {
        public static final /* enum */ BlockState UNBLOCKED = new BlockState();
        public static final /* enum */ BlockState COMPLETED = new BlockState();
        public static final /* enum */ BlockState REQUIRES_REFRESH = new BlockState();
        private static final /* synthetic */ BlockState[] $VALUES;

        /*
         * WARNING - void declaration
         */
        private BlockState() {
            void var2_2;
            void var1_1;
        }

        public static BlockState[] values() {
            return (BlockState[])$VALUES.clone();
        }

        private static final /* synthetic */ BlockState[] $values() {
            BlockState[] blockStateArray = new BlockState[3];
            BlockState[] blockStateArray2 = blockStateArray;
            blockStateArray[0] = UNBLOCKED;
            blockStateArray2[1] = COMPLETED;
            blockStateArray2[2] = REQUIRES_REFRESH;
            return blockStateArray2;
        }

        static {
            $VALUES = BlockState.$values();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000*\b\b\u0002\u0010\u0002*\u00020\u0001*\b\b\u0003\u0010\u0003*\u00020\u00012\u00020\u0001B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\n\u001a\u0004\b\u000b\u0010\fR.\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011"}, d2={"Landroidx/paging/AccessorState$PendingRequest;", "", "Key", "Value", "Landroidx/paging/LoadType;", "loadType", "Landroidx/paging/PagingState;", "pagingState", "<init>", "(Landroidx/paging/LoadType;Landroidx/paging/PagingState;)V", "Landroidx/paging/LoadType;", "getLoadType", "()Landroidx/paging/LoadType;", "Landroidx/paging/PagingState;", "getPagingState", "()Landroidx/paging/PagingState;", "setPagingState", "(Landroidx/paging/PagingState;)V"})
    public static final class PendingRequest<Key, Value> {
        private final LoadType loadType;
        private PagingState<Key, Value> pagingState;

        /*
         * WARNING - void declaration
         */
        public PendingRequest(LoadType loadType, PagingState<Key, Value> pagingState) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            this.loadType = var1_1;
            this.pagingState = var2_2;
        }

        public final LoadType getLoadType() {
            return this.loadType;
        }

        public final PagingState<Key, Value> getPagingState() {
            return this.pagingState;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPagingState(PagingState<Key, Value> pagingState) {
            void var1_1;
            Intrinsics.checkNotNullParameter(pagingState, (String)"<set-?>");
            this.pagingState = var1_1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BlockState.values().length];
            try {
                nArray[BlockState.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BlockState.REQUIRES_REFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BlockState.UNBLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

