/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.concurrent;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0018\u0010\r\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e"}, d2={"Landroidx/room/concurrent/FileLock;", "", "", "filename", "<init>", "(Ljava/lang/String;)V", "", "lock", "()V", "unlock", "lockFilename", "Ljava/lang/String;", "Ljava/nio/channels/FileChannel;", "lockChannel", "Ljava/nio/channels/FileChannel;"})
public final class FileLock {
    private final String lockFilename;
    private FileChannel lockChannel;

    /*
     * WARNING - void declaration
     */
    public FileLock(String filename) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.lockFilename = (String)var1_1 + ".lck";
    }

    /*
     * WARNING - void declaration
     */
    public final void lock() {
        if (this.lockChannel != null) {
            return;
        }
        try {
            File lockFile = new File(this.lockFilename);
            File file = lockFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            FileChannel fileChannel = this.lockChannel = new FileOutputStream(lockFile).getChannel();
            if (fileChannel != null) {
                fileChannel.lock();
                return;
            }
            return;
        }
        catch (Throwable ex) {
            void var1_2;
            FileChannel fileChannel = this.lockChannel;
            if (fileChannel != null) {
                fileChannel.close();
            }
            this.lockChannel = null;
            throw new IllegalStateException("Unable to lock file: '" + this.lockFilename + "'.", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unlock() {
        FileChannel fileChannel = this.lockChannel;
        if (fileChannel == null) {
            return;
        }
        FileChannel channel = fileChannel;
        try {
            void var1_1;
            var1_1.close();
            return;
        }
        finally {
            this.lockChannel = null;
        }
    }
}

