/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u0000 \n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a+\u0010\u0005\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\n\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001b\u0010\f\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\f\u0010\u000b"}, d2={"", "", "migrationStartAndEndVersions", "migrationsNotRequiredFrom", "", "validateMigrationsNotRequired", "(Ljava/util/Set;Ljava/util/Set;)V", "Landroidx/room/RoomDatabase;", "Landroidx/room/DatabaseConfiguration;", "configuration", "validateAutoMigrations", "(Landroidx/room/RoomDatabase;Landroidx/room/DatabaseConfiguration;)V", "validateTypeConverters"}, xs="androidx/room/RoomDatabaseKt")
@SourceDebugExtension(value={"SMAP\nRoomDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomDatabase.kt\nandroidx/room/RoomDatabaseKt__RoomDatabaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,616:1\n1#2:617\n216#3,2:618\n*S KotlinDebug\n*F\n+ 1 RoomDatabase.kt\nandroidx/room/RoomDatabaseKt__RoomDatabaseKt\n*L\n585#1:618,2\n*E\n"})
final class RoomDatabaseKt__RoomDatabaseKt {
    /*
     * WARNING - void declaration
     */
    public static final void validateMigrationsNotRequired(Set<Integer> migrationStartAndEndVersions, Set<Integer> migrationsNotRequiredFrom) {
        Intrinsics.checkNotNullParameter(migrationStartAndEndVersions, (String)"migrationStartAndEndVersions");
        Intrinsics.checkNotNullParameter(migrationsNotRequiredFrom, (String)"migrationsNotRequiredFrom");
        if (!((Collection)migrationStartAndEndVersions).isEmpty()) {
            Object object;
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                int version = ((Number)object.next()).intValue();
                if (!migrationsNotRequiredFrom.contains(version)) continue;
                object = "Inconsistency detected. A Migration was supplied to addMigration() that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(). Start version is: " + (int)var2_2;
                throw new IllegalArgumentException(object.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateAutoMigrations(RoomDatabase $this$validateAutoMigrations, DatabaseConfiguration configuration) {
        void var2_2;
        RoomDatabase roomDatabase;
        int n;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)$this$validateAutoMigrations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map autoMigrationSpecs = new LinkedHashMap();
        Set<KClass<? extends AutoMigrationSpec>> requiredAutoMigrationSpecs = $this$validateAutoMigrations.getRequiredAutoMigrationSpecClasses();
        boolean[] usedSpecs = new boolean[configuration.getAutoMigrationSpecs().size()];
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            KClass spec = (KClass)iterator.next();
            int foundIndex = -1;
            n = ((Collection)configuration.getAutoMigrationSpecs()).size() + -1;
            if (n >= 0) {
                do {
                    int providedIndex = n--;
                    AutoMigrationSpec provided = configuration.getAutoMigrationSpecs().get(providedIndex);
                    if (!spec.isInstance((Object)provided)) continue;
                    foundIndex = providedIndex;
                    usedSpecs[foundIndex] = true;
                    break;
                } while (n >= 0);
            }
            if (!(foundIndex >= 0)) {
                String string = "A required auto migration spec (" + spec.getQualifiedName() + ") is missing in the database configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            autoMigrationSpecs.put(spec, configuration.getAutoMigrationSpecs().get(foundIndex));
        }
        int n2 = ((Collection)configuration.getAutoMigrationSpecs()).size() + -1;
        if (n2 >= 0) {
            do {
                int providedIndex;
                if ((providedIndex = n2--) < usedSpecs.length && usedSpecs[providedIndex]) continue;
                String string = "Unexpected auto migration specs found. Annotate AutoMigrationSpec implementation with @ProvidedAutoMigrationSpec annotation or remove this spec from the builder.";
                throw new IllegalArgumentException(string.toString());
            } while (n2 >= 0);
        }
        List<Migration> list = roomDatabase.createAutoMigrations((Map<KClass<? extends AutoMigrationSpec>, ? extends AutoMigrationSpec>)var2_2);
        for (Migration autoMigration : list) {
            boolean bl = configuration.getMigrationContainer().contains(autoMigration.getStartVersion(), autoMigration.getEndVersion());
            n = bl ? 1 : 0;
            if (bl) continue;
            configuration.getMigrationContainer().addMigration(autoMigration);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateTypeConverters(RoomDatabase $this$validateTypeConverters, DatabaseConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)$this$validateTypeConverters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map<KClass<?>, List<KClass<?>>> requiredFactories232 = $this$validateTypeConverters.getRequiredTypeConverterClassesMap$room_runtime();
        boolean[] used = new boolean[configuration.getTypeConverters().size()];
        for (Map.Entry entry : requiredFactories232.entrySet()) {
            Iterator iterator = entry;
            iterator = entry;
            KClass daoName = (KClass)entry.getKey();
            iterator = (List)iterator.getValue();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                KClass converter = (KClass)iterator.next();
                int foundIndex = -1;
                int n = ((Collection)configuration.getTypeConverters()).size() + -1;
                if (n >= 0) {
                    do {
                        int providedIndex = n--;
                        Object provided = configuration.getTypeConverters().get(providedIndex);
                        if (!converter.isInstance(provided)) continue;
                        foundIndex = providedIndex;
                        used[foundIndex] = true;
                        break;
                    } while (n >= 0);
                }
                if (!(foundIndex >= 0)) {
                    String string = "A required type converter (" + converter.getQualifiedName() + ") for " + daoName.getQualifiedName() + " is missing in the database configuration.";
                    throw new IllegalArgumentException(string.toString());
                }
                $this$validateTypeConverters.addTypeConverter$room_runtime(converter, configuration.getTypeConverters().get(foundIndex));
            }
        }
        int requiredFactories232 = ((Collection)configuration.getTypeConverters()).size() + -1;
        if (requiredFactories232 >= 0) {
            void var2_4;
            do {
                void var2_5;
                void var0_1;
                int providedIndex;
                if (used[providedIndex = requiredFactories232--]) continue;
                Object converter = configuration.getTypeConverters().get((int)var0_1);
                throw new IllegalArgumentException("Unexpected type converter " + var2_5 + ". Annotate TypeConverter class with @ProvidedTypeConverter annotation or remove this converter from the builder.");
            } while (var2_4 >= 0);
        }
    }
}

