/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.BaseRoomConnectionManager;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenDelegate;
import androidx.room.Transactor;
import androidx.room.coroutines.ConnectionPool;
import androidx.room.coroutines.ConnectionPoolKt;
import androidx.room.coroutines.PassthroughConnectionPool;
import androidx.sqlite.SQLiteDriver;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJB\u0010\u0015\u001a\u00028\u0000\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000f\u001a\u00020\u000e2\"\u0010\u0014\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0010H\u0096@\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\u00068\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\n\u0010 \u001a\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%"}, d2={"Landroidx/room/RoomConnectionManager;", "Landroidx/room/BaseRoomConnectionManager;", "Landroidx/room/DatabaseConfiguration;", "configuration", "Landroidx/sqlite/SQLiteDriver;", "sqliteDriver", "Landroidx/room/RoomOpenDelegate;", "openDelegate", "", "Landroidx/room/RoomDatabase$Callback;", "callbacks", "<init>", "(Landroidx/room/DatabaseConfiguration;Landroidx/sqlite/SQLiteDriver;Landroidx/room/RoomOpenDelegate;Ljava/util/List;)V", "R", "", "isReadOnly", "Lkotlin/Function2;", "Landroidx/room/Transactor;", "Lkotlin/coroutines/Continuation;", "", "block", "useConnection", "(ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "close", "()V", "Landroidx/room/DatabaseConfiguration;", "getConfiguration", "()Landroidx/room/DatabaseConfiguration;", "Landroidx/room/RoomOpenDelegate;", "getOpenDelegate", "()Landroidx/room/RoomOpenDelegate;", "Ljava/util/List;", "getCallbacks", "()Ljava/util/List;", "Landroidx/room/coroutines/ConnectionPool;", "connectionPool", "Landroidx/room/coroutines/ConnectionPool;"})
public final class RoomConnectionManager
extends BaseRoomConnectionManager {
    private final DatabaseConfiguration configuration;
    private final RoomOpenDelegate openDelegate;
    private final List<RoomDatabase.Callback> callbacks;
    private final ConnectionPool connectionPool;

    /*
     * WARNING - void declaration
     */
    public RoomConnectionManager(DatabaseConfiguration configuration, SQLiteDriver sqliteDriver, RoomOpenDelegate openDelegate, List<? extends RoomDatabase.Callback> callbacks) {
        ConnectionPool connectionPool;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)sqliteDriver, (String)"sqliteDriver");
        Intrinsics.checkNotNullParameter((Object)openDelegate, (String)"openDelegate");
        Intrinsics.checkNotNullParameter(callbacks, (String)"callbacks");
        this.configuration = var1_1;
        this.openDelegate = var3_3;
        this.callbacks = callbacks;
        if (sqliteDriver.hasConnectionPool()) {
            String string = this.getConfiguration().getName();
            if (string == null) {
                string = ":memory:";
            }
            connectionPool = new PassthroughConnectionPool(sqliteDriver, string, null, 4, null);
        } else if (this.getConfiguration().getName() == null) {
            connectionPool = ConnectionPoolKt.newSingleConnectionPool(new BaseRoomConnectionManager.DriverWrapper(this, sqliteDriver), ":memory:");
        } else {
            void var2_2;
            RoomConnectionManager roomConnectionManager = this;
            RoomConnectionManager roomConnectionManager2 = this;
            connectionPool = ConnectionPoolKt.newConnectionPool(new BaseRoomConnectionManager.DriverWrapper(this, (SQLiteDriver)var2_2), this.getConfiguration().getName(), roomConnectionManager.getMaxNumberOfReaders(roomConnectionManager.getConfiguration().getJournalMode()), roomConnectionManager2.getMaxNumberOfWriters(roomConnectionManager2.getConfiguration().getJournalMode()));
        }
        this.connectionPool = connectionPool;
    }

    @Override
    protected final DatabaseConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected final RoomOpenDelegate getOpenDelegate() {
        return this.openDelegate;
    }

    @Override
    protected final List<RoomDatabase.Callback> getCallbacks() {
        return this.callbacks;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> Object useConnection(boolean isReadOnly, Function2<? super Transactor, ? super Continuation<? super R>, ? extends Object> block, Continuation<? super R> $completion) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.connectionPool.useConnection((boolean)var1_1, var2_2, var3_3);
    }

    public final void close() {
        this.connectionPool.close();
    }
}

