/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomMasterTable;
import androidx.room.RoomOpenDelegate;
import androidx.room.concurrent.ExclusiveLock;
import androidx.room.migration.Migration;
import androidx.room.util.MigrationUtil;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import androidx.sqlite.SQLiteStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 82\u00020\u0001:\u000298B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0010\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\u0012\u0010\rJ\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\rJ'\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\rJ\u0017\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\u001e\u0010\rJ\u0017\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001f\u0010\rJ\u0017\u0010 \u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b \u0010\u0015J\u0013\u0010\"\u001a\u00020\u0018*\u00020!H\u0004\u00a2\u0006\u0004\b\"\u0010#J\u0013\u0010$\u001a\u00020\u0018*\u00020!H\u0004\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010%\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b%\u0010\rJ\u0017\u0010&\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b&\u0010\rJ\u0017\u0010'\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b'\u0010\rR\u0014\u0010+\u001a\u00020(8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010/\u001a\u00020,8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000201008$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0016\u00105\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00106"}, d2={"Landroidx/room/BaseRoomConnectionManager;", "", "<init>", "()V", "", "fileName", "resolveFileName$room_runtime", "(Ljava/lang/String;)Ljava/lang/String;", "resolveFileName", "Landroidx/sqlite/SQLiteConnection;", "connection", "", "configureDatabase", "(Landroidx/sqlite/SQLiteConnection;)V", "configurationConnection", "configureJournalMode", "configureSynchronousFlag", "configureBusyTimeout", "onCreate", "", "hasEmptySchema", "(Landroidx/sqlite/SQLiteConnection;)Z", "updateIdentity", "createMasterTableIfNotExists", "", "oldVersion", "newVersion", "onMigrate", "(Landroidx/sqlite/SQLiteConnection;II)V", "dropAllTables", "onOpen", "checkIdentity", "hasRoomMasterTable", "Landroidx/room/RoomDatabase$JournalMode;", "getMaxNumberOfReaders", "(Landroidx/room/RoomDatabase$JournalMode;)I", "getMaxNumberOfWriters", "invokeCreateCallback", "invokeDestructiveMigrationCallback", "invokeOpenCallback", "Landroidx/room/DatabaseConfiguration;", "getConfiguration", "()Landroidx/room/DatabaseConfiguration;", "configuration", "Landroidx/room/RoomOpenDelegate;", "getOpenDelegate", "()Landroidx/room/RoomOpenDelegate;", "openDelegate", "", "Landroidx/room/RoomDatabase$Callback;", "getCallbacks", "()Ljava/util/List;", "callbacks", "isConfigured", "Z", "isInitializing", "Companion", "DriverWrapper"})
@SourceDebugExtension(value={"SMAP\nRoomConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n1#2:366\n1869#3,2:367\n1869#3,2:369\n1869#3,2:371\n1869#3,2:373\n1869#3,2:375\n*S KotlinDebug\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n*L\n212#1:367,2\n256#1:369,2\n345#1:371,2\n349#1:373,2\n353#1:375,2\n*E\n"})
public abstract class BaseRoomConnectionManager {
    public static final Companion Companion = new Companion(null);
    private boolean isConfigured;
    private boolean isInitializing;

    protected abstract DatabaseConfiguration getConfiguration();

    protected abstract RoomOpenDelegate getOpenDelegate();

    protected abstract List<RoomDatabase.Callback> getCallbacks();

    /*
     * WARNING - void declaration
     */
    public String resolveFileName$room_runtime(String fileName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void configureDatabase(SQLiteConnection connection2) {
        void var1_1;
        int statement22;
        this.configureJournalMode((SQLiteConnection)connection2);
        this.configureSynchronousFlag((SQLiteConnection)connection2);
        this.configureBusyTimeout((SQLiteConnection)connection2);
        Object object = (AutoCloseable)connection2.prepare("PRAGMA user_version");
        Object object2 = null;
        try {
            SQLiteStatement statement22 = (SQLiteStatement)object;
            statement22.step();
            statement22 = (int)statement22.getLong(0);
        }
        catch (Throwable throwable) {
            try {
                connection2 = throwable;
                object2 = throwable;
                throw connection2;
            }
            catch (Throwable connection2) {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
                throw connection2;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)object, null);
        int version2 = statement22;
        if (version2 != this.getOpenDelegate().getVersion()) {
            Object connection2;
            SQLite.execSQL((SQLiteConnection)connection2, (String)"BEGIN EXCLUSIVE TRANSACTION");
            object = this;
            try {
                BaseRoomConnectionManager $this$configureDatabase_u24lambda_u241 = (BaseRoomConnectionManager)object;
                if (version2 == 0) {
                    $this$configureDatabase_u24lambda_u241.onCreate((SQLiteConnection)connection2);
                } else {
                    $this$configureDatabase_u24lambda_u241.onMigrate((SQLiteConnection)connection2, version2, $this$configureDatabase_u24lambda_u241.getOpenDelegate().getVersion());
                }
                SQLite.execSQL((SQLiteConnection)connection2, (String)("PRAGMA user_version = " + $this$configureDatabase_u24lambda_u241.getOpenDelegate().getVersion()));
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable version2) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)version2));
            }
            object = object2;
            if (Result.isSuccess-impl((Object)object)) {
                Unit cfr_ignored_0 = (Unit)object;
                SQLite.execSQL((SQLiteConnection)connection2, (String)"END TRANSACTION");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                void var2_8;
                object2 = throwable;
                Throwable it = throwable;
                SQLite.execSQL((SQLiteConnection)connection2, (String)"ROLLBACK TRANSACTION");
                throw var2_8;
            }
        }
        this.onOpen((SQLiteConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void configurationConnection(SQLiteConnection connection) {
        void var1_1;
        this.configureSynchronousFlag(connection);
        this.configureBusyTimeout(connection);
        this.getOpenDelegate().onOpen((SQLiteConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void configureJournalMode(SQLiteConnection connection) {
        void var1_1;
        boolean bl = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (bl) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA journal_mode = WAL");
            return;
        }
        SQLite.execSQL((SQLiteConnection)var1_1, (String)"PRAGMA journal_mode = TRUNCATE");
    }

    /*
     * WARNING - void declaration
     */
    private final void configureSynchronousFlag(SQLiteConnection connection) {
        void var1_1;
        boolean bl = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (bl) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA synchronous = NORMAL");
            return;
        }
        SQLite.execSQL((SQLiteConnection)var1_1, (String)"PRAGMA synchronous = FULL");
    }

    /*
     * WARNING - void declaration
     */
    private final void configureBusyTimeout(SQLiteConnection connection2) {
        long l;
        AutoCloseable autoCloseable = (AutoCloseable)connection2.prepare("PRAGMA busy_timeout");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            it.step();
            l = it.getLong(0);
        }
        catch (Throwable throwable2) {
            try {
                connection2 = throwable2;
                throwable = throwable2;
                throw connection2;
            }
            catch (Throwable connection2) {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                throw connection2;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        long l2 = l;
        if (l2 < 3000L) {
            void var1_1;
            SQLite.execSQL((SQLiteConnection)var1_1, (String)"PRAGMA busy_timeout = 3000");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void onCreate(SQLiteConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean isEmptyDatabase = this.hasEmptySchema(connection);
        this.getOpenDelegate().createAllTables(connection);
        if (!isEmptyDatabase) {
            RoomOpenDelegate.ValidationResult result = this.getOpenDelegate().onValidateSchema(connection);
            if (!result.isValid) {
                void var2_3;
                throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + var2_3.expectedFoundMsg).toString());
            }
        }
        this.updateIdentity(connection);
        this.getOpenDelegate().onCreate(connection);
        this.invokeCreateCallback((SQLiteConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEmptySchema(SQLiteConnection connection) {
        boolean bl;
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
        Throwable throwable = null;
        try {
            void var3_3;
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            bl = it.step() && var3_3.getLong(0) == 0L;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                throw throwable4;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateIdentity(SQLiteConnection connection) {
        void var1_1;
        this.createMasterTableIfNotExists(connection);
        SQLite.execSQL((SQLiteConnection)var1_1, (String)RoomMasterTable.createInsertQuery((String)this.getOpenDelegate().getIdentityHash()));
    }

    private final void createMasterTableIfNotExists(SQLiteConnection connection) {
        SQLite.execSQL((SQLiteConnection)connection, (String)"CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    /*
     * WARNING - void declaration
     */
    protected final void onMigrate(SQLiteConnection connection, int oldVersion, int newVersion) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean migrated2 = false;
        List<Migration> migrations = MigrationUtil.findMigrationPath(this.getConfiguration().getMigrationContainer(), oldVersion, newVersion);
        if (migrations != null) {
            this.getOpenDelegate().onPreMigrate(connection);
            Object migrated2 = migrations;
            migrated2 = migrated2.iterator();
            while (migrated2.hasNext()) {
                Object object = migrated2.next();
                object = (Migration)object;
                ((Migration)object).migrate(connection);
            }
            RoomOpenDelegate.ValidationResult result = this.getOpenDelegate().onValidateSchema(connection);
            if (!result.isValid) {
                throw new IllegalStateException(("Migration didn't properly handle: " + result.expectedFoundMsg).toString());
            }
            this.getOpenDelegate().onPostMigrate(connection);
            this.updateIdentity(connection);
            bl = true;
        }
        if (!bl) {
            void var1_1;
            if (MigrationUtil.isMigrationRequired(this.getConfiguration(), oldVersion, newVersion)) {
                void var3_3;
                void var2_2;
                throw new IllegalStateException(("A migration from " + (int)var2_2 + " to " + (int)var3_3 + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* functions.").toString());
            }
            this.dropAllTables(connection);
            this.invokeDestructiveMigrationCallback(connection);
            this.getOpenDelegate().createAllTables((SQLiteConnection)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dropAllTables(SQLiteConnection connection) {
        void var1_1;
        block7: {
            Object object;
            List list;
            if (!this.getConfiguration().getAllowDestructiveMigrationForAllTables()) break block7;
            Object object2 = (AutoCloseable)connection.prepare("SELECT name, type FROM sqlite_master WHERE type = 'table' OR type = 'view'");
            Throwable throwable = null;
            try {
                SQLiteStatement statement = (SQLiteStatement)object2;
                List $this$dropAllTables_u24lambda_u248_u24lambda_u247 = list = CollectionsKt.createListBuilder();
                while (statement.step()) {
                    String name = statement.getText(0);
                    if (StringsKt.startsWith$default((String)name, (String)"sqlite_", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"android_metadata")) continue;
                    boolean isView = Intrinsics.areEqual((Object)statement.getText(1), (Object)"view");
                    $this$dropAllTables_u24lambda_u248_u24lambda_u247.add(TuplesKt.to((Object)name, (Object)isView));
                }
                object = CollectionsKt.build((List)list);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
                    throw throwable4;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)object2, null);
            object2 = (Iterable)object;
            object = object2.iterator();
            while (object.hasNext()) {
                list = object.next();
                list = (Pair)list;
                String name = (String)list.component1();
                boolean bl = (Boolean)list.component2();
                if (bl) {
                    SQLite.execSQL((SQLiteConnection)connection, (String)("DROP VIEW IF EXISTS `" + name + '`'));
                    continue;
                }
                SQLite.execSQL((SQLiteConnection)connection, (String)("DROP TABLE IF EXISTS `" + (String)object2 + '`'));
            }
            return;
        }
        this.getOpenDelegate().dropAllTables((SQLiteConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final void onOpen(SQLiteConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.checkIdentity(connection);
        this.getOpenDelegate().onOpen(connection);
        this.invokeOpenCallback((SQLiteConnection)var1_1);
        this.isConfigured = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIdentity(SQLiteConnection connection22) {
        block12: {
            Object object;
            Object connection22;
            block10: {
                SQLiteStatement it;
                if (!this.hasRoomMasterTable((SQLiteConnection)connection22)) break block10;
                AutoCloseable autoCloseable = (AutoCloseable)connection22.prepare("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1");
                Throwable throwable = null;
                try {
                    it = (SQLiteStatement)autoCloseable;
                    it = it.step() ? it.getText(0) : null;
                }
                catch (Throwable throwable2) {
                    try {
                        connection22 = throwable2;
                        throwable = throwable2;
                        throw connection22;
                    }
                    catch (Throwable connection22) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        throw connection22;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
                SQLiteStatement identityHash = it;
                if (!Intrinsics.areEqual((Object)this.getOpenDelegate().getIdentityHash(), (Object)identityHash) && !Intrinsics.areEqual((Object)this.getOpenDelegate().getLegacyIdentityHash(), (Object)identityHash)) {
                    throw new IllegalStateException(("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number. Expected identity hash: " + this.getOpenDelegate().getIdentityHash() + ", found: " + (String)identityHash).toString());
                }
                break block12;
            }
            SQLite.execSQL((SQLiteConnection)connection22, (String)"BEGIN EXCLUSIVE TRANSACTION");
            BaseRoomConnectionManager identityHash = this;
            try {
                BaseRoomConnectionManager $this$checkIdentity_u24lambda_u2411 = identityHash;
                RoomOpenDelegate.ValidationResult result = $this$checkIdentity_u24lambda_u2411.getOpenDelegate().onValidateSchema((SQLiteConnection)connection22);
                if (!result.isValid) {
                    throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + result.expectedFoundMsg).toString());
                }
                $this$checkIdentity_u24lambda_u2411.getOpenDelegate().onPostMigrate((SQLiteConnection)connection22);
                super.updateIdentity((SQLiteConnection)connection22);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isSuccess-impl((Object)object)) {
                Unit cfr_ignored_0 = (Unit)object;
                SQLite.execSQL((SQLiteConnection)connection22, (String)"END TRANSACTION");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                void var3_7;
                void var1_1;
                object = throwable;
                Throwable it = throwable;
                SQLite.execSQL((SQLiteConnection)var1_1, (String)"ROLLBACK TRANSACTION");
                throw var3_7;
            }
            Result.box-impl((Object)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasRoomMasterTable(SQLiteConnection connection) {
        boolean bl;
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name = 'room_master_table'");
        Throwable throwable = null;
        try {
            void var3_3;
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            bl = it.step() && var3_3.getLong(0) != 0L;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                throw throwable4;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected final int getMaxNumberOfReaders(RoomDatabase.JournalMode $this$getMaxNumberOfReaders) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfReaders), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfReaders.ordinal()]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
        }
        throw new IllegalStateException(("Can't get max number of reader for journal mode '" + var1_1 + '\'').toString());
    }

    /*
     * WARNING - void declaration
     */
    protected final int getMaxNumberOfWriters(RoomDatabase.JournalMode $this$getMaxNumberOfWriters) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfWriters), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfWriters.ordinal()]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalStateException(("Can't get max number of writers for journal mode '" + var1_1 + '\'').toString());
    }

    private final void invokeCreateCallback(SQLiteConnection connection) {
        Object object = this.getCallbacks();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (RoomDatabase.Callback)object2;
            ((RoomDatabase.Callback)object2).onCreate(connection);
        }
    }

    private final void invokeDestructiveMigrationCallback(SQLiteConnection connection) {
        Object object = this.getCallbacks();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (RoomDatabase.Callback)object2;
            ((RoomDatabase.Callback)object2).onDestructiveMigration(connection);
        }
    }

    private final void invokeOpenCallback(SQLiteConnection connection) {
        Object object = this.getCallbacks();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (RoomDatabase.Callback)object2;
            ((RoomDatabase.Callback)object2).onOpen(connection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setInitializing$p(BaseRoomConnectionManager $this, boolean bl) {
        void var1_1;
        $this.isInitializing = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$configureDatabase(BaseRoomConnectionManager $this, SQLiteConnection connection) {
        void var1_1;
        $this.configureDatabase((SQLiteConnection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$configurationConnection(BaseRoomConnectionManager $this, SQLiteConnection connection) {
        void var1_1;
        $this.configurationConnection((SQLiteConnection)var1_1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Landroidx/room/BaseRoomConnectionManager$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Landroidx/room/BaseRoomConnectionManager$DriverWrapper;", "Landroidx/sqlite/SQLiteDriver;", "actual", "<init>", "(Landroidx/room/BaseRoomConnectionManager;Landroidx/sqlite/SQLiteDriver;)V", "", "fileName", "Landroidx/sqlite/SQLiteConnection;", "open", "(Ljava/lang/String;)Landroidx/sqlite/SQLiteConnection;", "filename", "openLocked", "Landroidx/sqlite/SQLiteDriver;", "", "hasConnectionPool", "()Z"})
    protected final class DriverWrapper
    implements SQLiteDriver {
        private final SQLiteDriver actual;
        final /* synthetic */ BaseRoomConnectionManager this$0;

        /*
         * WARNING - void declaration
         */
        public DriverWrapper(BaseRoomConnectionManager this$0, SQLiteDriver actual) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            this.this$0 = var1_1;
            this.actual = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final SQLiteConnection open(String fileName) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            DriverWrapper driverWrapper = this;
            return driverWrapper.openLocked(driverWrapper.this$0.resolveFileName$room_runtime((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private final SQLiteConnection openLocked(String filename) {
            void var1_1;
            return (SQLiteConnection)new ExclusiveLock(filename, !this.this$0.isConfigured && !this.this$0.isInitializing && !Intrinsics.areEqual((Object)filename, (Object)":memory:")).withLock(() -> DriverWrapper.openLocked$lambda$1(this.this$0, this, filename), new Function1((String)var1_1){
                final /* synthetic */ String $filename;
                {
                    void var1_1;
                    this.$filename = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Void invoke(Throwable error) {
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    throw new IllegalStateException("Unable to open database '" + this.$filename + "'. Was a proper path / name used in Room's database builder?", (Throwable)var1_1);
                }
            });
        }

        @JvmName(name="hasConnectionPool")
        public final boolean hasConnectionPool() {
            return this.actual.hasConnectionPool();
        }

        /*
         * WARNING - void declaration
         */
        private static final SQLiteConnection openLocked$lambda$1(BaseRoomConnectionManager this$0, DriverWrapper this$1, String $filename) {
            void var1_1;
            void var2_3;
            if (!(!this$0.isInitializing)) {
                this$1 = "Recursive database initialization detected. Did you try to use the database instance during initialization? Maybe in one of the callbacks?";
                throw new IllegalStateException(this$1.toString());
            }
            SQLiteConnection connection = ((DriverWrapper)this$1).actual.open((String)var2_3);
            if (!this$0.isConfigured) {
                try {
                    BaseRoomConnectionManager.access$setInitializing$p(this$0, true);
                    BaseRoomConnectionManager.access$configureDatabase(this$0, connection);
                }
                finally {
                    BaseRoomConnectionManager.access$setInitializing$p(this$0, false);
                }
            } else {
                BaseRoomConnectionManager baseRoomConnectionManager;
                BaseRoomConnectionManager.access$configurationConnection(baseRoomConnectionManager, connection);
            }
            return var1_1;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomDatabase.JournalMode.values().length];
            try {
                nArray[RoomDatabase.JournalMode.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

