/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0015\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B1\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0016J/\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0016J'\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010!\u001a\u00020\u000e8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\""}, d2={"Landroidx/compose/animation/core/VectorizedRepeatableSpec;", "Landroidx/compose/animation/core/AnimationVector;", "V", "Landroidx/compose/animation/core/VectorizedFiniteAnimationSpec;", "", "iterations", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "animation", "Landroidx/compose/animation/core/RepeatMode;", "repeatMode", "Landroidx/compose/animation/core/StartOffset;", "initialStartOffset", "<init>", "(ILandroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;Landroidx/compose/animation/core/RepeatMode;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "playTimeNanos", "repetitionPlayTimeNanos", "(J)J", "start", "startVelocity", "end", "repetitionStartVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "initialValue", "targetValue", "initialVelocity", "getValueFromNanos", "getVelocityFromNanos", "getDurationNanos", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "I", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "Landroidx/compose/animation/core/RepeatMode;", "durationNanos", "J", "initialOffsetNanos"})
public final class VectorizedRepeatableSpec<V extends AnimationVector>
implements VectorizedFiniteAnimationSpec<V> {
    private final int iterations;
    private final VectorizedDurationBasedAnimationSpec<V> animation;
    private final RepeatMode repeatMode;
    public final long durationNanos;
    private final long initialOffsetNanos;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private VectorizedRepeatableSpec(int iterations, VectorizedDurationBasedAnimationSpec<V> animation, RepeatMode repeatMode, long initialStartOffset) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.iterations = var1_1;
        this.animation = var2_2;
        this.repeatMode = var3_3;
        if (this.iterations <= 0) {
            throw new IllegalArgumentException("Iterations count can't be less than 1");
        }
        this.durationNanos = (long)(this.animation.getDelayMillis() + this.animation.getDurationMillis()) * 1000000L;
        this.initialOffsetNanos = initialStartOffset * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    private final long repetitionPlayTimeNanos(long playTimeNanos) {
        void var3_2;
        void var1_1;
        if (playTimeNanos + this.initialOffsetNanos <= 0L) {
            return 0L;
        }
        void postOffsetPlayTimeNanos = var1_1 + this.initialOffsetNanos;
        long repeatsCount = Math.min((long)(postOffsetPlayTimeNanos / this.durationNanos), (long)this.iterations - 1L);
        if (this.repeatMode == RepeatMode.Restart || repeatsCount % 2L == 0L) {
            return (long)(postOffsetPlayTimeNanos - repeatsCount * this.durationNanos);
        }
        return (repeatsCount + 1L) * this.durationNanos - var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private final V repetitionStartVelocity(long playTimeNanos, V start, V startVelocity, V end) {
        if (playTimeNanos + this.initialOffsetNanos > this.durationNanos) {
            void var3_2;
            VectorizedRepeatableSpec vectorizedRepeatableSpec = this;
            return vectorizedRepeatableSpec.getVelocityFromNanos(vectorizedRepeatableSpec.durationNanos - this.initialOffsetNanos, var3_2, startVelocity, end);
        }
        return startVelocity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getValueFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), (void)initialValue, (void)targetValue, this.repetitionStartVelocity((long)var1_1, var3_2, initialVelocity, targetValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getVelocityFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), (void)initialValue, (void)targetValue, this.repetitionStartVelocity((long)var1_1, var3_2, initialVelocity, targetValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(V initialValue, V targetValue, V initialVelocity) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"targetValue");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"initialVelocity");
        return (long)this.iterations * this.durationNanos - this.initialOffsetNanos;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ VectorizedRepeatableSpec(int iterations, VectorizedDurationBasedAnimationSpec animation, RepeatMode repeatMode, long initialStartOffset, DefaultConstructorMarker $constructor_marker) {
        this((int)var1_1, (VectorizedDurationBasedAnimationSpec<V>)var2_2, (RepeatMode)var3_3, initialStartOffset);
        void var3_3;
        void var2_2;
        void var1_1;
    }
}

