/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003BE\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010$\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010)R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010\u000b\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010*\u001a\u0004\b-\u0010,R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010.R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010*R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0018\u00105\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0018\u00107\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00106R\u0018\u00108\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00106R\u0018\u00109\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00106R\u0016\u0010:\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00104R\u0016\u0010;\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00104R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "Landroidx/compose/animation/core/AnimationVector;", "V", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "Landroidx/collection/IntList;", "timestamps", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/animation/core/VectorizedKeyframeSpecElementInfo;", "keyframes", "", "durationMillis", "delayMillis", "Landroidx/compose/animation/core/Easing;", "defaultEasing", "Landroidx/compose/animation/core/ArcMode;", "initialArcMode", "<init>", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IILandroidx/compose/animation/core/Easing;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "initialValue", "targetValue", "initialVelocity", "", "init", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "", "playTimeNanos", "getValueFromNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "timeMillis", "", "getEasedTime", "(I)F", "index", "", "asFraction", "getEasedTimeFromIndex", "(IIZ)F", "findEntryForTimeMillis", "(I)I", "Landroidx/collection/IntList;", "Landroidx/collection/IntObjectMap;", "I", "getDurationMillis", "()I", "getDelayMillis", "Landroidx/compose/animation/core/Easing;", "", "modes", "[I", "", "times", "[F", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "lastInitialValue", "lastTargetValue", "posArray", "slopeArray", "Landroidx/compose/animation/core/ArcSpline;", "arcSpline", "Landroidx/compose/animation/core/ArcSpline;"})
@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntList.kt\nandroidx/collection/IntList\n+ 4 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n*L\n1#1,1038:1\n216#2,2:1039\n216#2,2:1041\n65#3:1043\n65#3:1044\n65#3:1045\n70#3:1047\n71#4:1046\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n*L\n246#1:1039,2\n259#1:1041,2\n301#1:1043\n304#1:1044\n335#1:1045\n469#1:1047\n418#1:1046\n*E\n"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    private final IntList timestamps;
    private final IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private final Easing defaultEasing;
    private final int initialArcMode;
    private int[] modes;
    private float[] times;
    private V valueVector;
    private V velocityVector;
    private V lastInitialValue;
    private V lastTargetValue;
    private float[] posArray;
    private float[] slopeArray;
    private ArcSpline arcSpline;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private VectorizedKeyframesSpec(IntList timestamps, IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)timestamps, (String)"timestamps");
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        Intrinsics.checkNotNullParameter((Object)defaultEasing, (String)"defaultEasing");
        this.timestamps = var1_1;
        this.keyframes = var2_2;
        this.durationMillis = var3_3;
        this.delayMillis = delayMillis;
        this.defaultEasing = defaultEasing;
        this.initialArcMode = initialArcMode;
        this.modes = VectorizedAnimationSpecKt.access$getEmptyIntArray$p();
        this.times = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.posArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.slopeArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.arcSpline = VectorizedAnimationSpecKt.access$getEmptyArcSpline$p();
    }

    @Override
    public final int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public final int getDelayMillis() {
        return this.delayMillis;
    }

    private final void init(V initialValue, V targetValue, V initialVelocity2) {
        int n;
        VectorizedKeyframesSpec vectorizedKeyframesSpec;
        int requiresArcSpline;
        int n2 = requiresArcSpline = this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p() ? 1 : 0;
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity2);
            int initialVelocity2 = 0;
            Object object = this.timestamps;
            int n3 = object._size;
            object = new float[n3];
            vectorizedKeyframesSpec = this;
            while (initialVelocity2 < n3) {
                n = initialVelocity2++;
                object[n] = (IntList)((float)this.timestamps.get(n) / 1000.0f);
            }
            vectorizedKeyframesSpec.times = (float[])object;
            object = this.timestamps;
            n3 = object._size;
            object = new int[n3];
            vectorizedKeyframesSpec = this;
            for (initialVelocity2 = 0; initialVelocity2 < n3; ++initialVelocity2) {
                n = initialVelocity2;
                VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(this.timestamps.get(n));
                int mode = vectorizedKeyframeSpecElementInfo != null ? vectorizedKeyframeSpecElementInfo.getArcMode--9T-Mq4() : this.initialArcMode;
                if (!ArcMode.equals-impl0(mode, ArcMode.Companion.getArcLinear--9T-Mq4())) {
                    requiresArcSpline = 1;
                }
                object[n] = (IntList)mode;
            }
            vectorizedKeyframesSpec.modes = (int[])object;
        }
        if (requiresArcSpline == 0) {
            return;
        }
        if (this.arcSpline == VectorizedAnimationSpecKt.access$getEmptyArcSpline$p() || !Intrinsics.areEqual(this.lastInitialValue, initialValue) || !Intrinsics.areEqual(this.lastTargetValue, targetValue)) {
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue;
            int dimensionCount = ((AnimationVector)initialValue).getSize$animation_core() % 2 + ((AnimationVector)initialValue).getSize$animation_core();
            this.posArray = new float[dimensionCount];
            this.slopeArray = new float[dimensionCount];
            Object object = this.timestamps;
            n = object._size;
            object = new float[n][];
            for (int i = 0; i < n; ++i) {
                Object object2;
                int n4;
                VectorizedKeyframesSpec vectorizedKeyframesSpec2;
                int n5;
                requiresArcSpline = i;
                int timestamp = this.timestamps.get(requiresArcSpline);
                Object info2 = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestamp);
                if (timestamp == 0 && info2 == null) {
                    timestamp = 0;
                    info2 = new float[dimensionCount];
                    n5 = requiresArcSpline;
                    vectorizedKeyframesSpec = object;
                    while (timestamp < dimensionCount) {
                        int n6 = timestamp++;
                        info2[n6] = ((AnimationVector)initialValue).get$animation_core(n6);
                    }
                    vectorizedKeyframesSpec2 = vectorizedKeyframesSpec;
                    n4 = n5;
                    object2 = info2;
                } else if (timestamp == this.getDurationMillis() && info2 == null) {
                    timestamp = 0;
                    info2 = new float[dimensionCount];
                    while (timestamp < dimensionCount) {
                        int n7 = timestamp++;
                        info2[n7] = ((AnimationVector)targetValue).get$animation_core(n7);
                    }
                    vectorizedKeyframesSpec2 = vectorizedKeyframesSpec;
                    n4 = n5;
                    object2 = info2;
                } else {
                    VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo = info2;
                    Intrinsics.checkNotNull((Object)vectorizedKeyframeSpecElementInfo);
                    Object vectorValue = vectorizedKeyframeSpecElementInfo.getVectorValue();
                    int info2 = 0;
                    float[] fArray = new float[dimensionCount];
                    while (info2 < dimensionCount) {
                        int n8 = info2++;
                        fArray[n8] = ((AnimationVector)vectorValue).get$animation_core(n8);
                    }
                    vectorizedKeyframesSpec2 = vectorizedKeyframesSpec;
                    n4 = n5;
                    object2 = fArray;
                }
                vectorizedKeyframesSpec2[n4] = object2;
            }
            Object values = object;
            this.arcSpline = new ArcSpline(this.modes, this.times, (float[][])values);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var2_15;
        VectorizedKeyframeSpecElementInfo startValue;
        void posArray2;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        VectorizedKeyframeSpecElementInfo keyframe = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(clampedPlayTime);
        if (keyframe != null) {
            return keyframe.getVectorValue();
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue, initialVelocity);
        V v = this.valueVector;
        Intrinsics.checkNotNull(v);
        V valueVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime(clampedPlayTime);
            float[] posArray2 = this.posArray;
            this.arcSpline.getPos(easedTime, posArray2);
            int n = posArray2.length;
            for (int i = 0; i < n; ++i) {
                ((AnimationVector)valueVector).set$animation_core(i, posArray2[i]);
            }
            return valueVector;
        }
        int index = this.findEntryForTimeMillis((int)posArray2);
        float easedTime = this.getEasedTimeFromIndex(index, (int)posArray2, true);
        int timestampStart = this.timestamps.get(index);
        VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestampStart);
        VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo2 = vectorizedKeyframeSpecElementInfo;
        if (vectorizedKeyframeSpecElementInfo == null || (vectorizedKeyframeSpecElementInfo2 = vectorizedKeyframeSpecElementInfo2.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo2 = startValue;
        }
        startValue = vectorizedKeyframeSpecElementInfo2;
        int timestampEnd22 = this.timestamps.get(index + 1);
        VectorizedKeyframeSpecElementInfo timestampEnd22 = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestampEnd22);
        VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo3 = timestampEnd22;
        if (timestampEnd22 == null || (vectorizedKeyframeSpecElementInfo3 = vectorizedKeyframeSpecElementInfo3.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo3 = targetValue;
        }
        VectorizedKeyframeSpecElementInfo endValue = vectorizedKeyframeSpecElementInfo3;
        int n = ((AnimationVector)valueVector).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            void stop$iv;
            void start$iv;
            float f = ((AnimationVector)((Object)startValue)).get$animation_core(i);
            float f2 = ((AnimationVector)((Object)endValue)).get$animation_core(i);
            float fraction$iv = easedTime;
            ((AnimationVector)valueVector).set$animation_core(i, (float)(start$iv * (1.0f - fraction$iv) + stop$iv * fraction$iv));
        }
        return var2_15;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity22) {
        void var1_2;
        V initialVelocity22;
        void i2;
        float[] slopeArray;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity22, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity22;
        }
        this.init(initialValue, targetValue, initialVelocity22);
        V v = this.velocityVector;
        Intrinsics.checkNotNull(v);
        V velocityVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime((int)clampedPlayTime);
            slopeArray = this.slopeArray;
            this.arcSpline.getSlope(easedTime, slopeArray);
            int initialVelocity22 = slopeArray.length;
            for (int i2 = 0; i2 < initialVelocity22; ++i2) {
                ((AnimationVector)velocityVector).set$animation_core(i2, slopeArray[i2]);
            }
            return velocityVector;
        }
        void startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, slopeArray, i2, initialVelocity22);
        void endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, slopeArray, i2, initialVelocity22);
        int n = startNum.getSize$animation_core();
        for (int i3 = 0; i3 < n; ++i3) {
            ((AnimationVector)velocityVector).set$animation_core(i3, (startNum.get$animation_core(i3) - endNum.get$animation_core(i3)) * 1000.0f);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final float getEasedTime(int timeMillis) {
        void var1_1;
        void var2_2;
        int index = this.findEntryForTimeMillis(timeMillis);
        return this.getEasedTimeFromIndex((int)var2_2, (int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final float getEasedTimeFromIndex(int index, int timeMillis, boolean asFraction) {
        void var2_3;
        void var1_1;
        void var3_4;
        IntList intList = this.timestamps;
        if (index >= intList._size - 1) {
            return (float)timeMillis / 1000.0f;
        }
        int timeMin = this.timestamps.get(index);
        int timeMax = this.timestamps.get(index + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / 1000.0f;
        }
        int timeRange = timeMax - timeMin;
        Object object = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timeMin);
        if (object == null || (object = ((VectorizedKeyframeSpecElementInfo)object).getEasing()) == null) {
            object = this.defaultEasing;
        }
        Object easing = object;
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        if (var3_4 != false) {
            return easedFraction;
        }
        return ((float)var1_1 * var2_3 + (float)timeMin) / 1000.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final int findEntryForTimeMillis(int timeMillis) {
        void var1_1;
        int index = IntList.binarySearch$default((IntList)this.timestamps, (int)timeMillis, (int)0, (int)0, (int)6, null);
        if (index < -1) {
            return -(index + 2);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ VectorizedKeyframesSpec(IntList timestamps, IntObjectMap keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode, DefaultConstructorMarker $constructor_marker) {
        this((IntList)var1_1, (IntObjectMap<VectorizedKeyframeSpecElementInfo<V>>)var2_2, (int)var3_3, delayMillis, defaultEasing, initialArcMode);
        void var3_3;
        void var2_2;
        void var1_1;
    }
}

