/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\f\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\rJ\u001f\u0010\u0011\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0016\u0010\u0014\u001a\u00028\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00028\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0016\u0010\u0017\u001a\u00028\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Landroidx/compose/animation/core/VectorizedFloatDecaySpec;", "Landroidx/compose/animation/core/AnimationVector;", "V", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "floatDecaySpec", "<init>", "(Landroidx/compose/animation/core/FloatDecayAnimationSpec;)V", "", "playTimeNanos", "initialValue", "initialVelocity", "getValueFromNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getDurationNanos", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getVelocityFromNanos", "getTargetValue", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "targetVector", "", "absVelocityThreshold", "F", "getAbsVelocityThreshold", "()F"})
final class VectorizedFloatDecaySpec<V extends AnimationVector>
implements VectorizedDecayAnimationSpec<V> {
    public final FloatDecayAnimationSpec floatDecaySpec;
    private V valueVector;
    private V velocityVector;
    private V targetVector;
    private final float absVelocityThreshold;

    /*
     * WARNING - void declaration
     */
    public VectorizedFloatDecaySpec(FloatDecayAnimationSpec floatDecaySpec) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)floatDecaySpec, (String)"floatDecaySpec");
        this.floatDecaySpec = var1_1;
        this.absVelocityThreshold = this.floatDecaySpec.getAbsVelocityThreshold();
    }

    @Override
    public final float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(V initialValue, V initialVelocity) {
        void var3_3;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            maxDuration = Math.max(maxDuration, this.floatDecaySpec.getDurationNanos(((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        return (long)var3_3;
    }

    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    public final V getTargetValue(V initialValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.targetVector == null) {
            this.targetVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.targetVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.targetVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.floatDecaySpec.getTargetValue(((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.targetVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            v3 = null;
        }
        return v3;
    }
}

