/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationKt;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004BG\b\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\f\u0010\rBG\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\f\u0010\u000fJ\u0017\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u00008\u0000@@X\u0080\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u00008\u0000@@X\u0080\u000e\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u0011\u0010\t\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0016\u0010'\u001a\u00028\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00028\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0014\u0010\u000b\u001a\u00028\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R\u0014\u0010+\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00101\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0018\u00102\u001a\u0004\u0018\u00018\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010(R\u0014\u00105\u001a\u00028\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104"}, d2={"Landroidx/compose/animation/core/TargetBasedAnimation;", "T", "Landroidx/compose/animation/core/AnimationVector;", "V", "Landroidx/compose/animation/core/Animation;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "animationSpec", "Landroidx/compose/animation/core/TwoWayConverter;", "typeConverter", "initialValue", "targetValue", "initialVelocityVector", "<init>", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "Landroidx/compose/animation/core/AnimationSpec;", "(Landroidx/compose/animation/core/AnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "", "playTimeNanos", "getValueFromNanos", "(J)Ljava/lang/Object;", "getVelocityVectorFromNanos", "(J)Landroidx/compose/animation/core/AnimationVector;", "", "toString", "()Ljava/lang/String;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "Landroidx/compose/animation/core/TwoWayConverter;", "getTypeConverter", "()Landroidx/compose/animation/core/TwoWayConverter;", "value", "mutableTargetValue", "Ljava/lang/Object;", "setMutableTargetValue$animation_core", "(Ljava/lang/Object;)V", "mutableInitialValue", "setMutableInitialValue$animation_core", "getInitialValue", "()Ljava/lang/Object;", "getTargetValue", "initialValueVector", "Landroidx/compose/animation/core/AnimationVector;", "targetValueVector", "", "isInfinite", "()Z", "_durationNanos", "J", "getDurationNanos", "()J", "durationNanos", "_endVelocity", "getEndVelocity", "()Landroidx/compose/animation/core/AnimationVector;", "endVelocity"})
@SourceDebugExtension(value={"SMAP\nAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animation.kt\nandroidx/compose/animation/core/TargetBasedAnimation\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,497:1\n53#2,4:498\n1#3:502\n*S KotlinDebug\n*F\n+ 1 Animation.kt\nandroidx/compose/animation/core/TargetBasedAnimation\n*L\n274#1:498,4\n*E\n"})
public final class TargetBasedAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    public final VectorizedAnimationSpec<V> animationSpec;
    private final TwoWayConverter<T, V> typeConverter;
    private T mutableTargetValue;
    private T mutableInitialValue;
    private V initialValueVector;
    private V targetValueVector;
    private final V initialVelocityVector;
    private long _durationNanos;
    private V _endVelocity;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public TargetBasedAnimation(VectorizedAnimationSpec<V> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, V initialVelocityVector) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this.animationSpec = var1_1;
        this.typeConverter = var2_2;
        this.mutableTargetValue = targetValue;
        this.mutableInitialValue = initialValue;
        this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(initialValue);
        this.targetValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(targetValue);
        Object object = initialVelocityVector;
        if (object == null || (object = AnimationVectorsKt.copy(object)) == null) {
            void var3_3;
            object = AnimationVectorsKt.newInstance((AnimationVector)this.getTypeConverter().getConvertToVector().invoke((Object)var3_3));
        }
        this.initialVelocityVector = object;
        this._durationNanos = -1L;
    }

    @Override
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMutableTargetValue$animation_core(T value) {
        if (!Intrinsics.areEqual(this.mutableTargetValue, value)) {
            void var1_1;
            this.mutableTargetValue = value;
            this.targetValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke((Object)var1_1);
            this._endVelocity = null;
            this._durationNanos = -1L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setMutableInitialValue$animation_core(T value) {
        if (!Intrinsics.areEqual(value, this.mutableInitialValue)) {
            void var1_1;
            this.mutableInitialValue = value;
            this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke((Object)var1_1);
            this._endVelocity = null;
            this._durationNanos = -1L;
        }
    }

    public final T getInitialValue() {
        return this.mutableInitialValue;
    }

    @Override
    public final T getTargetValue() {
        return this.mutableTargetValue;
    }

    /*
     * WARNING - void declaration
     */
    public TargetBasedAnimation(AnimationSpec<T> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, V initialVelocityVector) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this(var1_1.vectorize(typeConverter), (TwoWayConverter<void, V>)var2_2, var3_3, (void)targetValue, initialVelocityVector);
    }

    public /* synthetic */ TargetBasedAnimation(AnimationSpec animationSpec, TwoWayConverter twoWayConverter, Object object, Object object2, AnimationVector animationVector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            animationVector = null;
        }
        this(animationSpec, twoWayConverter, object, object2, animationVector);
    }

    @Override
    public final boolean isInfinite() {
        return this.animationSpec.isInfinite();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T getValueFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var3_2;
            V it = this.animationSpec.getValueFromNanos(playTimeNanos, this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
            int n = ((AnimationVector)it).getSize$animation_core();
            for (int i = 0; i < n; ++i) {
                boolean bl = !Float.isNaN(((AnimationVector)it).get$animation_core(i));
                if (bl) continue;
                PreconditionsKt.throwIllegalStateException("AnimationVector cannot contain a NaN. " + it + ". Animation: " + this + ", playTimeNanos: " + playTimeNanos);
            }
            return (T)this.getTypeConverter().getConvertFromVector().invoke((Object)var3_2);
        }
        return this.getTargetValue();
    }

    @Override
    public final long getDurationNanos() {
        if (this._durationNanos < 0L) {
            this._durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
        }
        return this._durationNanos;
    }

    /*
     * WARNING - void declaration
     */
    private final V getEndVelocity() {
        V v = this._endVelocity;
        if (v == null) {
            void var2_2;
            V v2;
            V it = v2 = this.animationSpec.getEndVelocity(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
            this._endVelocity = var2_2;
            v = v2;
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            return this.animationSpec.getVelocityFromNanos((long)var1_1, this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
        }
        return this.getEndVelocity();
    }

    public final String toString() {
        return "TargetBasedAnimation: " + this.getInitialValue() + " -> " + this.getTargetValue() + ",initial velocity: " + this.initialVelocityVector + ", duration: " + AnimationKt.getDurationMillis(this) + " ms,animationSpec: " + this.animationSpec;
    }
}

