/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Motion;
import androidx.compose.animation.core.PreconditionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R$\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0005R*\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0005"}, d2={"Landroidx/compose/animation/core/SpringSimulation;", "", "", "finalPosition", "<init>", "(F)V", "lastDisplacement", "lastVelocity", "", "timeElapsed", "Landroidx/compose/animation/core/Motion;", "updateValues-IJZedt4$animation_core", "(FFJ)J", "updateValues", "F", "setFinalPosition", "", "naturalFreq", "D", "value", "getStiffness", "()F", "setStiffness", "stiffness", "dampingRatio", "getDampingRatio", "setDampingRatio"})
@SourceDebugExtension(value={"SMAP\nSpringSimulation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n+ 2 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulationKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,152:1\n38#2:153\n53#3,3:154\n*S KotlinDebug\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n*L\n149#1:153\n149#1:154,3\n*E\n"})
public final class SpringSimulation {
    private float finalPosition;
    private double naturalFreq;
    private float dampingRatio;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SpringSimulation(float finalPosition) {
        void var1_1;
        this.finalPosition = var1_1;
        this.naturalFreq = Math.sqrt(50.0);
        this.dampingRatio = 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFinalPosition(float f) {
        void var1_1;
        this.finalPosition = var1_1;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStiffness(float value) {
        void var1_1;
        if (this.getStiffness() <= 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt((double)var1_1);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDampingRatio(float value) {
        void var1_1;
        if (value < 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final long updateValues-IJZedt4$animation_core(float lastDisplacement, float lastVelocity, long timeElapsed) {
        void val1$iv$iv;
        void value$iv;
        double currentVelocity;
        double displacement;
        void var3_3;
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)var3_3 / 1000.0;
        double dampingRatioSquared = (double)this.dampingRatio * (double)this.dampingRatio;
        double r = (double)(-this.dampingRatio) * this.naturalFreq;
        if (this.dampingRatio > 1.0f) {
            double s = this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
            double gammaPlus = r + s;
            double gammaMinus = r - s;
            double coeffB = (gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (gammaMinus - gammaPlus);
            double coeffA = (double)adjustedDisplacement - coeffB;
            displacement = coeffA * Math.exp(gammaMinus * deltaT) + coeffB * Math.exp(gammaPlus * deltaT);
            currentVelocity = coeffA * gammaMinus * Math.exp(gammaMinus * deltaT) + coeffB * gammaPlus * Math.exp(gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            double nFdT = -this.naturalFreq * deltaT;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT) * -this.naturalFreq + coeffB * Math.exp(nFdT);
        } else {
            void var2_2;
            void var1_1;
            double dampedFreq = this.naturalFreq * Math.sqrt(1.0 - dampingRatioSquared);
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / dampedFreq * (-r * (double)var1_1 + (double)var2_2);
            double dFdT = dampedFreq * deltaT;
            displacement = Math.exp(r * deltaT) * ((double)cosCoeff * Math.cos(dFdT) + sinCoeff * Math.sin(dFdT));
            currentVelocity = displacement * r + Math.exp(r * deltaT) * (-dampedFreq * (double)cosCoeff * Math.sin(dFdT) + dampedFreq * sinCoeff * Math.cos(dFdT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        float cosCoeff = newValue;
        float velocity$iv = newVelocity;
        void dFdT = value$iv;
        float val2$iv$iv = velocity$iv;
        long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
        long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
        return Motion.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }
}

