/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\u001a5\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a5\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\n\u001a7\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a/\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a7\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0010\u001aG\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017"}, d2={"", "stiffness", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "", "estimateAnimationDurationMillis", "(FFFFF)J", "", "(DDDDD)J", "firstRootReal", "firstRootImaginary", "p0", "v0", "estimateUnderDamped", "(DDDDD)D", "estimateCriticallyDamped", "(DDDD)D", "secondRootReal", "estimateOverDamped", "initialPosition", "estimateDurationInternal", "(DDDDDDD)J"})
@SourceDebugExtension(value={"SMAP\nSpringEstimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,346:1\n345#1:347\n345#1:349\n342#1:351\n345#1:352\n345#1:354\n342#1:356\n150#2:348\n150#2:350\n150#2:353\n150#2:355\n150#2:357\n*S KotlinDebug\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n172#1:347\n173#1:349\n212#1:351\n246#1:352\n247#1:354\n292#1:356\n172#1:348\n173#1:350\n246#1:353\n247#1:355\n345#1:357\n*E\n"})
public final class SpringEstimationKt {
    /*
     * WARNING - void declaration
     */
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        if (dampingRatio == 0.0f) {
            return 9223372036854L;
        }
        return SpringEstimationKt.estimateAnimationDurationMillis((double)f, (double)var1_1, (double)var2_2, (double)var3_3, (double)delta);
    }

    /*
     * WARNING - void declaration
     */
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        void var2_2;
        double d;
        double d2;
        double dampingCoefficient = dampingRatio * 2.0 * Math.sqrt(stiffness);
        double partialRoot = dampingCoefficient * dampingCoefficient - d2 * 4.0;
        double partialRootReal = d < 0.0 ? 0.0 : Math.sqrt(partialRoot);
        double partialRootImaginary = partialRoot < 0.0 ? Math.sqrt(Math.abs(partialRoot)) : 0.0;
        double firstRootReal = (-dampingCoefficient + partialRootReal) * 0.5;
        double firstRootImaginary = partialRootImaginary * 0.5;
        double secondRootReal = (-dampingCoefficient - partialRootReal) * 0.5;
        return SpringEstimationKt.estimateDurationInternal(firstRootReal, firstRootImaginary, secondRootReal, (double)var2_2, initialVelocity, initialDisplacement, delta);
    }

    /*
     * WARNING - void declaration
     */
    private static final double estimateUnderDamped(double firstRootReal, double firstRootImaginary, double p0, double v0, double delta) {
        void var2_2;
        double r = firstRootReal;
        double c1 = p0;
        double c2 = (v0 - r * c1) / var2_2;
        double d = c1;
        double d2 = c2;
        double c = Math.sqrt(d * d + d2 * d2);
        return Math.log(delta / c) / r;
    }

    /*
     * WARNING - void declaration
     */
    private static final double estimateCriticallyDamped(double firstRootReal, double p0, double v0, double delta) {
        double d;
        double d2;
        double d3;
        double guess;
        void var2_2;
        double r = firstRootReal;
        void c1 = var2_2;
        double c2 = v0 - r * c1;
        double t1 = Math.log(Math.abs(delta / c1)) / r;
        double t = guess = Math.log(Math.abs(delta / c2));
        for (int i = 0; i < 6; ++i) {
            t = guess - Math.log(Math.abs(t / r));
        }
        double t2 = t / r;
        double d4 = d3 = t1;
        if (!((Double.doubleToRawLongBits(d3) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t2;
        } else {
            d4 = d3 = t2;
            d2 = !((Double.doubleToRawLongBits(d3) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        void xInflection = c1 * Math.exp(r * tInflection) + c2 * tInflection * Math.exp(r * tInflection);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -xInflection < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            tCurr = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t3;
            double x$iv;
            double tLast = tCurr;
            double d5 = x$iv = tCurr;
            double d6 = x$iv;
            void var37_21 = (c1 + c2 * t3) * Math.exp(r * t3) + signedDelta;
            t3 = x$iv;
            double d7 = (c2 * (r * t3 + 1.0) + c1 * r) * Math.exp(r * t3);
            tCurr = d6 - var37_21 / d7;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    /*
     * WARNING - void declaration
     */
    private static final double estimateOverDamped(double firstRootReal, double secondRootReal, double p0, double v0, double delta) {
        double signedDelta;
        double d;
        double d2;
        double d3;
        void var2_3;
        double r1 = firstRootReal;
        void r2 = var2_3;
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double t1 = Math.log(Math.abs(delta / c1)) / r1;
        double t2 = Math.log(Math.abs(delta / c2)) / r2;
        double d4 = d3 = t1;
        if (!((Double.doubleToRawLongBits(d3) & Long.MAX_VALUE) < 0x7FF0000000000000L)) {
            d2 = t2;
        } else {
            d4 = d3 = t2;
            d2 = !((Double.doubleToRawLongBits(d3) & Long.MAX_VALUE) < 0x7FF0000000000000L) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = Math.log(c1 * r1 / (-c2 * r2)) / (r2 - r1);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection(c1, r1, tInflection, c2, (double)r2) < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            tCurr = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
            d = signedDelta = delta;
        }
        if (Math.abs(c1 * r1 * Math.exp(r1 * tCurr) + c2 * r2 * Math.exp((double)(r2 * tCurr))) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t;
            double x$iv;
            double tLast = tCurr;
            double d5 = x$iv = tCurr;
            double d6 = x$iv;
            double d7 = c1 * Math.exp(r1 * t) + c2 * Math.exp((double)(r2 * t)) + signedDelta;
            t = x$iv;
            double d8 = c1 * r1 * Math.exp(r1 * t) + c2 * r2 * Math.exp((double)(r2 * t));
            tCurr = d6 - d7 / d8;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    /*
     * WARNING - void declaration
     */
    private static final long estimateDurationInternal(double firstRootReal, double firstRootImaginary, double secondRootReal, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        double d;
        void var2_1;
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(firstRootReal, secondRootReal, p0, v0, delta) : (dampingRatio < 1.0 ? SpringEstimationKt.estimateUnderDamped(firstRootReal, (double)var2_1, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(d, p0, v0, delta))) * 1000.0);
    }

    /*
     * WARNING - void declaration
     */
    private static final double estimateOverDamped$xInflection(double c1, double r1, double tInflection, double c2, double r2) {
        void var2_2;
        return c1 * Math.exp((double)(var2_2 * tInflection)) + c2 * Math.exp(r2 * tInflection);
    }
}

