/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.FloatDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0012"}, d2={"Landroidx/compose/animation/core/FloatExponentialDecaySpec;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "", "frictionMultiplier", "absVelocityThreshold", "<init>", "(FF)V", "", "playTimeNanos", "initialValue", "initialVelocity", "getValueFromNanos", "(JFF)F", "getVelocityFromNanos", "getDurationNanos", "(FF)J", "getTargetValue", "(FF)F", "F", "getAbsVelocityThreshold", "()F", "friction"})
public final class FloatExponentialDecaySpec
implements FloatDecayAnimationSpec {
    private final float absVelocityThreshold;
    private final float friction;

    /*
     * WARNING - void declaration
     */
    public FloatExponentialDecaySpec(float frictionMultiplier, float absVelocityThreshold) {
        void var1_1;
        void var2_2;
        this.absVelocityThreshold = Math.max(1.0E-7f, Math.abs((float)var2_2));
        this.friction = -4.2f * Math.max(1.0E-4f, (float)var1_1);
    }

    public /* synthetic */ FloatExponentialDecaySpec(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        this(f, f2);
    }

    @Override
    public final float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getValueFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        void var3_2;
        long playTimeMillis = playTimeNanos / 1000000L;
        return (float)(var3_2 - initialVelocity / this.friction + initialVelocity / this.friction * (float)Math.exp(this.friction * (float)playTimeMillis / 1000.0f));
    }

    @Override
    public final float getVelocityFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        return initialVelocity * (float)Math.exp((float)playTimeMillis / 1000.0f * this.friction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(float initialValue, float initialVelocity) {
        void var2_2;
        return (long)(1000.0f * (float)Math.log(this.getAbsVelocityThreshold() / Math.abs((float)var2_2)) / this.friction) * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float getTargetValue(float initialValue, float initialVelocity) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (Math.abs(initialVelocity) <= this.getAbsVelocityThreshold()) {
            return initialValue;
        }
        double duration = Math.log(Math.abs(this.getAbsVelocityThreshold() / initialVelocity)) / (double)this.friction * 1000.0;
        return (float)(var1_1 - initialVelocity / this.friction + var2_2 / this.friction * (float)Math.exp((double)this.friction * var3_3 / 1000.0));
    }

    public FloatExponentialDecaySpec() {
        this(0.0f, 0.0f, 3, null);
    }
}

