/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B9\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000b\u0010\fB;\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0017\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0015R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00078\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00028\u00008\u0006\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0019R\u0014\u0010\u001a\u001a\u00028\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00028\u00018\u0006\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001bR\u0014\u0010\u001c\u001a\u00028\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u001a\u0010\u001d\u001a\u00028\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010%\u001a\u00020$8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b%\u0010'"}, d2={"Landroidx/compose/animation/core/DecayAnimation;", "T", "Landroidx/compose/animation/core/AnimationVector;", "V", "Landroidx/compose/animation/core/Animation;", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "animationSpec", "Landroidx/compose/animation/core/TwoWayConverter;", "typeConverter", "initialValue", "initialVelocityVector", "<init>", "(Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "Landroidx/compose/animation/core/DecayAnimationSpec;", "(Landroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "", "playTimeNanos", "getValueFromNanos", "(J)Ljava/lang/Object;", "getVelocityVectorFromNanos", "(J)Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "Landroidx/compose/animation/core/TwoWayConverter;", "getTypeConverter", "()Landroidx/compose/animation/core/TwoWayConverter;", "Ljava/lang/Object;", "initialValueVector", "Landroidx/compose/animation/core/AnimationVector;", "endVelocity", "targetValue", "getTargetValue", "()Ljava/lang/Object;", "durationNanos", "J", "getDurationNanos", "()J", "", "isInfinite", "Z", "()Z"})
public final class DecayAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    private final VectorizedDecayAnimationSpec<V> animationSpec;
    private final TwoWayConverter<T, V> typeConverter;
    public final T initialValue;
    private final V initialValueVector;
    public final V initialVelocityVector;
    private final V endVelocity;
    private final T targetValue;
    private final long durationNanos;
    private final boolean isInfinite;

    /*
     * WARNING - void declaration
     */
    public DecayAnimation(VectorizedDecayAnimationSpec<V> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, V initialVelocityVector) {
        void var3_5;
        void var2_3;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this.animationSpec = animationSpec;
        this.typeConverter = var2_3;
        this.initialValue = var3_5;
        this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(this.initialValue);
        this.initialVelocityVector = AnimationVectorsKt.copy(initialVelocityVector);
        this.targetValue = this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getTargetValue(this.initialValueVector, initialVelocityVector));
        this.durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, initialVelocityVector);
        this.endVelocity = AnimationVectorsKt.copy(this.animationSpec.getVelocityFromNanos(this.getDurationNanos(), this.initialValueVector, initialVelocityVector));
        int n = ((AnimationVector)this.endVelocity).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            V v = this.endVelocity;
            ((AnimationVector)v).set$animation_core(i, RangesKt.coerceIn((float)((AnimationVector)v).get$animation_core(i), (float)(-this.animationSpec.getAbsVelocityThreshold()), (float)this.animationSpec.getAbsVelocityThreshold()));
        }
    }

    @Override
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public final T getTargetValue() {
        return this.targetValue;
    }

    @Override
    public final long getDurationNanos() {
        return this.durationNanos;
    }

    @Override
    public final boolean isInfinite() {
        return this.isInfinite;
    }

    /*
     * WARNING - void declaration
     */
    public DecayAnimation(DecayAnimationSpec<T> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, V initialVelocityVector) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        this(var1_1.vectorize(typeConverter), (TwoWayConverter<void, V>)var2_2, var3_3, initialVelocityVector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T getValueFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            return (T)this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getValueFromNanos((long)var1_1, this.initialValueVector, this.initialVelocityVector));
        }
        return this.getTargetValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            return this.animationSpec.getVelocityFromNanos((long)var1_1, this.initialValueVector, this.initialVelocityVector);
        }
        return this.endVelocity;
    }
}

