/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.videoplayer.ui.progress;

import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.openani.mediamp.metadata.Chapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B}\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0002\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u0012!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017R/\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0018R/\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0018R\u001b\u0010\u0004\u001a\u00020\u00038FX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u0005\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001cR!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010!R+\u0010\u0014\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00128B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010\u0015R\u001b\u0010*\u001a\u00020(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001a\u001a\u0004\b*\u0010+R\u001b\u0010.\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001a\u001a\u0004\b-\u0010&"}, d2={"Lme/him188/ani/app/videoplayer/ui/progress/PlayerProgressSliderState;", "", "Lkotlin/Function0;", "", "currentPositionMillis", "totalDurationMillis", "", "Lorg/openani/mediamp/metadata/Chapter;", "chapters", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "positionMillis", "", "onPreview", "onPreviewFinished", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "", "ratio", "previewPositionRatio", "(F)V", "finishPreview", "()V", "Lkotlin/jvm/functions/Function1;", "currentPositionMillis$delegate", "Landroidx/compose/runtime/State;", "getCurrentPositionMillis", "()J", "totalDurationMillis$delegate", "getTotalDurationMillis", "chapters$delegate", "getChapters", "()Ljava/util/List;", "<set-?>", "previewPositionRatio$delegate", "Landroidx/compose/runtime/MutableFloatState;", "getPreviewPositionRatio", "()F", "setPreviewPositionRatio", "", "isPreviewing$delegate", "isPreviewing", "()Z", "displayPositionRatio$delegate", "getDisplayPositionRatio", "displayPositionRatio"})
@SourceDebugExtension(value={"SMAP\nMediaProgressSlider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaProgressSlider.kt\nme/him188/ani/app/videoplayer/ui/progress/PlayerProgressSliderState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n*L\n1#1,597:1\n85#2:598\n85#2:599\n85#2:600\n85#2:604\n85#2:605\n81#3:601\n114#3,2:602\n*S KotlinDebug\n*F\n+ 1 MediaProgressSlider.kt\nme/him188/ani/app/videoplayer/ui/progress/PlayerProgressSliderState\n*L\n103#1:598\n104#1:599\n105#1:600\n109#1:604\n125#1:605\n107#1:601\n107#1:602,2\n*E\n"})
public final class PlayerProgressSliderState {
    private final Function1<Long, Unit> onPreview;
    private final Function1<Long, Unit> onPreviewFinished;
    private final State currentPositionMillis$delegate;
    private final State totalDurationMillis$delegate;
    private final State chapters$delegate;
    private final MutableFloatState previewPositionRatio$delegate;
    private final State isPreviewing$delegate;
    private final State displayPositionRatio$delegate;

    /*
     * WARNING - void declaration
     */
    public PlayerProgressSliderState(Function0<Long> currentPositionMillis, Function0<Long> totalDurationMillis, Function0<? extends List<Chapter>> chapters, Function1<? super Long, Unit> onPreview, Function1<? super Long, Unit> onPreviewFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(currentPositionMillis, (String)"currentPositionMillis");
        Intrinsics.checkNotNullParameter(totalDurationMillis, (String)"totalDurationMillis");
        Intrinsics.checkNotNullParameter(chapters, (String)"chapters");
        Intrinsics.checkNotNullParameter(onPreview, (String)"onPreview");
        Intrinsics.checkNotNullParameter(onPreviewFinished, (String)"onPreviewFinished");
        this.onPreview = onPreview;
        this.onPreviewFinished = onPreviewFinished;
        this.currentPositionMillis$delegate = SnapshotStateKt.derivedStateOf((Function0)var1_1);
        this.totalDurationMillis$delegate = SnapshotStateKt.derivedStateOf((Function0)var2_2);
        this.chapters$delegate = SnapshotStateKt.derivedStateOf((Function0)var3_3);
        this.previewPositionRatio$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)Float.NaN);
        this.isPreviewing$delegate = SnapshotStateKt.derivedStateOf(() -> PlayerProgressSliderState.isPreviewing_delegate$lambda$0(this));
        this.displayPositionRatio$delegate = SnapshotStateKt.derivedStateOf(() -> PlayerProgressSliderState.displayPositionRatio_delegate$lambda$0(this));
    }

    public final long getCurrentPositionMillis() {
        State state = this.currentPositionMillis$delegate;
        return ((Number)state.getValue()).longValue();
    }

    public final long getTotalDurationMillis() {
        State state = this.totalDurationMillis$delegate;
        return ((Number)state.getValue()).longValue();
    }

    public final List<Chapter> getChapters() {
        State state = this.chapters$delegate;
        return (List)state.getValue();
    }

    private final float getPreviewPositionRatio() {
        FloatState floatState = (FloatState)this.previewPositionRatio$delegate;
        return floatState.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setPreviewPositionRatio(float f) {
        void var1_1;
        MutableFloatState mutableFloatState = this.previewPositionRatio$delegate;
        mutableFloatState.setFloatValue((float)var1_1);
    }

    public final boolean isPreviewing() {
        State state = this.isPreviewing$delegate;
        return (Boolean)state.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void previewPositionRatio(float ratio) {
        void var1_1;
        this.setPreviewPositionRatio(ratio);
        this.onPreview.invoke((Object)MathKt.roundToLong((float)((float)this.getTotalDurationMillis() * var1_1)));
    }

    public final float getDisplayPositionRatio() {
        State state = this.displayPositionRatio$delegate;
        return ((Number)state.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void finishPreview() {
        void var1_1;
        float ratio = this.getPreviewPositionRatio();
        if (Float.isNaN(ratio)) {
            return;
        }
        this.onPreviewFinished.invoke((Object)MathKt.roundToLong((float)(var1_1 * (float)this.getTotalDurationMillis())));
        this.setPreviewPositionRatio(Float.NaN);
    }

    private static final boolean isPreviewing_delegate$lambda$0(PlayerProgressSliderState this$0) {
        return !Float.isNaN(this$0.getPreviewPositionRatio());
    }

    /*
     * WARNING - void declaration
     */
    private static final float displayPositionRatio_delegate$lambda$0(PlayerProgressSliderState this$0) {
        void var2_2;
        PlayerProgressSliderState playerProgressSliderState;
        float previewPositionRatio = this$0.getPreviewPositionRatio();
        if (!Float.isNaN(previewPositionRatio)) {
            void var1_1;
            return (float)var1_1;
        }
        long total = this$0.getTotalDurationMillis();
        if (total == 0L) {
            return 0.0f;
        }
        return (float)playerProgressSliderState.getCurrentPositionMillis() / (float)var2_2;
    }
}

