/*
 * Decompiled with CFR 0.152.
 */
package coil3.memory;

import coil3.BitmapImage;
import coil3.EventListener;
import coil3.ImageLoader;
import coil3.decode.DataSource;
import coil3.intercept.EngineInterceptor;
import coil3.intercept.Interceptor;
import coil3.memory.MemoryCache;
import coil3.request.ImageRequest;
import coil3.request.ImageRequestsKt;
import coil3.request.Options;
import coil3.request.RequestService;
import coil3.request.SuccessResult;
import coil3.size.Dimension;
import coil3.size.Precision;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeKt;
import coil3.util.Logger;
import coil3.util.UtilsKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u0000 42\u00020\u0001:\u00014B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ7\u0010 \u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010!\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ'\u0010$\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J-\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010+R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010-R\u0018\u0010.\u001a\u00020\u001d*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001a\u00103\u001a\u0004\u0018\u000100*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102"}, d2={"Lcoil3/memory/MemoryCacheService;", "", "Lcoil3/ImageLoader;", "imageLoader", "Lcoil3/request/RequestService;", "requestService", "Lcoil3/util/Logger;", "logger", "<init>", "(Lcoil3/ImageLoader;Lcoil3/request/RequestService;Lcoil3/util/Logger;)V", "Lcoil3/request/ImageRequest;", "request", "mappedData", "Lcoil3/request/Options;", "options", "Lcoil3/EventListener;", "eventListener", "Lcoil3/memory/MemoryCache$Key;", "newCacheKey", "(Lcoil3/request/ImageRequest;Ljava/lang/Object;Lcoil3/request/Options;Lcoil3/EventListener;)Lcoil3/memory/MemoryCache$Key;", "cacheKey", "Lcoil3/size/Size;", "size", "Lcoil3/size/Scale;", "scale", "Lcoil3/memory/MemoryCache$Value;", "getCacheValue", "(Lcoil3/request/ImageRequest;Lcoil3/memory/MemoryCache$Key;Lcoil3/size/Size;Lcoil3/size/Scale;)Lcoil3/memory/MemoryCache$Value;", "cacheValue", "", "isCacheValueValid$coil_core", "(Lcoil3/request/ImageRequest;Lcoil3/memory/MemoryCache$Key;Lcoil3/memory/MemoryCache$Value;Lcoil3/size/Size;Lcoil3/size/Scale;)Z", "isCacheValueValid", "isCacheValueValidForSize", "Lcoil3/intercept/EngineInterceptor$ExecuteResult;", "result", "setCacheValue", "(Lcoil3/memory/MemoryCache$Key;Lcoil3/request/ImageRequest;Lcoil3/intercept/EngineInterceptor$ExecuteResult;)Z", "Lcoil3/intercept/Interceptor$Chain;", "chain", "Lcoil3/request/SuccessResult;", "newResult", "(Lcoil3/intercept/Interceptor$Chain;Lcoil3/request/ImageRequest;Lcoil3/memory/MemoryCache$Key;Lcoil3/memory/MemoryCache$Value;)Lcoil3/request/SuccessResult;", "Lcoil3/ImageLoader;", "Lcoil3/request/RequestService;", "Lcoil3/util/Logger;", "isSampled", "(Lcoil3/memory/MemoryCache$Value;)Z", "", "getDiskCacheKey", "(Lcoil3/memory/MemoryCache$Value;)Ljava/lang/String;", "diskCacheKey", "Companion"})
@SourceDebugExtension(value={"SMAP\nMemoryCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCacheService.kt\ncoil3/memory/MemoryCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncoil3/util/LoggingKt\n+ 4 Dimension.kt\ncoil3/size/DimensionKt\n*L\n1#1,249:1\n1#2:250\n68#3,4:251\n68#3,4:255\n68#3,4:263\n68#3,4:267\n43#4:259\n43#4:260\n43#4:261\n43#4:262\n*S KotlinDebug\n*F\n+ 1 MemoryCacheService.kt\ncoil3/memory/MemoryCacheService\n*L\n86#1:251,4\n111#1:255,4\n177#1:263,4\n187#1:267,4\n133#1:259\n134#1:260\n137#1:261\n138#1:262\n*E\n"})
public final class MemoryCacheService {
    public static final Companion Companion = new Companion(null);
    private final ImageLoader imageLoader;
    private final RequestService requestService;
    private final Logger logger;
    private static final String TAG = "MemoryCacheService";
    public static final String EXTRA_SIZE = "coil#size";
    public static final String EXTRA_IS_SAMPLED = "coil#is_sampled";
    public static final String EXTRA_DISK_CACHE_KEY = "coil#disk_cache_key";

    /*
     * WARNING - void declaration
     */
    public MemoryCacheService(ImageLoader imageLoader, RequestService requestService, Logger logger) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.imageLoader = var1_1;
        this.requestService = var2_2;
        this.logger = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final MemoryCache.Key newCacheKey(ImageRequest request, Object mappedData, Options options, EventListener eventListener) {
        void var2_2;
        void var1_1;
        if (request.getMemoryCacheKey() != null) {
            return new MemoryCache.Key(request.getMemoryCacheKey(), request.getMemoryCacheKeyExtras());
        }
        eventListener.keyStart(request, mappedData);
        String key = UtilsKt.key(this.imageLoader.getComponents(), mappedData, options, this.logger, TAG);
        eventListener.keyEnd(request, key);
        if (key == null) {
            return null;
        }
        if (!((Collection)ImageRequestsKt.getTransformations(request)).isEmpty()) {
            void var3_3;
            Map extras = MapsKt.toMutableMap(request.getMemoryCacheKeyExtras());
            extras.put(EXTRA_SIZE, var3_3.getSize().toString());
            return new MemoryCache.Key(key, (Map<String, String>)var1_1);
        }
        return new MemoryCache.Key((String)var2_2, var1_1.getMemoryCacheKeyExtras());
    }

    /*
     * WARNING - void declaration
     */
    public final MemoryCache.Value getCacheValue(ImageRequest request, MemoryCache.Key cacheKey, Size size, Scale scale) {
        MemoryCache.Value value;
        if (!request.getMemoryCachePolicy().getReadEnabled()) {
            return null;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        MemoryCache.Value value2 = value = memoryCache != null ? memoryCache.get(cacheKey) : null;
        if (value2 != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            value = value2;
            MemoryCache.Value it = value2;
            if (this.isCacheValueValid$coil_core((ImageRequest)var1_1, (MemoryCache.Key)var2_2, it, (Size)var3_3, scale)) {
                return value;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCacheValueValid$coil_core(ImageRequest request, MemoryCache.Key cacheKey, MemoryCache.Value cacheValue, Size size, Scale scale) {
        void var1_1;
        void var3_3;
        void var2_2;
        Logger.Level level;
        if (!this.requestService.isCacheValueValidForHardware((ImageRequest)request, (MemoryCache.Value)cacheValue)) {
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                cacheKey = logger;
                cacheValue = TAG;
                Logger.Level level$iv = Logger.Level.Debug;
                if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                    level = level$iv;
                    request = ((ImageRequest)request).getData() + ": Cached bitmap is hardware-backed, which is incompatible with the request.";
                    var2_2.log((String)var3_3, level, (String)request, null);
                }
            }
            return false;
        }
        return this.isCacheValueValidForSize((ImageRequest)var1_1, (MemoryCache.Key)var2_2, (MemoryCache.Value)var3_3, (Size)((Object)level), scale);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValueValidForSize(ImageRequest request, MemoryCache.Key cacheKey, MemoryCache.Value cacheValue, Size size, Scale scale) {
        int difference2;
        double multiplier;
        void tag$iv;
        String cacheKeySize = cacheKey.getExtras().get(EXTRA_SIZE);
        if (cacheKeySize != null) {
            if (Intrinsics.areEqual((Object)cacheKeySize, (Object)((Size)size).toString())) {
                return true;
            }
            Logger logger = this.logger;
            if (logger != null) {
                void $this$log$iv;
                Logger logger2 = logger;
                cacheValue = TAG;
                Logger.Level level$iv = Logger.Level.Debug;
                if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                    Logger.Level level = level$iv;
                    scale = tag$iv;
                    tag$iv = $this$log$iv;
                    request = ((ImageRequest)request).getData() + ": Memory cached image's size (" + cacheKeySize + ") does not exactly match the target size (" + size + ").";
                    tag$iv.log((String)((Object)scale), level, (String)request, null);
                }
            }
            return false;
        }
        if (!this.isSampled((MemoryCache.Value)tag$iv) && (SizeKt.isOriginal((Size)size) || ((ImageRequest)request).getPrecision() == Precision.INEXACT)) {
            return true;
        }
        int srcWidth = tag$iv.getImage().getWidth();
        int srcHeight = tag$iv.getImage().getHeight();
        Size maxSize = tag$iv.getImage() instanceof BitmapImage ? ImageRequestsKt.getMaxBitmapSize((ImageRequest)request) : Size.ORIGINAL;
        Dimension $this$pxOrElse$iv22 = ((Size)size).getWidth();
        int $this$pxOrElse$iv22 = $this$pxOrElse$iv22 instanceof Dimension.Pixels ? ((Dimension.Pixels)$this$pxOrElse$iv22).unbox-impl() : Integer.MAX_VALUE;
        Dimension $this$pxOrElse$iv32 = maxSize.getWidth();
        int $this$pxOrElse$iv32 = $this$pxOrElse$iv32 instanceof Dimension.Pixels ? ((Dimension.Pixels)$this$pxOrElse$iv32).unbox-impl() : Integer.MAX_VALUE;
        int dstWidth = Math.min($this$pxOrElse$iv22, $this$pxOrElse$iv32);
        Dimension $this$pxOrElse$iv42 = ((Size)size).getHeight();
        int $this$pxOrElse$iv42 = $this$pxOrElse$iv42 instanceof Dimension.Pixels ? ((Dimension.Pixels)$this$pxOrElse$iv42).unbox-impl() : Integer.MAX_VALUE;
        Dimension $this$pxOrElse$iv = maxSize.getHeight();
        int n = $this$pxOrElse$iv instanceof Dimension.Pixels ? ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl() : Integer.MAX_VALUE;
        int dstHeight = Math.min($this$pxOrElse$iv42, n);
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        switch (WhenMappings.$EnumSwitchMapping$0[(dstWidth != Integer.MAX_VALUE && dstHeight != Integer.MAX_VALUE ? scale : Scale.FIT).ordinal()]) {
            case 1: {
                if (widthPercent > heightPercent) {
                    multiplier = widthPercent;
                    difference2 = Math.abs(dstWidth - srcWidth);
                    break;
                }
                multiplier = heightPercent;
                difference2 = Math.abs(dstHeight - srcHeight);
                break;
            }
            case 2: {
                if (widthPercent < heightPercent) {
                    multiplier = widthPercent;
                    difference2 = Math.abs(dstWidth - srcWidth);
                    break;
                }
                multiplier = heightPercent;
                difference2 = Math.abs(dstHeight - srcHeight);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (difference2 <= 1) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[((ImageRequest)request).getPrecision().ordinal()]) {
            case 1: {
                String tag$iv2;
                Object level$iv;
                if (multiplier == 1.0) {
                    return true;
                }
                Logger logger = this.logger;
                if (logger != null) {
                    void $this$log$iv;
                    Logger difference2 = logger;
                    size = TAG;
                    level$iv = Logger.Level.Debug;
                    if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                        Logger.Level level = level$iv;
                        level$iv = tag$iv2;
                        request = ((ImageRequest)request).getData() + ": Memory cached image's size (" + srcWidth + ", " + srcHeight + ") does not exactly match the target size (" + dstWidth + ", " + dstHeight + ").";
                        $this$log$iv.log((String)level$iv, level, (String)request, null);
                    }
                }
                return false;
            }
            case 2: {
                String tag$iv2;
                Object level$iv;
                if (multiplier <= 1.0) {
                    return true;
                }
                Logger logger = this.logger;
                if (logger != null) {
                    Logger $this$log$iv = logger;
                    tag$iv2 = TAG;
                    level$iv = Logger.Level.Debug;
                    if ($this$log$iv.getMinLevel().compareTo((Enum)level$iv) <= 0) {
                        void var3_7;
                        void var2_3;
                        String string;
                        Logger.Level level = level$iv;
                        String string2 = tag$iv2;
                        string = ((ImageRequest)((Object)string)).getData() + ": Memory cached image's size (" + (int)var2_3 + ", " + srcHeight + ") is smaller than the target size (" + dstWidth + ", " + dstHeight + ").";
                        var3_7.log(string2, level, string, null);
                    }
                }
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setCacheValue(MemoryCache.Key cacheKey, ImageRequest request, EngineInterceptor.ExecuteResult result2) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (cacheKey == null || !request.getMemoryCachePolicy().getWriteEnabled() || !result2.getImage().getShareable()) {
            return false;
        }
        MemoryCache memoryCache = this.imageLoader.getMemoryCache();
        if (memoryCache == null) {
            return false;
        }
        MemoryCache memoryCache2 = memoryCache;
        Map extras = new LinkedHashMap();
        extras.put(EXTRA_IS_SAMPLED, result2.isSampled());
        String string = result2.getDiskCacheKey();
        if (string != null) {
            String it = string;
            extras.put(EXTRA_DISK_CACHE_KEY, it);
        }
        var2_2.set((MemoryCache.Key)var1_1, new MemoryCache.Value(var3_3.getImage(), extras));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final SuccessResult newResult(Interceptor.Chain chain, ImageRequest request, MemoryCache.Key cacheKey, MemoryCache.Value cacheValue) {
        void var1_1;
        void var3_3;
        void var2_2;
        return new SuccessResult(cacheValue.getImage(), (ImageRequest)var2_2, DataSource.MEMORY_CACHE, (MemoryCache.Key)var3_3, this.getDiskCacheKey(cacheValue), this.isSampled(cacheValue), UtilsKt.isPlaceholderCached((Interceptor.Chain)var1_1));
    }

    private final boolean isSampled(MemoryCache.Value $this$isSampled) {
        Object object = $this$isSampled.getExtras().get(EXTRA_IS_SAMPLED);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private final String getDiskCacheKey(MemoryCache.Value $this$diskCacheKey) {
        Object object = $this$diskCacheKey.getExtras().get(EXTRA_DISK_CACHE_KEY);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006"}, d2={"Lcoil3/memory/MemoryCacheService$Companion;", "", "<init>", "()V", "", "TAG", "Ljava/lang/String;", "EXTRA_SIZE", "EXTRA_IS_SAMPLED", "EXTRA_DISK_CACHE_KEY"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Scale.FIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Precision.values().length];
            try {
                nArray[Precision.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Precision.INEXACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

