/*
 * Decompiled with CFR 0.152.
 */
package coil3.memory;

import coil3.Image;
import coil3.PlatformContext;
import coil3.memory.EmptyStrongMemoryCache;
import coil3.memory.EmptyWeakMemoryCache;
import coil3.memory.RealMemoryCache;
import coil3.memory.RealStrongMemoryCache;
import coil3.memory.RealWeakMemoryCache;
import coil3.memory.StrongMemoryCache;
import coil3.memory.WeakMemoryCache;
import coil3.util.Collections_jvmCommonKt;
import coil3.util.ContextsKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eJ\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u00a6\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004H\u00a6\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH&\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\bH&\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u000f\u001a\u00020\u000e8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u000e8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00188&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lcoil3/memory/MemoryCache;", "", "Lcoil3/memory/MemoryCache$Key;", "key", "Lcoil3/memory/MemoryCache$Value;", "get", "(Lcoil3/memory/MemoryCache$Key;)Lcoil3/memory/MemoryCache$Value;", "value", "", "set", "(Lcoil3/memory/MemoryCache$Key;Lcoil3/memory/MemoryCache$Value;)V", "", "remove", "(Lcoil3/memory/MemoryCache$Key;)Z", "", "size", "trimToSize", "(J)V", "clear", "()V", "getSize", "()J", "getMaxSize", "maxSize", "", "getKeys", "()Ljava/util/Set;", "keys", "Key", "Value", "Builder"})
public interface MemoryCache {
    public long getSize();

    public long getMaxSize();

    public Set<Key> getKeys();

    public Value get(Key var1);

    public void set(Key var1, Value var2);

    public boolean remove(Key var1);

    public void trimToSize(long var1);

    public void clear();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u0006\u001a\u00020\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0013J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0012\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001aR\u0016\u0010\u0014\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001a"}, d2={"Lcoil3/memory/MemoryCache$Builder;", "", "<init>", "()V", "", "size", "maxSizeBytes", "(J)Lcoil3/memory/MemoryCache$Builder;", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lcoil3/memory/MemoryCache$Builder;", "Lcoil3/PlatformContext;", "context", "", "percent", "maxSizePercent", "(Lcoil3/PlatformContext;D)Lcoil3/memory/MemoryCache$Builder;", "", "enable", "strongReferencesEnabled", "(Z)Lcoil3/memory/MemoryCache$Builder;", "weakReferencesEnabled", "Lcoil3/memory/MemoryCache;", "build", "()Lcoil3/memory/MemoryCache;", "maxSizeBytesFactory", "Lkotlin/jvm/functions/Function0;", "Z"})
    @SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncoil3/memory/MemoryCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
    public static final class Builder {
        private Function0<Long> maxSizeBytesFactory;
        private boolean strongReferencesEnabled = true;
        private boolean weakReferencesEnabled = true;

        /*
         * WARNING - void declaration
         */
        public final Builder maxSizeBytes(long size) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.maxSizeBytesFactory = () -> Builder.maxSizeBytes$lambda$1$lambda$0((long)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxSizeBytes(Function0<Long> size) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.maxSizeBytesFactory = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxSizePercent(PlatformContext context, double percent) {
            void var1_1;
            void var2_2;
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u245 = builder = this;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                context = "percent must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(context.toString());
            }
            $this$maxSizePercent_u24lambda_u245.maxSizeBytesFactory = () -> Builder.maxSizePercent$lambda$5$lambda$4((double)var2_2, (PlatformContext)var1_1);
            return builder;
        }

        public static /* synthetic */ Builder maxSizePercent$default(Builder builder, PlatformContext platformContext, double d, int n, Object object) {
            if ((n & 2) != 0) {
                d = ContextsKt.defaultMemoryCacheSizePercent(platformContext);
            }
            return builder.maxSizePercent(platformContext, d);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder strongReferencesEnabled(boolean enable) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.strongReferencesEnabled = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder weakReferencesEnabled(boolean enable) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.weakReferencesEnabled = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final MemoryCache build() {
            void var1_1;
            StrongMemoryCache strongMemoryCache;
            Function0<Long> function0;
            WeakMemoryCache weakMemoryCache;
            WeakMemoryCache weakMemoryCache2 = weakMemoryCache = this.weakReferencesEnabled ? (WeakMemoryCache)new RealWeakMemoryCache() : (WeakMemoryCache)new EmptyWeakMemoryCache();
            if (this.strongReferencesEnabled) {
                Function0<Long> function02 = this.maxSizeBytesFactory;
                if (function02 == null) {
                    String string = "maxSizeBytesFactory == null";
                    throw new IllegalStateException(string.toString());
                }
                function0 = function02;
                long maxSizeBytes = ((Number)function02.invoke()).longValue();
                strongMemoryCache = maxSizeBytes > 0L ? (StrongMemoryCache)new RealStrongMemoryCache(maxSizeBytes, weakMemoryCache) : (StrongMemoryCache)new EmptyStrongMemoryCache(weakMemoryCache);
            } else {
                strongMemoryCache = new EmptyStrongMemoryCache(weakMemoryCache);
            }
            StrongMemoryCache strongMemoryCache2 = strongMemoryCache;
            return new RealMemoryCache((StrongMemoryCache)function0, (WeakMemoryCache)var1_1);
        }

        private static final long maxSizeBytes$lambda$1$lambda$0(long $size) {
            return $size;
        }

        /*
         * WARNING - void declaration
         */
        private static final long maxSizePercent$lambda$5$lambda$4(double $percent, PlatformContext $context) {
            void var2_1;
            return (long)($percent * (double)ContextsKt.totalAvailableMemoryBytes((PlatformContext)var2_1));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lcoil3/memory/MemoryCache$Key;", "", "", "key", "", "extras", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "copy", "(Ljava/lang/String;Ljava/util/Map;)Lcoil3/memory/MemoryCache$Key;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getKey", "Ljava/util/Map;", "getExtras", "()Ljava/util/Map;"})
    public static final class Key {
        private final String key;
        private final Map<String, String> extras;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Key(String key, Map<String, String> extras) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.extras = Collections_jvmCommonKt.toImmutableMap(var2_2);
        }

        public /* synthetic */ Key(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, map);
        }

        public final String getKey() {
            return this.key;
        }

        public final Map<String, String> getExtras() {
            return this.extras;
        }

        /*
         * WARNING - void declaration
         */
        public final Key copy(String key, Map<String, String> extras) {
            void var2_2;
            void var1_1;
            return new Key((String)var1_1, (Map<String, String>)var2_2);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.key;
            }
            if ((n & 2) != 0) {
                map = key.extras;
            }
            return key.copy(string, map);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            return other instanceof Key && Intrinsics.areEqual((Object)this.key, (Object)((Key)other).key) && Intrinsics.areEqual(this.extras, ((Key)var1_1).extras);
        }

        /*
         * WARNING - void declaration
         */
        public final int hashCode() {
            void var1_1;
            int result2 = this.key.hashCode();
            var1_1 = var1_1 * 31 + ((Object)this.extras).hashCode();
            return (int)var1_1;
        }

        public final String toString() {
            return "Key(key=" + this.key + ", extras=" + this.extras + ')';
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Key(String key) {
            this((String)var1_1, null, 2, null);
            void var1_1;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lcoil3/memory/MemoryCache$Value;", "", "Lcoil3/Image;", "image", "", "", "extras", "<init>", "(Lcoil3/Image;Ljava/util/Map;)V", "copy", "(Lcoil3/Image;Ljava/util/Map;)Lcoil3/memory/MemoryCache$Value;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lcoil3/Image;", "getImage", "()Lcoil3/Image;", "Ljava/util/Map;", "getExtras", "()Ljava/util/Map;"})
    public static final class Value {
        private final Image image;
        private final Map<String, Object> extras;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Value(Image image, Map<String, ? extends Object> extras) {
            void var2_2;
            void var1_1;
            this.image = var1_1;
            this.extras = Collections_jvmCommonKt.toImmutableMap(var2_2);
        }

        public /* synthetic */ Value(Image image, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(image, map);
        }

        public final Image getImage() {
            return this.image;
        }

        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        /*
         * WARNING - void declaration
         */
        public final Value copy(Image image, Map<String, ? extends Object> extras) {
            void var2_2;
            void var1_1;
            return new Value((Image)var1_1, (Map<String, ? extends Object>)var2_2);
        }

        public static /* synthetic */ Value copy$default(Value value, Image image, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                image = value.image;
            }
            if ((n & 2) != 0) {
                map = value.extras;
            }
            return value.copy(image, map);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            return other instanceof Value && Intrinsics.areEqual((Object)this.image, (Object)((Value)other).image) && Intrinsics.areEqual(this.extras, ((Value)var1_1).extras);
        }

        /*
         * WARNING - void declaration
         */
        public final int hashCode() {
            void var1_1;
            int result2 = this.image.hashCode();
            var1_1 = var1_1 * 31 + ((Object)this.extras).hashCode();
            return (int)var1_1;
        }

        public final String toString() {
            return "Value(image=" + this.image + ", extras=" + this.extras + ')';
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public Value(Image image) {
            this((Image)var1_1, null, 2, null);
            void var1_1;
        }
    }
}

