/*
 * Decompiled with CFR 0.152.
 */
package coil3.disk;

import coil3.disk.DiskLruCache;
import coil3.disk.FaultHidingSink;
import coil3.util.Collections_jvmCommonKt;
import coil3.util.Coroutines_nonJsCommonKt;
import coil3.util.FileSystemsKt;
import coil3.util.UtilsKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015*\u0001&\b\u0000\u0018\u0000 H2\u00060\u0001j\u0002`\u0002:\u0004EFGHB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020)H\u0002J\b\u0010+\u001a\u00020\u001fH\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020)H\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0017\u00100\u001a\b\u0018\u000101R\u00020\u00002\u0006\u00102\u001a\u00020\u0015H\u0086\u0002J\u0014\u00103\u001a\b\u0018\u000104R\u00020\u00002\u0006\u00102\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\nJ\u001c\u00105\u001a\u00020)2\n\u00106\u001a\u000604R\u00020\u00002\u0006\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002J\u000e\u00109\u001a\u00020!2\u0006\u00102\u001a\u00020\u0015J\u0014\u0010:\u001a\u00020!2\n\u0010;\u001a\u00060\u0016R\u00020\u0000H\u0002J\b\u0010<\u001a\u00020)H\u0002J\b\u0010=\u001a\u00020)H\u0016J\u0006\u0010>\u001a\u00020)J\b\u0010?\u001a\u00020)H\u0002J\b\u0010@\u001a\u00020!H\u0002J\b\u0010A\u001a\u00020)H\u0002J\u0006\u0010B\u001a\u00020)J\b\u0010C\u001a\u00020)H\u0002J\u0010\u0010D\u001a\u00020)2\u0006\u00102\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u0006I"}, d2={"Lcoil3/disk/DiskLruCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "maxSize", "", "appVersion", "", "valueCount", "<init>", "(Lokio/FileSystem;Lokio/Path;Lkotlin/coroutines/CoroutineContext;JII)V", "journalFile", "journalFileTmp", "journalFileBackup", "lruEntries", "", "", "Lcoil3/disk/DiskLruCache$Entry;", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "size", "operationsSinceRewrite", "journalWriter", "Lokio/BufferedSink;", "hasJournalErrors", "", "initialized", "closed", "mostRecentTrimFailed", "mostRecentRebuildFailed", "coil3/disk/DiskLruCache$fileSystem$1", "Lcoil3/disk/DiskLruCache$fileSystem$1;", "initialize", "", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "writeJournal", "get", "Lcoil3/disk/DiskLruCache$Snapshot;", "key", "edit", "Lcoil3/disk/DiskLruCache$Editor;", "completeEdit", "editor", "success", "journalRewriteRequired", "remove", "removeEntry", "entry", "checkNotClosed", "close", "flush", "trimToSize", "removeOldestEntry", "delete", "evictAll", "launchCleanup", "validateKey", "Snapshot", "Editor", "Entry", "Companion", "coil-core"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,869:1\n1#2:870\n66#3:871\n52#3,4:873\n60#3,10:878\n56#3,3:888\n71#3,3:891\n52#3,4:904\n60#3,10:909\n56#3,18:919\n67#4:872\n68#4:877\n78#4:901\n177#4:902\n81#4:903\n82#4:908\n381#5,7:894\n37#6:937\n36#6,3:938\n37#6:941\n36#6,3:942\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache\n*L\n212#1:871\n212#1:873,4\n212#1:878,10\n212#1:888,3\n212#1:891,3\n324#1:904,4\n324#1:909,10\n324#1:919,18\n212#1:872\n212#1:877\n324#1:901\n324#1:902\n324#1:903\n324#1:908\n275#1:894,7\n587#1:937\n587#1:938,3\n641#1:941\n641#1:942,3\n*E\n"})
public final class DiskLruCache
implements AutoCloseable {
    public static final Companion Companion = new Companion(null);
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    private final Path journalFile;
    private final Path journalFileTmp;
    private final Path journalFileBackup;
    private final Map<String, Entry> lruEntries;
    private final CoroutineScope cleanupScope;
    private final Object lock;
    private long size;
    private int operationsSinceRewrite;
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private final fileSystem.1 fileSystem;
    public static final String JOURNAL_FILE = "journal";
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    public static final String MAGIC = "libcore.io.DiskLruCache";
    public static final String VERSION = "1";
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    /*
     * WARNING - void declaration
     */
    public DiskLruCache(FileSystem fileSystem2, Path directory, CoroutineContext cleanupCoroutineContext, long maxSize, int appVersion, int valueCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.directory = var2_2;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            fileSystem2 = "maxSize <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        if (!(this.valueCount > 0)) {
            fileSystem2 = "valueCount <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = Collections_jvmCommonKt.LruMutableMap$default(0, 0.0f, 3, null);
        CoroutineContext coroutineContext = cleanupCoroutineContext.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null));
        CoroutineDispatcher coroutineDispatcher = UtilsKt.getDispatcher((CoroutineContext)var3_3);
        if (coroutineDispatcher == null) {
            coroutineDispatcher = Coroutines_nonJsCommonKt.ioCoroutineDispatcher();
        }
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineContext.plus((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)coroutineDispatcher, (int)1, null, (int)2, null)));
        this.lock = new Object();
        this.fileSystem = new ForwardingFileSystem((FileSystem)var1_1){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Sink sink(Path file, boolean mustCreate) {
                void var2_2;
                void var1_1;
                block0: {
                    void var3_3;
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path p0 = path;
                    this.createDirectories((Path)var3_3);
                }
                return super.sink((Path)var1_1, (boolean)var2_2);
            }
        };
    }

    public final void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournal() {
        void var2_3;
        void this_$iv;
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFile;
        Object $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource bufferedSource;
            BufferedSource $this$readJournal_u24lambda_u243 = bufferedSource = (BufferedSource)$this$use$iv$iv;
            String magic = bufferedSource.readUtf8LineStrict();
            String version = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String appVersionString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String valueCountString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            String blank = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
            if (!(Intrinsics.areEqual((Object)MAGIC, (Object)magic) && Intrinsics.areEqual((Object)VERSION, (Object)version) && Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString) && Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString) && !(((CharSequence)blank).length() > 0))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u243.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.operationsSinceRewrite = lineCount - this.lruEntries.size();
                if (!bufferedSource.exhausted()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$use$iv$iv = throwable;
                    thrown$iv$iv = throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            thrown$iv$iv = throwable;
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                void var1_2;
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)var1_2);
            }
        }
        catch (Throwable throwable) {
            try {
                FileSystem fileSystem3 = fileSystem2;
                if (fileSystem3 != null) {
                    fileSystem3.close();
                }
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        void v7 = var2_3;
        if (v7 != null) {
            throw v7;
        }
    }

    private final BufferedSink newJournalWriter() {
        FaultHidingSink faultHidingSink;
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        faultHidingSink = new FaultHidingSink(faultHidingSink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$4(this, arg_0)));
        return Okio.buffer((Sink)faultHidingSink);
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournalLine(String line) {
        void var2_2;
        Entry entry;
        Map<String, Entry> $this$getOrPut$iv;
        Entry value$iv;
        String key22;
        int firstSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + (String)line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        if (secondSpace == -1) {
            String string = ((String)line).substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
            if (firstSpace == 6 && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key22);
                return;
            }
        } else {
            void key22;
            String string = ((String)line).substring((int)key22, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
        }
        if ((value$iv = ($this$getOrPut$iv = this.lruEntries).get(key22)) == null) {
            Entry answer$iv = new Entry(key22);
            $this$getOrPut$iv.put(key22, answer$iv);
            entry = answer$iv;
        } else {
            void var6_7;
            entry = var6_7;
        }
        Entry entry2 = entry;
        if (secondSpace != -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = ((String)line).substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[1];
            line = cArray;
            cArray[0] = 32;
            List parts = StringsKt.split$default((CharSequence)string, (char[])line, (boolean)false, (int)0, (int)6, null);
            entry2.setReadable(true);
            entry2.setCurrentEditor(null);
            entry2.setLengths(parts);
            return;
        }
        if (secondSpace == -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            void var3_4;
            entry2.setCurrentEditor(new Editor(this, (Entry)var3_4));
            return;
        }
        if (secondSpace != -1 || var2_2 != 4 || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            void var1_1;
            throw new IOException("unexpected journal line: " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processJournal() {
        void var1_1;
        long size = 0L;
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int i;
            int n;
            Entry entry = iterator.next();
            if (entry.getCurrentEditor() == null) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    size += entry.getLengths()[i];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                this.fileSystem.delete(entry.getCleanFiles().get(i));
                this.fileSystem.delete(entry.getDirtyFiles().get(i));
            }
            iterator.remove();
        }
        this.size = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        Object object = this.lock;
        synchronized (object) {
            void var3_4;
            block19: {
                void $this$iv;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                Path file$iv = this.journalFileTmp;
                Object $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                Throwable thrown$iv$iv = null;
                try {
                    BufferedSink bufferedSink2;
                    BufferedSink $this$writeJournal_u24lambda_u247_u24lambda_u246 = bufferedSink2 = (BufferedSink)$this$use$iv$iv;
                    bufferedSink2.writeUtf8(MAGIC).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(VERSION).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeDecimalLong((long)this.appVersion).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeDecimalLong((long)this.valueCount).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                    for (Entry entry : this.lruEntries.values()) {
                        if (entry.getCurrentEditor() != null) {
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(DIRTY);
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(32);
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(entry.getKey());
                            $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                            continue;
                        }
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(CLEAN);
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(32);
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeUtf8(entry.getKey());
                        entry.writeLengths($this$writeJournal_u24lambda_u247_u24lambda_u246);
                        $this$writeJournal_u24lambda_u247_u24lambda_u246.writeByte(10);
                    }
                }
                catch (Throwable throwable) {
                    Throwable bufferedSink3 = throwable;
                    thrown$iv$iv = throwable;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block19;
                    }
                    catch (Throwable t$iv$iv) {
                        void var2_3;
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)var2_3);
                    }
                    break block19;
                }
                catch (Throwable throwable2) {
                    try {
                        FileSystem fileSystem3 = fileSystem2;
                        if (fileSystem3 == null) throw throwable2;
                        fileSystem3.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable) {}
                    throw throwable2;
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$use$iv$iv = throwable;
                    thrown$iv$iv = throwable;
                }
            }
            void v7 = var3_4;
            if (v7 != null) {
                throw v7;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Snapshot get(String key) {
        Object object = this.lock;
        synchronized (object) {
            void var3_4;
            void var1_1;
            Object object2;
            block5: {
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                object2 = this.lruEntries.get(key);
                if (object2 != null && (object2 = ((Entry)object2).snapshot()) != null) break block5;
                return null;
            }
            Object snapshot = object2;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink $this$get_u24lambda_u249_u24lambda_u248 = bufferedSink;
            bufferedSink.writeUtf8(READ);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(32);
            $this$get_u24lambda_u249_u24lambda_u248.writeUtf8((String)var1_1);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(10);
            $this$get_u24lambda_u249_u24lambda_u248.flush();
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            var1_1 = var3_4;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Editor edit(String key) {
        Object object = this.lock;
        synchronized (object) {
            void var3_4;
            Editor editor;
            Entry entry;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            this.checkNotClosed();
                            this.validateKey(key);
                            this.initialize();
                            entry = this.lruEntries.get(key);
                            if ((entry != null ? entry.getCurrentEditor() : null) == null) break block8;
                            return null;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        return null;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    return null;
                }
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                BufferedSink bufferedSink2 = bufferedSink;
                BufferedSink $this$edit_u24lambda_u2411_u24lambda_u2410 = bufferedSink;
                bufferedSink.writeUtf8(DIRTY);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(32);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeUtf8(key);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(10);
                $this$edit_u24lambda_u2411_u24lambda_u2410.flush();
                if (!this.hasJournalErrors) break block11;
                return null;
            }
            if (entry == null) {
                entry = new Entry(key);
                this.lruEntries.put((String)((Object)editor), entry);
            }
            Editor editor2 = new Editor(this, entry);
            var3_4.setCurrentEditor(editor2);
            editor = editor2;
            return editor;
        }
    }

    public final long size() {
        Object object = this.lock;
        synchronized (object) {
            this.initialize();
            long l = this.size;
            return l;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeEdit(Editor editor, boolean success) {
        Object object = this.lock;
        synchronized (object) {
            void var2_3;
            int i;
            int n;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                throw new IllegalStateException("Check failed.");
            }
            if (success && !entry.getZombie()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    if (!editor.getWritten()[i] || this.fileSystem.exists(entry.getDirtyFiles().get(i))) continue;
                    editor.abort();
                    return;
                }
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    long newLength;
                    Path dirty = entry.getDirtyFiles().get(i);
                    Path clean = entry.getCleanFiles().get(i);
                    if (this.fileSystem.exists(dirty)) {
                        void var1_1;
                        this.fileSystem.atomicMove((Path)var1_1, clean);
                    } else {
                        FileSystemsKt.createFile$default((FileSystem)this.fileSystem, entry.getCleanFiles().get(i), false, 2, null);
                    }
                    long oldLength = entry.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry.getLengths()[i] = newLength = l != null ? l : 0L;
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    this.fileSystem.delete(entry.getDirtyFiles().get(i));
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                return;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink $this$completeEdit_u24lambda_u2414_u24lambda_u2413 = bufferedSink;
            if (var2_3 != false || entry.getReadable()) {
                entry.setReadable(true);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(CLEAN);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                entry.writeLengths($this$completeEdit_u24lambda_u2414_u24lambda_u2413);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            } else {
                this.lruEntries.remove(entry.getKey());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(REMOVE);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(32);
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeUtf8(entry.getKey());
                $this$completeEdit_u24lambda_u2414_u24lambda_u2413.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2414_u24lambda_u2413.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            return;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            void var1_2;
            Entry entry;
            block5: {
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                if (this.lruEntries.get(key) != null) break block5;
                return false;
            }
            Entry entry2 = entry;
            boolean removed = this.removeEntry(entry2);
            if (removed && this.size <= this.maxSize) {
                this.mostRecentTrimFailed = false;
            }
            return (boolean)var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeEntry(Entry entry) {
        void var1_1;
        int i;
        if (entry.getLockingSnapshotCount() > 0) {
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink2 = bufferedSink;
                BufferedSink $this$removeEntry_u24lambda_u2416 = bufferedSink;
                bufferedSink.writeUtf8(DIRTY);
                $this$removeEntry_u24lambda_u2416.writeByte(32);
                $this$removeEntry_u24lambda_u2416.writeUtf8(entry.getKey());
                $this$removeEntry_u24lambda_u2416.writeByte(10);
                $this$removeEntry_u24lambda_u2416.flush();
            }
        }
        if (entry.getLockingSnapshotCount() > 0 || entry.getCurrentEditor() != null) {
            entry.setZombie(true);
            return true;
        }
        int n = this.valueCount;
        for (i = 0; i < n; ++i) {
            this.fileSystem.delete(entry.getCleanFiles().get(i));
            this.size -= entry.getLengths()[i];
            entry.getLengths()[i] = 0L;
        }
        i = this.operationsSinceRewrite;
        this.operationsSinceRewrite = i + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            void var2_7;
            BufferedSink bufferedSink3 = bufferedSink;
            BufferedSink $this$removeEntry_u24lambda_u2417 = bufferedSink;
            bufferedSink.writeUtf8(REMOVE);
            $this$removeEntry_u24lambda_u2417.writeByte(32);
            $this$removeEntry_u24lambda_u2417.writeUtf8(entry.getKey());
            $this$removeEntry_u24lambda_u2417.writeByte(10);
            var2_7.flush();
        }
        this.lruEntries.remove(var1_1.getKey());
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            Collection<Entry> collection;
            if (!this.initialized || this.closed) {
                this.closed = true;
                return;
            }
            Collection<Entry> object22 = collection = this.lruEntries.values();
            for (Entry entry : collection.toArray(new Entry[0])) {
                Editor editor = entry.getCurrentEditor();
                if (editor == null) continue;
                editor.detach();
            }
            this.trimToSize();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.close();
            this.journalWriter = null;
            this.closed = true;
            return;
        }
    }

    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.flush();
            return;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            void var2_2;
            if (toEvict.getZombie()) continue;
            this.removeEntry((Entry)var2_2);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemsKt.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    public final void evictAll() {
        Object object = this.lock;
        synchronized (object) {
            Collection<Entry> collection;
            this.initialize();
            Collection<Entry> collection2 = collection = this.lruEntries.values();
            for (Entry entry : collection.toArray(new Entry[0])) {
                this.removeEntry(entry);
            }
            this.mostRecentTrimFailed = false;
            return;
        }
    }

    private final void launchCleanup() {
        BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(2, (Continuation)var2_2);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        object = DiskLruCache.access$getLock$p(this.this$0);
                        DiskLruCache diskLruCache = this.this$0;
                        synchronized (object) {
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache, true);
                            }
                            try {
                                if (!DiskLruCache.access$journalRewriteRequired(diskLruCache)) return Unit.INSTANCE;
                                DiskLruCache.access$writeJournal(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                void var2_2;
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            /*
             * WARNING - void declaration
             */
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                void var2_2;
                void var1_1;
                return (this.create(var1_1, (Continuation)var2_2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            String string;
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit newJournalWriter$lambda$4(DiskLruCache this$0, IOException it) {
        this$0.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentTrimFailed = var1_1;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentRebuildFailed = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        void var1_1;
        $this.journalWriter = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$removeEntry(DiskLruCache $this, Entry entry) {
        void var1_1;
        return $this.removeEntry((Entry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$completeEdit(DiskLruCache $this, Editor editor, boolean success) {
        void var2_2;
        void var1_1;
        $this.completeEdit((Editor)var1_1, (boolean)var2_2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u0012\u0004\b\u0007\u0010\u0003R\u001a\u0010\b\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\f\n\u0004\b\b\u0010\u0006\u0012\u0004\b\t\u0010\u0003R\u001a\u0010\n\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\f\n\u0004\b\n\u0010\u0006\u0012\u0004\b\u000b\u0010\u0003R\u001a\u0010\f\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\f\n\u0004\b\f\u0010\u0006\u0012\u0004\b\r\u0010\u0003R\u001a\u0010\u000e\u001a\u00020\u00048\u0000X\u0080T\u00a2\u0006\f\n\u0004\b\u000e\u0010\u0006\u0012\u0004\b\u000f\u0010\u0003R\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lcoil3/disk/DiskLruCache$Companion;", "", "<init>", "()V", "", "JOURNAL_FILE", "Ljava/lang/String;", "getJOURNAL_FILE$coil_core$annotations", "JOURNAL_FILE_TMP", "getJOURNAL_FILE_TMP$coil_core$annotations", "JOURNAL_FILE_BACKUP", "getJOURNAL_FILE_BACKUP$coil_core$annotations", "MAGIC", "getMAGIC$coil_core$annotations", "VERSION", "getVERSION$coil_core$annotations", "CLEAN", "DIRTY", "REMOVE", "READ", "Lkotlin/text/Regex;", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getJOURNAL_FILE$coil_core$annotations() {
        }

        public static /* synthetic */ void getJOURNAL_FILE_TMP$coil_core$annotations() {
        }

        public static /* synthetic */ void getJOURNAL_FILE_BACKUP$coil_core$annotations() {
        }

        public static /* synthetic */ void getMAGIC$coil_core$annotations() {
        }

        public static /* synthetic */ void getVERSION$coil_core$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0018\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0013\u0010\u0011\u001a\b\u0018\u00010\u0010R\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u0017\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0004\u001a\u00060\u0002R\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lcoil3/disk/DiskLruCache$Editor;", "", "Lcoil3/disk/DiskLruCache$Entry;", "Lcoil3/disk/DiskLruCache;", "entry", "<init>", "(Lcoil3/disk/DiskLruCache;Lcoil3/disk/DiskLruCache$Entry;)V", "", "index", "Lokio/Path;", "file", "(I)Lokio/Path;", "", "detach", "()V", "commit", "Lcoil3/disk/DiskLruCache$Snapshot;", "commitAndGet", "()Lcoil3/disk/DiskLruCache$Snapshot;", "abort", "", "success", "complete", "(Z)V", "Lcoil3/disk/DiskLruCache$Entry;", "getEntry", "()Lcoil3/disk/DiskLruCache$Entry;", "closed", "Z", "", "written", "[Z", "getWritten", "()[Z"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Editor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,869:1\n1#2:870\n*E\n"})
    public final class Editor {
        private final Entry entry;
        private boolean closed;
        private final boolean[] written;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Editor(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.entry = var2_2;
            this.written = new boolean[this.this$0.valueCount];
        }

        public final Entry getEntry() {
            return this.entry;
        }

        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - void declaration
         */
        public final Path file(int index2) {
            Object object = this.this$0.lock;
            DiskLruCache diskLruCache = this.this$0;
            synchronized (object) {
                void var1_1;
                if (!(!this.closed)) {
                    String index2 = "editor is closed";
                    throw new IllegalStateException(index2.toString());
                }
                this.written[index2] = true;
                Path path = this.entry.getDirtyFiles().get((int)var1_1);
                fileSystem.1 var1_3 = diskLruCache.fileSystem;
                Path p0 = path;
                FileSystemsKt.createFile$default((FileSystem)var1_3, (Path)diskLruCache, false, 2, null);
                var1_3 = path;
                return var1_3;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        public final Snapshot commitAndGet() {
            Object object = this.this$0.lock;
            AutoCloseable autoCloseable = this.this$0;
            synchronized (object) {
                this.commit();
                autoCloseable = autoCloseable.get(this.entry.getKey());
                return autoCloseable;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - void declaration
         */
        private final void complete(boolean success2) {
            Object object = this.this$0.lock;
            DiskLruCache diskLruCache = this.this$0;
            synchronized (object) {
                if (!(!this.closed)) {
                    String success2 = "editor is closed";
                    throw new IllegalStateException(success2.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    void var1_1;
                    DiskLruCache.access$completeEdit(diskLruCache, this, (boolean)var1_1);
                }
                this.closed = true;
                return;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\b\u0087\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0011\u001a\b\u0018\u00010\u000fR\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0017\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR'\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R'\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001d8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010+\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010&\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R(\u0010/\u001a\b\u0018\u00010.R\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\"\u00106\u001a\u0002058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;"}, d2={"Lcoil3/disk/DiskLruCache$Entry;", "", "", "key", "<init>", "(Lcoil3/disk/DiskLruCache;Ljava/lang/String;)V", "", "strings", "", "setLengths", "(Ljava/util/List;)V", "Lokio/BufferedSink;", "writer", "writeLengths", "(Lokio/BufferedSink;)V", "Lcoil3/disk/DiskLruCache$Snapshot;", "Lcoil3/disk/DiskLruCache;", "snapshot", "()Lcoil3/disk/DiskLruCache$Snapshot;", "Ljava/lang/String;", "getKey", "()Ljava/lang/String;", "", "lengths", "[J", "getLengths", "()[J", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "cleanFiles", "Ljava/util/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "dirtyFiles", "getDirtyFiles", "", "readable", "Z", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "Lcoil3/disk/DiskLruCache$Editor;", "currentEditor", "Lcoil3/disk/DiskLruCache$Editor;", "getCurrentEditor", "()Lcoil3/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcoil3/disk/DiskLruCache$Editor;)V", "", "lockingSnapshotCount", "I", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Entry\n+ 2 collections.kt\ncoil3/util/CollectionsKt\n*L\n1#1,869:1\n43#2,4:870\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Entry\n*L\n841#1:870,4\n*E\n"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final ArrayList<Path> cleanFiles;
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                ((Collection)this.cleanFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.append(".tmp");
                ((Collection)this.dirtyFiles).add(DiskLruCache.this.directory.resolve(fileBuilder.toString()));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey() {
            return this.key;
        }

        public final long[] getLengths() {
            return this.lengths;
        }

        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        /*
         * WARNING - void declaration
         */
        public final void setReadable(boolean bl) {
            void var1_1;
            this.readable = var1_1;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        /*
         * WARNING - void declaration
         */
        public final void setZombie(boolean bl) {
            void var1_1;
            this.zombie = var1_1;
        }

        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentEditor(Editor editor) {
            void var1_1;
            this.currentEditor = var1_1;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLockingSnapshotCount(int n) {
            void var1_1;
            this.lockingSnapshotCount = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths(List<String> strings) {
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = ((Collection)strings).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                throw new IOException("unexpected journal line: " + var1_1);
            }
        }

        public final void writeLengths(BufferedSink writer) {
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            List list = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            int n = ((Collection)$this$forEachIndices$iv).size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                if (diskLruCache.fileSystem.exists(file)) continue;
                try {
                    DiskLruCache.access$removeEntry(diskLruCache, this);
                }
                catch (IOException iOException) {}
                return null;
            }
            int n2 = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n2 + 1;
            return new Snapshot(DiskLruCache.this, this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0005R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil3/disk/DiskLruCache$Snapshot;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "entry", "Lcoil3/disk/DiskLruCache$Entry;", "Lcoil3/disk/DiskLruCache;", "<init>", "(Lcoil3/disk/DiskLruCache;Lcoil3/disk/DiskLruCache$Entry;)V", "getEntry", "()Lcoil3/disk/DiskLruCache$Entry;", "closed", "", "file", "Lokio/Path;", "index", "", "close", "", "closeAndEdit", "Lcoil3/disk/DiskLruCache$Editor;", "coil-core"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncoil3/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,869:1\n1#2:870\n*E\n"})
    public final class Snapshot
    implements AutoCloseable {
        private final Entry entry;
        private boolean closed;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Snapshot(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.entry = var2_2;
        }

        public final Entry getEntry() {
            return this.entry;
        }

        /*
         * WARNING - void declaration
         */
        public final Path file(int index2) {
            void var1_1;
            if (!(!this.closed)) {
                String index2 = "snapshot is closed";
                throw new IllegalStateException(index2.toString());
            }
            return this.entry.getCleanFiles().get((int)var1_1);
        }

        @Override
        public final void close() {
            if (!this.closed) {
                this.closed = true;
                Object object = this.this$0.lock;
                DiskLruCache diskLruCache = this.this$0;
                synchronized (object) {
                    Entry entry = this.entry;
                    int n = entry.getLockingSnapshotCount();
                    entry.setLockingSnapshotCount(n + -1);
                    if (this.entry.getLockingSnapshotCount() == 0 && this.entry.getZombie()) {
                        DiskLruCache.access$removeEntry(diskLruCache, this.entry);
                    }
                    return;
                }
            }
        }

        public final Editor closeAndEdit() {
            Object object = this.this$0.lock;
            Object object2 = this.this$0;
            synchronized (object) {
                this.close();
                object2 = ((DiskLruCache)object2).edit(this.entry.getKey());
                return object2;
            }
        }
    }
}

