/*
 * Decompiled with CFR 0.152.
 */
package coil3.disk;

import coil3.disk.RealDiskCache;
import coil3.util.FileSystems_jvmKt;
import coil3.util.FileSystems_nonJsCommonKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.FileSystem;
import okio.Path;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0003\u001f !J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH&\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00178&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache;", "", "", "key", "Lcoil3/disk/DiskCache$Snapshot;", "openSnapshot", "(Ljava/lang/String;)Lcoil3/disk/DiskCache$Snapshot;", "Lcoil3/disk/DiskCache$Editor;", "openEditor", "(Ljava/lang/String;)Lcoil3/disk/DiskCache$Editor;", "", "remove", "(Ljava/lang/String;)Z", "", "clear", "()V", "shutdown", "", "getSize", "()J", "size", "getMaxSize", "maxSize", "Lokio/Path;", "getDirectory", "()Lokio/Path;", "directory", "Lokio/FileSystem;", "getFileSystem", "()Lokio/FileSystem;", "fileSystem", "Snapshot", "Editor", "Builder"})
public interface DiskCache {
    public long getSize();

    public long getMaxSize();

    public Path getDirectory();

    public FileSystem getFileSystem();

    public Snapshot openSnapshot(String var1);

    public Editor openEditor(String var1);

    public boolean remove(String var1);

    public void clear();

    public void shutdown();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010 R\u0016\u0010\f\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010!R\u0016\u0010\u0010\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\"R\u0016\u0010\u0012\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\"R\u0016\u0010\u0013\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\"R\u0016\u0010\u0016\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010#"}, d2={"Lcoil3/disk/DiskCache$Builder;", "", "<init>", "()V", "Lokio/Path;", "directory", "(Lokio/Path;)Lcoil3/disk/DiskCache$Builder;", "Lokio/FileSystem;", "fileSystem", "(Lokio/FileSystem;)Lcoil3/disk/DiskCache$Builder;", "", "percent", "maxSizePercent", "(D)Lcoil3/disk/DiskCache$Builder;", "", "size", "minimumMaxSizeBytes", "(J)Lcoil3/disk/DiskCache$Builder;", "maximumMaxSizeBytes", "maxSizeBytes", "Lkotlin/coroutines/CoroutineContext;", "context", "cleanupCoroutineContext", "(Lkotlin/coroutines/CoroutineContext;)Lcoil3/disk/DiskCache$Builder;", "Lkotlinx/coroutines/CoroutineDispatcher;", "dispatcher", "cleanupDispatcher", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lcoil3/disk/DiskCache$Builder;", "Lcoil3/disk/DiskCache;", "build", "()Lcoil3/disk/DiskCache;", "Lokio/Path;", "Lokio/FileSystem;", "D", "J", "Lkotlin/coroutines/CoroutineContext;"})
    @SourceDebugExtension(value={"SMAP\nDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCache.kt\ncoil3/disk/DiskCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    public static final class Builder {
        private Path directory;
        private FileSystem fileSystem = FileSystems_nonJsCommonKt.defaultFileSystem();
        private double maxSizePercent = 0.02;
        private long minimumMaxSizeBytes = 0xA00000L;
        private long maximumMaxSizeBytes = 0xFA00000L;
        private long maxSizeBytes;
        private CoroutineContext cleanupCoroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;

        /*
         * WARNING - void declaration
         */
        public final Builder directory(Path directory) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.directory = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder fileSystem(FileSystem fileSystem2) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.fileSystem = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxSizePercent(double percent2) {
            void var1_1;
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u243 = builder = this;
            if (!(0.0 <= percent2 ? percent2 <= 1.0 : false)) {
                String percent2 = "percent must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(percent2.toString());
            }
            $this$maxSizePercent_u24lambda_u243.maxSizeBytes = 0L;
            $this$maxSizePercent_u24lambda_u243.maxSizePercent = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder minimumMaxSizeBytes(long size2) {
            void var1_1;
            Builder builder;
            Builder $this$minimumMaxSizeBytes_u24lambda_u245 = builder = this;
            if (!(size2 > 0L)) {
                String size2 = "size must be > 0.";
                throw new IllegalArgumentException(size2.toString());
            }
            $this$minimumMaxSizeBytes_u24lambda_u245.minimumMaxSizeBytes = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maximumMaxSizeBytes(long size2) {
            void var1_1;
            Builder builder;
            Builder $this$maximumMaxSizeBytes_u24lambda_u247 = builder = this;
            if (!(size2 > 0L)) {
                String size2 = "size must be > 0.";
                throw new IllegalArgumentException(size2.toString());
            }
            $this$maximumMaxSizeBytes_u24lambda_u247.maximumMaxSizeBytes = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxSizeBytes(long size2) {
            void var1_1;
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u249 = builder = this;
            if (!(size2 > 0L)) {
                String size2 = "size must be > 0.";
                throw new IllegalArgumentException(size2.toString());
            }
            $this$maxSizeBytes_u24lambda_u249.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u249.maxSizeBytes = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cleanupCoroutineContext(CoroutineContext context) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.cleanupCoroutineContext = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Replaced by cleanupCoroutineContext.", replaceWith=@ReplaceWith(expression="cleanupCoroutineContext(dispatcher)", imports={}))
        public final Builder cleanupDispatcher(CoroutineDispatcher dispatcher) {
            void var1_1;
            return this.cleanupCoroutineContext((CoroutineContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final DiskCache build() {
            void var1_2;
            void var2_5;
            long l;
            Path path = this.directory;
            if (path == null) {
                String string = "directory == null";
                throw new IllegalStateException(string.toString());
            }
            Path directory = path;
            if (this.maxSizePercent > 0.0) {
                long l2;
                try {
                    double d = this.maxSizePercent * (double)FileSystems_jvmKt.remainingFreeSpaceBytes(this.fileSystem, directory);
                    l2 = RangesKt.coerceIn((long)((long)d), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
                }
                catch (Exception exception) {
                    l2 = this.minimumMaxSizeBytes;
                }
                l = l2;
            } else {
                l = this.maxSizeBytes;
            }
            long maxSize = l;
            return new RealDiskCache((long)var2_5, (Path)var1_2, this.fileSystem, this.cleanupCoroutineContext);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0005H&\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\u0004R\u0014\u0010\f\u001a\u00020\t8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache$Editor;", "", "", "commit", "()V", "Lcoil3/disk/DiskCache$Snapshot;", "commitAndOpenSnapshot", "()Lcoil3/disk/DiskCache$Snapshot;", "abort", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "metadata", "getData", "data"})
    public static interface Editor {
        public Path getMetadata();

        public Path getData();

        public void commit();

        public Snapshot commitAndOpenSnapshot();

        public void abort();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00060\u0001j\u0002`\u0002J\b\u0010\t\u001a\u00020\nH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache$Snapshot;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "close", "", "closeAndOpenEditor", "Lcoil3/disk/DiskCache$Editor;", "coil-core"})
    public static interface Snapshot
    extends AutoCloseable {
        public Path getMetadata();

        public Path getData();

        @Override
        public void close();

        public Editor closeAndOpenEditor();
    }
}

