/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@PerformanceSensitive(value={"allocation"})
public class Unbox {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BITS_PER_INT = 32;
    private static final int RINGBUFFER_MIN_SIZE = 32;
    private static final int RINGBUFFER_SIZE = Unbox.calculateRingBufferSize("log4j.unbox.ringbuffer.size");
    private static final int MASK = RINGBUFFER_SIZE - 1;
    private static ThreadLocal<State> threadLocalState = new ThreadLocal();
    private static WebSafeState webSafeState = new WebSafeState();

    private Unbox() {
    }

    /*
     * WARNING - void declaration
     */
    private static int calculateRingBufferSize(String propertyName) {
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty(propertyName, "32");
        try {
            void var2_2;
            int size = Integer.parseInt(userPreferredRBSize.trim());
            if (size < 32) {
                size = 32;
                LOGGER.warn("Invalid {} {}, using minimum size {}.", (Object)propertyName, (Object)userPreferredRBSize, (Object)32);
            }
            return Unbox.ceilingNextPowerOfTwo((int)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            String string;
            LOGGER.warn("Invalid {} {}, using default size {}.", (Object)string, (Object)var1_1, (Object)32);
            return 32;
        }
    }

    private static int ceilingNextPowerOfTwo(int x) {
        int n;
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(float value) {
        float f;
        return Unbox.getSB().append(f);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(double value) {
        double d;
        return Unbox.getSB().append(d);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(short value) {
        short s;
        return Unbox.getSB().append(s);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(int value) {
        int n;
        return Unbox.getSB().append(n);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(char value) {
        char c;
        return Unbox.getSB().append(c);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(long value) {
        long l;
        return Unbox.getSB().append(l);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(byte value) {
        byte by;
        return Unbox.getSB().append(by);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(boolean value) {
        boolean bl;
        return Unbox.getSB().append(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static State getState() {
        void var0;
        State state = threadLocalState.get();
        if (state == null) {
            state = new State();
            threadLocalState.set(state);
        }
        return var0;
    }

    private static StringBuilder getSB() {
        if (Constants.ENABLE_THREADLOCALS) {
            return Unbox.getState().getStringBuilder();
        }
        return webSafeState.getStringBuilder();
    }

    static int getRingbufferSize() {
        return RINGBUFFER_SIZE;
    }

    private static class State {
        private final StringBuilder[] ringBuffer = new StringBuilder[Unbox.access$000()];
        private int current;

        State() {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i] = new StringBuilder(21);
            }
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder getStringBuilder() {
            void var1_1;
            StringBuilder result = this.ringBuffer[MASK & this.current++];
            result.setLength(0);
            return var1_1;
        }

        public boolean isBoxedPrimitive(StringBuilder text) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                if (text != this.ringBuffer[i]) continue;
                return true;
            }
            return false;
        }
    }

    private static class WebSafeState {
        private final ThreadLocal<StringBuilder[]> ringBuffer = new ThreadLocal();
        private final ThreadLocal<int[]> current = new ThreadLocal();

        private WebSafeState() {
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder getStringBuilder() {
            void var1_1;
            void var2_3;
            StringBuilder[] array = this.ringBuffer.get();
            if (array == null) {
                array = new StringBuilder[RINGBUFFER_SIZE];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = new StringBuilder(21);
                }
                this.ringBuffer.set(array);
                this.current.set(new int[1]);
            }
            int[] index = this.current.get();
            void v0 = var2_3;
            void v1 = v0[0];
            v0[0] = v1 + true;
            StringBuilder result = array[MASK & v1];
            result.setLength(0);
            return var1_1;
        }

        public boolean isBoxedPrimitive(StringBuilder text) {
            StringBuilder[] array = this.ringBuffer.get();
            if (array == null) {
                return false;
            }
            for (int i = 0; i < array.length; ++i) {
                if (text != array[i]) continue;
                return true;
            }
            return false;
        }
    }
}

